/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Vector;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.WfCastorHashMap;
import org.cristalise.kernel.lifecycle.WfVertexDef;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityDef
extends WfVertexDef
implements C2KLocalObject,
DescriptionObject {
    private static final Logger log = LoggerFactory.getLogger(ActivityDef.class);
    private Integer mVersion = null;
    public boolean changed = false;
    ItemPath itemPath;
    Schema actSchema;
    Script actScript;
    Query actQuery;
    StateMachine actStateMachine;

    public ActivityDef() {
        this.mErrors = new Vector(0, 1);
        this.setProperties(new WfCastorHashMap());
        this.setIsLayoutable(false);
    }

    @Override
    public void setID(int id) {
        super.setID(id);
        if (this.getName() == null || "".equals(this.getName())) {
            this.setName(String.valueOf(id));
        }
    }

    @Override
    public String getItemID() {
        return this.itemPath != null ? this.itemPath.getUUID().toString() : null;
    }

    @Override
    public void setVersion(Integer v) {
        this.mVersion = v;
    }

    @Override
    public Integer getVersion() {
        return this.mVersion;
    }

    @Override
    public String getErrors() {
        return super.getErrors();
    }

    @Override
    public boolean verify() {
        return true;
    }

    @Override
    public ClusterType getClusterType() {
        return null;
    }

    @Override
    public String getClusterPath() {
        return null;
    }

    public String getActName() {
        return this.getName();
    }

    public String getDescName() {
        return this.getName();
    }

    @Override
    public WfVertex instantiate(TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        return this.instantiate(this.getName(), transactionKey);
    }

    public WfVertex instantiate(String name, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        Activity act = new Activity();
        act.setName(name);
        this.configureInstance(act, transactionKey);
        if (this.getItemPath() != null) {
            act.setType(this.getItemID());
        }
        return act;
    }

    @Override
    public void configureInstance(WfVertex act, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        super.configureInstance(act, transactionKey);
        try {
            for (String collName : Gateway.getStorage().getClusterContents(this.itemPath, ClusterType.COLLECTION, transactionKey)) {
                log.debug("configureInstance(" + this.getName() + ") - Processing collection:" + collName);
                String verStr = this.mVersion == null || this.mVersion == -1 ? "last" : String.valueOf(this.mVersion);
                try {
                    Dependency dep = (Dependency)Gateway.getStorage().get(this.itemPath, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/" + verStr, transactionKey);
                    dep.addToVertexProperties(act.getProperties(), transactionKey);
                }
                catch (ObjectNotFoundException e) {
                    log.trace("Unavailable Collection path:" + this.itemPath + "/" + (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/" + verStr);
                }
                catch (PersistencyException e) {
                    log.error("Collection:" + collName, (Throwable)e);
                    throw new InvalidDataException("Collection:" + collName + " error:" + e.getMessage());
                }
            }
        }
        catch (PersistencyException e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException(e.getMessage());
        }
    }

    @Override
    public ItemPath getItemPath() {
        return this.itemPath;
    }

    @Override
    public void setItemPath(ItemPath path) {
        this.itemPath = path;
    }

    public Schema getSchema() throws InvalidDataException, ObjectNotFoundException {
        return this.getSchema(null);
    }

    public Schema getSchema(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        if (this.actSchema == null) {
            DescriptionObject[] descObjects = this.getBuiltInCollectionResource(BuiltInCollections.SCHEMA, transactionKey);
            if (descObjects.length > 0) {
                this.actSchema = (Schema)descObjects[0];
            }
            if (this.actSchema == null) {
                log.trace("getSchema(actName:" + this.getName() + ") - Loading ...");
                this.actSchema = LocalObjectLoader.getSchema(this.getProperties(), transactionKey);
            }
        }
        return this.actSchema;
    }

    public Script getScript() throws InvalidDataException, ObjectNotFoundException {
        return this.getScript(null);
    }

    public Script getScript(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        if (this.actScript == null) {
            DescriptionObject[] descObjects = this.getBuiltInCollectionResource(BuiltInCollections.SCRIPT, transactionKey);
            if (descObjects.length > 0) {
                this.actScript = (Script)descObjects[0];
            }
            if (this.actScript == null) {
                log.trace("getScript(actName:" + this.getName() + ") - Loading ...");
                this.actScript = LocalObjectLoader.getScript(this.getProperties(), transactionKey);
            }
        }
        return this.actScript;
    }

    public Query getQuery() throws InvalidDataException, ObjectNotFoundException {
        return this.getQuery(null);
    }

    public Query getQuery(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        if (this.actQuery == null) {
            DescriptionObject[] descObjects = this.getBuiltInCollectionResource(BuiltInCollections.QUERY, transactionKey);
            if (descObjects.length > 0) {
                this.actQuery = (Query)descObjects[0];
            }
            if (this.actQuery == null) {
                log.trace("getQuery(actName:" + this.getName() + ") - Loading ...");
                this.actQuery = LocalObjectLoader.getQuery(this.getProperties(), transactionKey);
            }
        }
        return this.actQuery;
    }

    public StateMachine getStateMachine() throws InvalidDataException, ObjectNotFoundException {
        return this.getStateMachine(null);
    }

    public StateMachine getStateMachine(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        if (this.actStateMachine == null) {
            DescriptionObject[] descObjects = this.getBuiltInCollectionResource(BuiltInCollections.STATE_MACHINE, transactionKey);
            if (descObjects.length > 0) {
                this.actStateMachine = (StateMachine)descObjects[0];
            }
            if (this.actStateMachine == null) {
                log.trace("getStateMachine(actName:" + this.getName() + ") - Loading ...");
                this.actStateMachine = LocalObjectLoader.getStateMachine(this.getProperties(), transactionKey);
            }
        }
        return this.actStateMachine;
    }

    protected DescriptionObject[] getBuiltInCollectionResource(BuiltInCollections collection, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        Dependency resColl;
        ArrayList<DescriptionObject> retArr = new ArrayList<DescriptionObject>();
        if (this.itemPath == null) {
            log.debug("getBuiltInCollectionResource(actName:{}, collection:{}) - itemPath is null! CANNOT resolve data in ClusterStorage", (Object)this.getName(), (Object)collection);
            return retArr.toArray(new DescriptionObject[0]);
        }
        log.info("getBuiltInCollectionResource(actName:{}) - Loading from collection:{}", (Object)this.getName(), (Object)collection);
        try {
            String clusterPath = (Object)((Object)ClusterType.COLLECTION) + "/" + (Object)((Object)collection) + "/" + (this.mVersion == null || this.mVersion == -1 ? "last" : String.valueOf(this.mVersion));
            String[] contents = Gateway.getStorage().getClusterContents(this.itemPath, clusterPath, transactionKey);
            if (contents == null || contents.length <= 0) {
                return retArr.toArray(new DescriptionObject[retArr.size()]);
            }
            resColl = (Dependency)Gateway.getStorage().get(this.itemPath, clusterPath, transactionKey);
        }
        catch (PersistencyException e) {
            log.error("Error loading description collection " + (Object)((Object)collection), (Throwable)e);
            throw new InvalidDataException("Error loading description collection " + (Object)((Object)collection));
        }
        block9: for (DependencyMember resMem : resColl.getMembers().list) {
            String resUUID = resMem.getChildUUID();
            Integer resVer = this.deriveVersionNumber(resMem.getBuiltInProperty(BuiltInVertexProperties.VERSION));
            if (resVer == null) {
                throw new InvalidDataException("Version is null for Item:" + this.itemPath + ", Collection:" + (Object)((Object)collection) + ", DependencyMember:" + resUUID);
            }
            if (collection != BuiltInCollections.ACTIVITY && retArr.size() > 0) {
                throw new InvalidDataException("actName:" + this.getName() + " has an invalid dependency:" + (Object)((Object)collection));
            }
            switch (collection) {
                case SCHEMA: {
                    retArr.add(LocalObjectLoader.getSchema(resUUID, resVer, transactionKey));
                    continue block9;
                }
                case SCRIPT: {
                    retArr.add(LocalObjectLoader.getScript(resUUID, resVer, transactionKey));
                    continue block9;
                }
                case QUERY: {
                    retArr.add(LocalObjectLoader.getQuery(resUUID, resVer, transactionKey));
                    continue block9;
                }
                case STATE_MACHINE: {
                    retArr.add(LocalObjectLoader.getStateMachine(resUUID, resVer, transactionKey));
                    continue block9;
                }
                case ACTIVITY: {
                    retArr.add(LocalObjectLoader.getActDef(resUUID, resVer, transactionKey));
                    continue block9;
                }
            }
            throw new InvalidDataException("");
        }
        return retArr.toArray(new DescriptionObject[retArr.size()]);
    }

    public void setSchema(Schema actSchema) {
        this.actSchema = actSchema;
    }

    public void setScript(Script actScript) {
        this.actScript = actScript;
    }

    public void setQuery(Query actQuery) {
        this.actQuery = actQuery;
    }

    public void setStateMachine(StateMachine actStateMachine) {
        this.actStateMachine = actStateMachine;
    }

    public Dependency makeDescCollection(BuiltInCollections collection, TransactionKey transactionKey, DescriptionObject ... descs) throws InvalidDataException {
        Dependency descDep = new Dependency(collection.getName());
        if (this.mVersion != null && this.mVersion > -1) {
            descDep.setVersion(this.mVersion);
        }
        for (DescriptionObject thisDesc : descs) {
            if (thisDesc == null) continue;
            try {
                DependencyMember descMem = descDep.addMember(thisDesc.getItemPath(), transactionKey);
                descMem.setBuiltInProperty(BuiltInVertexProperties.VERSION, thisDesc.getVersion());
            }
            catch (Exception e) {
                log.error("Problem creating description collection for " + thisDesc + " in " + this.getName(), (Throwable)e);
                throw new InvalidDataException(e.getMessage());
            }
        }
        return descDep;
    }

    @Override
    public CollectionArrayList makeDescCollections(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        CollectionArrayList retArr = new CollectionArrayList();
        retArr.put(this.makeDescCollection(BuiltInCollections.SCHEMA, transactionKey, this.getSchema(transactionKey)));
        retArr.put(this.makeDescCollection(BuiltInCollections.SCRIPT, transactionKey, this.getScript(transactionKey)));
        retArr.put(this.makeDescCollection(BuiltInCollections.QUERY, transactionKey, this.getQuery(transactionKey)));
        retArr.put(this.makeDescCollection(BuiltInCollections.STATE_MACHINE, transactionKey, this.getStateMachine(transactionKey)));
        return retArr;
    }

    @Override
    public void export(Writer imports, File dir, boolean shallow) throws InvalidDataException, ObjectNotFoundException, IOException {
        String actXML;
        String tc = BuiltInResources.ELEM_ACT_DESC_RESOURCE.getTypeCode();
        if (!shallow) {
            this.exportCollections(imports, dir);
        }
        try {
            actXML = Gateway.getMarshaller().marshall(this);
        }
        catch (Exception e) {
            log.error("Couldn't marshall activity def " + this.getActName(), (Throwable)e);
            throw new InvalidDataException("Couldn't marshall activity def " + this.getActName());
        }
        FileStringUtility.string2File(new File(new File(dir, tc), this.getActName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml"), actXML);
        if (imports != null) {
            imports.write("<Activity " + this.getExportAttributes(tc) + ">" + this.getExportCollections() + "</Activity>\n");
        }
    }

    protected void exportCollections(Writer imports, File dir) throws InvalidDataException, ObjectNotFoundException, IOException {
        if (this.getStateMachine(null) != null) {
            this.getStateMachine(null).export(imports, dir, true);
        }
        if (this.getSchema(null) != null) {
            this.getSchema(null).export(imports, dir, true);
        }
        if (this.getScript(null) != null) {
            this.getScript(null).export(imports, dir, true);
        }
        if (this.getQuery(null) != null) {
            this.getQuery(null).export(imports, dir, true);
        }
    }

    protected String getExportAttributes(String type) throws InvalidDataException, ObjectNotFoundException, IOException {
        if (Gateway.getProperties().getBoolean("Resource.useOldImportFormat", false)) {
            return "name=\"" + this.getActName() + "\" " + (this.getItemPath() == null ? "" : "id=\"" + this.getItemID() + "\" ") + (this.getVersion() == null ? "" : "version=\"" + this.getVersion() + "\" ") + "resource=\"boot/" + type + "/" + this.getActName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml\"";
        }
        return "name=\"" + this.getActName() + "\" " + (this.getItemPath() == null ? "" : "id=\"" + this.getItemID() + "\" ") + (this.getVersion() == null ? "" : "version=\"" + this.getVersion() + "\" ");
    }

    protected String getExportCollections() throws InvalidDataException, ObjectNotFoundException, IOException {
        return (this.getStateMachine(null) == null ? "" : "<StateMachine name=\"" + this.getStateMachine(null).getName() + "\" id=\"" + this.getStateMachine(null).getItemID() + "\" version=\"" + this.getStateMachine(null).getVersion() + "\"/>") + (this.getSchema(null) == null ? "" : "<Schema name=\"" + this.getSchema(null).getName() + "\" id=\"" + this.getSchema(null).getItemID() + "\" version=\"" + this.getSchema(null).getVersion() + "\"/>") + (this.getScript(null) == null ? "" : "<Script name=\"" + this.getScript(null).getName() + "\" id=\"" + this.getScript(null).getItemID() + "\" version=\"" + this.getScript(null).getVersion() + "\"/>") + (this.getQuery(null) == null ? "" : "<Query name=\"" + this.getQuery(null).getName() + "\" id=\"" + this.getQuery(null).getItemID() + "\" version=\"" + this.getQuery(null).getVersion() + "\"/>");
    }

    public String toString() {
        return this.getActName() + "(uuid:" + this.getItemPath() + ")";
    }
}

