/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Iterator;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Erase
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(Erase.class);
    public static final String description = "Deletes all domain paths (aliases), roles (if agent) and clusters for this item or agent.";

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, PersistencyException {
        log.debug("Called by {} on {}", (Object)agent.getAgentName(transactionKey), (Object)item);
        this.removeAliases(item, transactionKey);
        this.removeRolesIfAgent(item, transactionKey);
        Gateway.getStorage().removeCluster(item, "", transactionKey);
        log.info("Done item:" + item);
        return requestData;
    }

    private void removeAliases(ItemPath item, TransactionKey transactionKey) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException {
        Iterator<Path> domPaths = Gateway.getLookup().searchAliases(item, transactionKey);
        while (domPaths.hasNext()) {
            DomainPath path = (DomainPath)domPaths.next();
            Gateway.getLookupManager().delete(path, transactionKey);
        }
    }

    private void removeRolesIfAgent(ItemPath item, TransactionKey transactionKey) throws InvalidDataException, ObjectCannotBeUpdated, ObjectNotFoundException, CannotManageException {
        try {
            AgentPath targetAgent = new AgentPath(item);
            if (targetAgent.getAgentName(transactionKey) != null) {
                for (RolePath role : targetAgent.getRoles(transactionKey)) {
                    Gateway.getLookupManager().removeRole(targetAgent, role, transactionKey);
                }
            }
        }
        catch (InvalidAgentPathException invalidAgentPathException) {
            // empty catch block
        }
    }
}

