/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionMemberList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyDescription;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.predefined.item.CreateItemFromDescription;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCollectionsFromDescription
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(UpdateCollectionsFromDescription.class);
    public static final String description = "Updates the Collections of the Item from its description";

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException, ObjectCannotBeUpdated, ObjectNotFoundException, PersistencyException, CannotManageException, AccessRightsException {
        ItemPath descItemPath;
        Object[] inputs = UpdateCollectionsFromDescription.getDataList(requestData);
        if (inputs.length != 2 && inputs.length != 3) {
            throw new InvalidDataException("Invalid nunber of inputs:" + Arrays.toString(inputs));
        }
        String descPath = inputs[0];
        String descVer = inputs[1];
        CollectionMemberList newMembers = null;
        try {
            if (inputs.length == 3) {
                newMembers = (CollectionMemberList)Gateway.getMarshaller().unmarshall((String)inputs[2]);
            }
        }
        catch (IOException | MappingException | MarshalException | ValidationException e) {
            log.error("", e);
            throw new InvalidDataException(e.getMessage());
        }
        try {
            descItemPath = Gateway.getLookup().resolvePath(new DomainPath(descPath), transactionKey);
        }
        catch (InvalidItemPathException e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException(e.getMessage());
        }
        PropertyArrayList newItemProps = new PropertyArrayList();
        ArrayList<String> currentCollNames = new ArrayList<String>(Arrays.asList(Gateway.getStorage().getClusterContents(item, ClusterType.COLLECTION, transactionKey)));
        for (String collName : Gateway.getStorage().getClusterContents(descItemPath, ClusterType.COLLECTION, transactionKey)) {
            if (!currentCollNames.contains(collName)) {
                Collection<?> newColl = CreateItemFromDescription.instantiateCollection(collName, descItemPath, descVer, newItemProps, transactionKey);
                if (newColl == null) continue;
                Gateway.getStorage().put(item, newColl, transactionKey);
                continue;
            }
            currentCollNames.remove(collName);
            Dependency itemColl = UpdateCollectionsFromDescription.updateDependencyProperties(item, descItemPath, descVer, collName, transactionKey);
            UpdateCollectionsFromDescription.updateDependencyMembers(itemColl, newMembers);
            Gateway.getStorage().put(item, itemColl, transactionKey);
        }
        for (Property p : newItemProps.list) {
            PropertyUtility.writeProperty(item, p.getName(), p.getValue(), transactionKey);
        }
        for (String collName : currentCollNames) {
            Gateway.getStorage().remove(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName, transactionKey);
        }
        return requestData;
    }

    private static void updateDependencyMembers(Dependency itemColl, CollectionMemberList<DependencyMember> newMembers) throws ObjectNotFoundException, InvalidCollectionModification {
        for (DependencyMember currentMember : itemColl.getMembers().list) {
            DependencyMember newMember = null;
            if (newMembers != null) {
                newMember = newMembers.list.stream().filter(aMember -> currentMember.getItemPath().equals(aMember.getItemPath())).findAny().orElse(null);
            }
            currentMember.updatePropertieFromDescription(itemColl.getProperties(), newMember);
        }
    }

    private static Dependency updateDependencyProperties(ItemPath item, ItemPath descItemPath, String descVer, String collName, TransactionKey transactionKey) throws PersistencyException, ObjectNotFoundException {
        HashMap<String, Object> newCollProps = new HashMap<String, Object>();
        DependencyDescription collOfDesc = (DependencyDescription)Gateway.getStorage().get(descItemPath, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/" + descVer, transactionKey);
        newCollProps.putAll(collOfDesc.getProperties());
        PropertyDescriptionList itemPropertyList = PropertyUtility.getPropertyDescriptionOutcome(((DependencyMember)collOfDesc.getMembers().list.get(0)).getItemPath(), descVer, transactionKey);
        for (PropertyDescription prop : itemPropertyList.list) {
            if (!prop.getIsClassIdentifier() && !prop.isTransitive()) continue;
            newCollProps.put(prop.getName(), prop.getDefaultValue());
        }
        Dependency itemColl = (Dependency)Gateway.getStorage().get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/" + descVer, transactionKey);
        Iterator iterator = itemColl.getProperties().keySet().iterator();
        while (iterator.hasNext()) {
            String keyStr = (String)iterator.next();
            if (newCollProps.containsKey(keyStr)) continue;
            iterator.remove();
        }
        for (Map.Entry propDef : newCollProps.entrySet()) {
            itemColl.getProperties().put(propDef.getKey(), propDef.getValue());
        }
        if (itemPropertyList != null) {
            itemColl.setClassProps(itemPropertyList.getClassProps());
        }
        return itemColl;
    }
}

