/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateProperitesFromDescription
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(UpdateProperitesFromDescription.class);
    public static final String description = "Updates the Properties of the Item from its description";

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException, ObjectCannotBeUpdated, ObjectNotFoundException, PersistencyException, CannotManageException, AccessRightsException {
        String[] inputs = UpdateProperitesFromDescription.getDataList(requestData);
        String descPath = inputs[0];
        String descVer = inputs[1];
        PropertyArrayList initProps = inputs.length == 3 && StringUtils.isNotBlank((CharSequence)inputs[2]) ? this.unmarshallInitProperties(inputs[2]) : new PropertyArrayList();
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), item, inputs});
        PropertyDescriptionList newPropDesc = this.getPropertyDesc(descPath, descVer, transactionKey);
        for (String existingPropName : Gateway.getStorage().getClusterContents(item, ClusterType.PROPERTY, transactionKey)) {
            if (newPropDesc.definesProperty(existingPropName)) {
                Property existingProp = PropertyUtility.getProperty(item, existingPropName, transactionKey);
                if (existingProp.isMutable()) {
                    Property initProp = initProps.get(existingPropName);
                    if (initProp == null) continue;
                    existingProp.setValue(initProp.getValue());
                    Gateway.getStorage().put(item, existingProp, transactionKey);
                    continue;
                }
                String defaultValue = PropertyUtility.getDefaultValue(newPropDesc.list, existingPropName);
                if (!StringUtils.isNotBlank((CharSequence)defaultValue) || defaultValue.equals(existingProp.getValue())) continue;
                existingProp.setValue(defaultValue);
                Gateway.getStorage().put(item, existingProp, transactionKey);
                continue;
            }
            Gateway.getStorage().remove(item, (Object)((Object)ClusterType.PROPERTY) + "/" + existingPropName, transactionKey);
        }
        for (Property newProp : newPropDesc.instantiate((PropertyArrayList)initProps).list) {
            if (PropertyUtility.propertyExists(item, newProp.getName(), transactionKey)) continue;
            Gateway.getStorage().put(item, newProp, transactionKey);
        }
        return requestData;
    }

    private PropertyDescriptionList getPropertyDesc(String descPath, String descVer, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        ItemPath descItemPath;
        try {
            descItemPath = Gateway.getLookup().resolvePath(new DomainPath(descPath), transactionKey);
        }
        catch (InvalidItemPathException e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException(e.getMessage());
        }
        return PropertyUtility.getPropertyDescriptionOutcome(descItemPath, descVer, transactionKey);
    }

    protected PropertyArrayList unmarshallInitProperties(String initPropString) throws InvalidDataException {
        try {
            return (PropertyArrayList)Gateway.getMarshaller().unmarshall(initPropString);
        }
        catch (Exception e) {
            log.error("Initial property parameter was not a marshalled PropertyArrayList", (Throwable)e);
            throw new InvalidDataException("Initial property parameter was not a marshalled PropertyArrayList: " + initPropString);
        }
    }
}

