/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.server;

import java.io.IOException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.imports.ImportRole;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateNewRole
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(CreateNewRole.class);

    public CreateNewRole() {
        this.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, "Role");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, ObjectNotFoundException {
        try {
            ImportRole newRole = (ImportRole)Gateway.getMarshaller().unmarshall(requestData);
            if (Gateway.getLookup().exists(new RolePath(newRole.getName(), (boolean)newRole.jobList), transactionKey)) {
                throw new ObjectAlreadyExistsException("CreateNewRole: Role '" + newRole.getName() + "' already exists.");
            }
            newRole.create(agent, true, transactionKey);
            return requestData;
        }
        catch (IOException | MappingException | MarshalException | ValidationException e) {
            log.error("CreateNewRole: Couldn't unmarshall new Role: " + requestData, e);
            throw new InvalidDataException("CreateNewRole: Couldn't unmarshall new Role: " + requestData);
        }
    }
}

