/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.server;

import java.util.Arrays;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDomainContext
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(RemoveDomainContext.class);

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException {
        Object[] params = RemoveDomainContext.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), item, params});
        if (params.length != 1) {
            throw new InvalidDataException("RemoveDomainContext: Invalid parameters " + Arrays.toString(params));
        }
        DomainPath pathToDelete = new DomainPath(params[0]);
        if (!pathToDelete.exists(transactionKey)) {
            throw new ObjectNotFoundException("Context " + pathToDelete + " does not exist");
        }
        try {
            pathToDelete.getItemPath(transactionKey);
            throw new InvalidDataException("Path " + pathToDelete + " is an Entity. Use its own Erase step instead, or RemoveAgent.");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            if (Gateway.getLookup().getChildren(pathToDelete, transactionKey).hasNext()) {
                throw new ObjectCannotBeUpdated("Context " + pathToDelete + " is not empty. Cannot delete.");
            }
            Gateway.getLookupManager().delete(pathToDelete, transactionKey);
            return requestData;
        }
    }
}

