/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.routingHelpers;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.routingHelpers.ActivityDataHelper;
import org.cristalise.kernel.lifecycle.routingHelpers.BuiltInDataHelpers;
import org.cristalise.kernel.lifecycle.routingHelpers.DataHelper;
import org.cristalise.kernel.lifecycle.routingHelpers.PropertyDataHelper;
import org.cristalise.kernel.lifecycle.routingHelpers.ViewpointDataHelper;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHelperUtility {
    private static final Logger log = LoggerFactory.getLogger(DataHelperUtility.class);

    public static DataHelper getDataHelper(String id) throws InvalidDataException {
        Object configHelper = Gateway.getProperties().getObject("DataHelper." + id);
        if (configHelper != null) {
            if (configHelper instanceof DataHelper) {
                return (DataHelper)configHelper;
            }
            throw new InvalidDataException("Config value is not an instance of DataHelper - 'DataHelper." + id + "'=" + configHelper.toString());
        }
        switch (BuiltInDataHelpers.getValue(id)) {
            case VIEWPOINT_DH: {
                return new ViewpointDataHelper();
            }
            case PROPERTY_DH: {
                return new PropertyDataHelper();
            }
            case ACTIVITY_DH: {
                return new ActivityDataHelper();
            }
        }
        throw new InvalidDataException("UNKOWN DataHelper id:" + id);
    }

    public static Object evaluateValue(ItemPath itemPath, Object value, String actContext, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        if (value == null || !(value instanceof String) || !((String)value).contains("//")) {
            return value;
        }
        if (itemPath == null) {
            throw new InvalidDataException("DataHelper must have ItemPath initialised");
        }
        int i = ((String)value).indexOf("//");
        if (i == -1) {
            throw new InvalidDataException("DataHelperUtility.evaluateValue() - Cannot locate '//' in value:" + value);
        }
        String pathType = ((String)value).substring(0, i);
        String dataPath = ((String)value).substring(i + 2);
        log.debug("evaluateValue() - pathType:" + pathType + " dataPath:" + dataPath);
        DataHelper dataHelper = DataHelperUtility.getDataHelper(pathType);
        if (dataHelper != null) {
            return dataHelper.get(itemPath, actContext, dataPath, transactionKey);
        }
        return value;
    }
}

