/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.property;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.utils.CastorArrayList;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyDescriptionList
extends CastorArrayList<PropertyDescription>
implements DescriptionObject {
    private static final Logger log = LoggerFactory.getLogger(PropertyDescriptionList.class);
    String name;
    Integer version;
    ItemPath itemPath;

    public PropertyDescriptionList() {
    }

    public PropertyDescriptionList(String name, Integer version) {
        this.name = name;
        this.version = version;
    }

    public PropertyDescriptionList(ArrayList<PropertyDescription> aList) {
        super(aList);
    }

    public PropertyDescriptionList(String name, Integer version, ArrayList<PropertyDescription> aList) {
        super(aList);
        this.name = name;
        this.version = version;
    }

    public String getClassProps() {
        StringBuffer props = new StringBuffer();
        for (PropertyDescription element : this.list) {
            if (!element.getIsClassIdentifier()) continue;
            if (props.length() > 0) {
                props.append(",");
            }
            props.append(element.getName());
        }
        return props.toString();
    }

    public boolean setDefaultValue(String name, String value) {
        for (PropertyDescription element : this.list) {
            if (!element.getName().equals(name)) continue;
            element.setDefaultValue(value);
            return true;
        }
        return false;
    }

    public void add(String name, String value, boolean isClassId, boolean isMutable, boolean isTransitive) {
        for (PropertyDescription element : this.list) {
            if (!element.getName().equals(name)) continue;
            this.list.remove(element);
            break;
        }
        this.list.add(new PropertyDescription(name, value, isClassId, isMutable, isTransitive));
    }

    public void add(String name, String value, boolean isClassId, boolean isMutable) {
        this.add(name, value, isClassId, isMutable, false);
    }

    public void add(String name, String value) {
        this.add(name, value, false, true, false);
    }

    public boolean definesProperty(String name) {
        for (PropertyDescription element : this.list) {
            if (!element.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public PropertyArrayList instantiate(PropertyArrayList initProps) throws InvalidDataException {
        HashMap<String, String> validatedInitProps = new HashMap<String, String>();
        for (Property initProp : initProps.list) {
            if (!this.definesProperty(initProp.getName())) {
                throw new InvalidDataException("Property " + initProp.getName() + " has not been declared in the property descriptions");
            }
            validatedInitProps.put(initProp.getName(), initProp.getValue());
        }
        PropertyArrayList propInst = new PropertyArrayList();
        for (PropertyDescription pd : this.list) {
            String propName = pd.getName();
            String propVal = pd.getDefaultValue();
            if (validatedInitProps.containsKey(propName)) {
                propVal = (String)validatedInitProps.get(propName);
            }
            propInst.list.add(new Property(propName, propVal, pd.getIsMutable()));
        }
        return propInst;
    }

    @Override
    public String getItemID() {
        return this.itemPath != null ? this.itemPath.getUUID().toString() : null;
    }

    @Override
    public CollectionArrayList makeDescCollections(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        return new CollectionArrayList();
    }

    @Override
    public void export(Writer imports, File dir, boolean shallow) throws InvalidDataException, ObjectNotFoundException, IOException {
        String xml;
        String typeCode = BuiltInResources.PROPERTY_DESC_RESOURCE.getTypeCode();
        String fileName = this.getName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml";
        try {
            xml = Gateway.getMarshaller().marshall(this);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException("Couldn't marshall PropertyDescriptionList name:" + this.getName());
        }
        FileStringUtility.string2File(new File(new File(dir, typeCode), fileName), xml);
        if (imports == null) {
            return;
        }
        if (Gateway.getProperties().getBoolean("Resource.useOldImportFormat", false)) {
            imports.write("<Resource name='" + this.getName() + "' " + (this.getItemPath() == null ? "" : "id='" + this.getItemID() + "' ") + (this.getVersion() == null ? "" : "version='" + this.getVersion() + "' ") + "type='" + typeCode + "'>boot/" + typeCode + "/" + fileName + "</Resource>\n");
        } else {
            imports.write("<PropertyDescriptionResource name='" + this.getName() + "' " + (this.getItemPath() == null ? "" : "id='" + this.getItemID() + "' ") + (this.getVersion() == null ? "" : "version='" + this.getVersion() + "'") + "/>\n");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public ItemPath getItemPath() {
        return this.itemPath;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public void setItemPath(ItemPath itemPath) {
        this.itemPath = itemPath;
    }
}

