/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.property;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtility {
    private static final Logger log = LoggerFactory.getLogger(PropertyUtility.class);

    public static String getValue(ArrayList<PropertyDescription> pdlist, String name) {
        return PropertyUtility.getDefaultValue(pdlist, name);
    }

    public static String getDefaultValue(ArrayList<PropertyDescription> pdlist, String name) {
        for (PropertyDescription pd : pdlist) {
            if (!name.equalsIgnoreCase(pd.getName())) continue;
            return pd.getDefaultValue();
        }
        return null;
    }

    public static boolean propertyExists(ItemPath itemPath, String propName, TransactionKey transactionKey) {
        try {
            String[] contents;
            for (String name : contents = Gateway.getStorage().getClusterContents(itemPath, ClusterType.PROPERTY, transactionKey)) {
                if (!name.equals(propName)) continue;
                return true;
            }
        }
        catch (PersistencyException e) {
            log.error("", (Throwable)e);
        }
        return false;
    }

    public static Property getProperty(ItemPath itemPath, BuiltInItemProperties prop, TransactionKey transactionKey) throws ObjectNotFoundException {
        return PropertyUtility.getProperty(itemPath, prop.getName(), transactionKey);
    }

    public static Property getProperty(ItemPath itemPath, String propName, TransactionKey transactionKey) throws ObjectNotFoundException {
        try {
            return (Property)Gateway.getStorage().get(itemPath, (Object)((Object)ClusterType.PROPERTY) + "/" + propName, transactionKey);
        }
        catch (PersistencyException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static String getNames(ArrayList<PropertyDescription> pdlist) {
        StringBuffer names = new StringBuffer();
        for (PropertyDescription value : pdlist) {
            names.append(value.getDefaultValue()).append(" ");
        }
        return names.toString();
    }

    public static String getClassIdNames(ArrayList<PropertyDescription> pdlist) {
        StringBuffer names = new StringBuffer();
        Iterator<PropertyDescription> iter = pdlist.iterator();
        while (iter.hasNext()) {
            PropertyDescription pd = iter.next();
            if (pd.getIsClassIdentifier()) {
                names.append(pd.getName());
            }
            if (!iter.hasNext()) continue;
            names.append(",");
        }
        return names.toString();
    }

    public static PropertyDescriptionList getPropertyDescriptionOutcome(ItemPath itemPath, String descVer, TransactionKey transactionKey) throws ObjectNotFoundException {
        try {
            if (PropertyUtility.getProperty(itemPath, BuiltInItemProperties.TYPE, transactionKey).getValue().equals(BuiltInResources.PROPERTY_DESC_RESOURCE.getSchemaName())) {
                String name = PropertyUtility.getProperty(itemPath, BuiltInItemProperties.NAME, transactionKey).getValue();
                int version = PropertyUtility.getVersionID(itemPath, descVer, BuiltInResources.PROPERTY_DESC_RESOURCE.getSchemaName(), transactionKey);
                return LocalObjectLoader.getPropertyDescriptionList(name, version, transactionKey);
            }
            Outcome outc = (Outcome)Gateway.getStorage().get(itemPath, (Object)((Object)ClusterType.VIEWPOINT) + "/PropertyDescription/" + descVer + "/data", transactionKey);
            return (PropertyDescriptionList)Gateway.getMarshaller().unmarshall(outc.getData());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new ObjectNotFoundException("Could not fetch PropertyDescription from '" + itemPath + "' error:" + e.getMessage());
        }
    }

    private static int getVersionID(ItemPath itemPath, String descVer, String schema, TransactionKey transactionKey) throws PersistencyException, ObjectNotFoundException {
        int version = 0;
        if ("last".equals(descVer)) {
            String[] views = Gateway.getStorage().getClusterContents(itemPath, (Object)((Object)ClusterType.VIEWPOINT) + "/" + schema, transactionKey);
            version = -1;
            for (int i = 0; i < views.length; ++i) {
                int aVersion;
                if (!StringUtils.isNumeric((CharSequence)views[i]) || version >= (aVersion = Integer.parseInt(views[i]))) continue;
                version = aVersion;
            }
            if (version == -1) {
                throw new ObjectNotFoundException(String.format("itemPath:{} schema:{} does not have any version", itemPath, schema));
            }
        } else if (StringUtils.isNumeric((CharSequence)descVer)) {
            version = Integer.parseInt(descVer);
        } else {
            throw new ObjectNotFoundException("descVer:'" + descVer + "' must be 'last' or positive integer");
        }
        return version;
    }

    public static CastorHashMap convertTransitiveProperties(PropertyDescriptionList pdList) {
        CastorHashMap props = new CastorHashMap();
        for (int i = 0; i < pdList.list.size(); ++i) {
            PropertyDescription pd = (PropertyDescription)pdList.list.get(i);
            if (!pd.isTransitive()) continue;
            props.put(pd.getName(), pd.getDefaultValue());
        }
        return props;
    }

    public static void writeProperty(ItemPath item, BuiltInItemProperties prop, String value, TransactionKey transactionKey) throws PersistencyException, ObjectCannotBeUpdated, ObjectNotFoundException {
        PropertyUtility.writeProperty(item, prop.getName(), value, transactionKey);
    }

    public static void writeProperty(ItemPath item, String name, String value, TransactionKey transactionKey) throws PersistencyException, ObjectCannotBeUpdated, ObjectNotFoundException {
        Property prop = (Property)Gateway.getStorage().get(item, (Object)((Object)ClusterType.PROPERTY) + "/" + name, transactionKey);
        if (!prop.isMutable()) {
            throw new ObjectCannotBeUpdated("WriteProperty: Property '" + name + "' is not mutable.");
        }
        if (!value.equals(prop.getValue())) {
            prop.setValue(value);
            Gateway.getStorage().put(item, prop, transactionKey);
        }
    }

    public static boolean checkProperty(ItemPath item, BuiltInItemProperties prop, TransactionKey transactionKey) {
        return PropertyUtility.checkProperty(item, prop.getName(), transactionKey);
    }

    public static boolean checkProperty(ItemPath item, String name, TransactionKey transactionKey) {
        try {
            for (String key : Gateway.getStorage().getClusterContents(item, ClusterType.PROPERTY, transactionKey)) {
                if (!key.equals(name)) continue;
                return true;
            }
        }
        catch (PersistencyException persistencyException) {
            // empty catch block
        }
        return false;
    }

    public static String getPropertyValue(ItemPath item, BuiltInItemProperties prop, String defaultValue, TransactionKey transactionKey) {
        return PropertyUtility.getPropertyValue(item, prop.getName(), defaultValue, transactionKey);
    }

    public static String getPropertyValue(ItemPath item, String name, String defaultValue, TransactionKey transactionKey) {
        try {
            if (PropertyUtility.checkProperty(item, name, transactionKey)) {
                return PropertyUtility.getProperty(item, name, transactionKey).getValue();
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return defaultValue;
    }
}

