/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportRole
extends ModuleImport {
    private static final Logger log = LoggerFactory.getLogger(ImportRole.class);
    public Boolean jobList;
    public ArrayList<String> permissions = new ArrayList();
    public RolePath rolePath = null;

    @Override
    public Path create(AgentPath agentPath, boolean reset, TransactionKey transactionKey) throws ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, ObjectNotFoundException {
        this.rolePath = new RolePath(this.name.split("/"), this.jobList == null ? false : this.jobList, this.permissions);
        if (Gateway.getLookup().exists(this.rolePath, transactionKey)) {
            if (this.jobList != null) {
                this.update(agentPath, transactionKey);
            }
        } else {
            log.info("ImportRole.create() - Creating Role:" + this.name + " joblist:" + this.jobList);
            this.rolePath.getParent(transactionKey);
            Gateway.getLookupManager().createRole(this.rolePath, transactionKey);
            Gateway.getLookupManager().setPermissions(this.rolePath, this.rolePath.getPermissionsList(), transactionKey);
        }
        return this.rolePath;
    }

    public void update(AgentPath agentPath, TransactionKey transactionKey) throws ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, ObjectNotFoundException {
        RolePath rolePath = new RolePath(this.name.split("/"), this.jobList == null ? false : this.jobList, this.permissions);
        if (!Gateway.getLookup().exists(rolePath, transactionKey)) {
            throw new ObjectNotFoundException("Role '" + rolePath.getName() + "' does NOT exists.");
        }
        Gateway.getLookupManager().setHasJobList(rolePath, this.jobList == null ? false : this.jobList, transactionKey);
        Gateway.getLookupManager().setPermissions(rolePath, rolePath.getPermissionsList(), transactionKey);
    }

    public static ImportRole getImportRole(RolePath rp) {
        ImportRole ir = new ImportRole();
        ir.setName(rp.getName());
        ir.jobList = rp.hasJobList();
        ir.permissions = (ArrayList)rp.getPermissionsList();
        return ir;
    }

    @Override
    public ItemPath getItemPath(TransactionKey transactionKey) {
        return this.getItemPath();
    }
}

