/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.CastorHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNewSlot
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(AddNewSlot.class);

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        String collName;
        ItemPath descKey = null;
        Object descVer = "last";
        Object[] params = AddNewSlot.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), item, params});
        try {
            collName = params[0];
            if (params.length > 1 && params[1].length() > 0) {
                try {
                    descKey = new ItemPath((String)params[1]);
                }
                catch (InvalidItemPathException e) {
                    descKey = new DomainPath((String)params[1]).getItemPath(transactionKey);
                }
            }
            if (params.length > 2 && ((String)params[2]).length() > 0) {
                descVer = params[2];
            }
        }
        catch (Exception e) {
            throw new InvalidDataException("AddNewSlot: Invalid parameters " + Arrays.toString(params));
        }
        C2KLocalObject collObj = Gateway.getStorage().get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/last", transactionKey);
        if (!(collObj instanceof Aggregation)) {
            throw new InvalidDataException("AddNewSlot operates on Aggregation only.");
        }
        Aggregation agg = (Aggregation)collObj;
        CastorHashMap props = new CastorHashMap();
        StringBuffer classProps = new StringBuffer();
        if (descKey != null) {
            PropertyDescriptionList propList = PropertyUtility.getPropertyDescriptionOutcome(descKey, (String)descVer, transactionKey);
            for (PropertyDescription pd : propList.list) {
                props.put(pd.getName(), pd.getDefaultValue());
                if (!pd.getIsClassIdentifier()) continue;
                classProps.append(classProps.length() > 0 ? "," : "").append(pd.getName());
            }
        }
        agg.addSlot(props, classProps.toString());
        Gateway.getStorage().put(item, agg, transactionKey);
        return requestData;
    }
}

