/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.predefined.AddC2KObject;
import org.cristalise.kernel.lifecycle.instance.predefined.AddDomainPath;
import org.cristalise.kernel.lifecycle.instance.predefined.AddMemberToCollection;
import org.cristalise.kernel.lifecycle.instance.predefined.AddMembersToCollection;
import org.cristalise.kernel.lifecycle.instance.predefined.AddNewCollectionDescription;
import org.cristalise.kernel.lifecycle.instance.predefined.AddNewSlot;
import org.cristalise.kernel.lifecycle.instance.predefined.AssignItemToSlot;
import org.cristalise.kernel.lifecycle.instance.predefined.ChangeName;
import org.cristalise.kernel.lifecycle.instance.predefined.ClearSlot;
import org.cristalise.kernel.lifecycle.instance.predefined.CreateAgentFromDescription;
import org.cristalise.kernel.lifecycle.instance.predefined.CreateNewCollectionVersion;
import org.cristalise.kernel.lifecycle.instance.predefined.Erase;
import org.cristalise.kernel.lifecycle.instance.predefined.Import;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.predefined.RemoveC2KObject;
import org.cristalise.kernel.lifecycle.instance.predefined.RemoveDomainPath;
import org.cristalise.kernel.lifecycle.instance.predefined.RemoveSlotFromCollection;
import org.cristalise.kernel.lifecycle.instance.predefined.RemoveViewpoint;
import org.cristalise.kernel.lifecycle.instance.predefined.ReplaceDomainWorkflow;
import org.cristalise.kernel.lifecycle.instance.predefined.UpdateCollectionsFromDescription;
import org.cristalise.kernel.lifecycle.instance.predefined.UpdateDependencyMember;
import org.cristalise.kernel.lifecycle.instance.predefined.UpdateProperitesFromDescription;
import org.cristalise.kernel.lifecycle.instance.predefined.WriteProperty;
import org.cristalise.kernel.lifecycle.instance.predefined.WriteViewpoint;

public abstract class PredefinedStepContainer
extends CompositeActivity {
    protected int num = 0;

    public PredefinedStepContainer() {
        this.setName("predefined");
        this.getProperties().put("Description", "Contains all predefined Steps");
        this.createChildren();
    }

    public void createChildren() {
        this.predInit("AddDomainPath", "Adds a new path to this item in the LDAP domain tree", (PredefinedStep)new AddDomainPath());
        this.predInit("RemoveDomainPath", "Removes an existing path to this item from the LDAP domain tree", (PredefinedStep)new RemoveDomainPath());
        this.predInit("ReplaceDomainWorkflow", "Replaces the domain CA with the supplied one. Used by the GUI to save new Wf layout", (PredefinedStep)new ReplaceDomainWorkflow());
        this.predInit("AddC2KObject", "Adds or overwrites a C2Kernel object for this Item", (PredefinedStep)new AddC2KObject());
        this.predInit("RemoveC2KObject", "Removes the named C2Kernel object from this Item.", (PredefinedStep)new RemoveC2KObject());
        this.predInit("WriteProperty", "Writes a property to the Item", (PredefinedStep)new WriteProperty());
        this.predInit("WriteViewpoint", "Writes a viewpoint to the Item", (PredefinedStep)new WriteViewpoint());
        this.predInit(RemoveViewpoint.class.getSimpleName(), "Removes a viewpoint from the Item", (PredefinedStep)new RemoveViewpoint());
        this.predInit("AddNewCollectionDescription", "Creates a new collection description in this Item", (PredefinedStep)new AddNewCollectionDescription());
        this.predInit("CreateNewCollectionVersion", "Creates a new numbered collection version in this Item from the current one.", (PredefinedStep)new CreateNewCollectionVersion());
        this.predInit("AddNewSlot", "Creates a new slot in the given aggregation, that holds instances of the item description of the given key", (PredefinedStep)new AddNewSlot());
        this.predInit("AssignItemToSlot", "Assigns the referenced item to a pre-existing slot in an aggregation", (PredefinedStep)new AssignItemToSlot());
        this.predInit("ClearSlot", "Clears an aggregation member slot, given a slot no or item uuid", (PredefinedStep)new ClearSlot());
        this.predInit("RemoveSlotFromCollection", "Removes the given slot from the collection", (PredefinedStep)new RemoveSlotFromCollection());
        this.predInit("UpdateDependencyMember", "", (PredefinedStep)new UpdateDependencyMember());
        this.predInit("AddMemberToCollection", "Creates a new member slot for the given item in a dependency, and assigns the item", (PredefinedStep)new AddMemberToCollection());
        this.predInit("AddMembersToCollection", "Adds members to a given item", (PredefinedStep)new AddMembersToCollection());
        this.predInit("Import", "Imports an outcome into the Item, with a given schema and viewpoint", (PredefinedStep)new Import());
        this.predInit("CreateAgentFromDescription", "Create a new agent using this item as its description", (PredefinedStep)new CreateAgentFromDescription());
        this.predInit(ChangeName.class.getSimpleName(), "Removes Items old Name, add the new Name and changes the Name property", (PredefinedStep)new ChangeName());
        this.predInit(Erase.class.getSimpleName(), "Deletes all domain paths (aliases), roles (if agent) and clusters for this item or agent.", (PredefinedStep)new Erase());
        this.predInit(UpdateCollectionsFromDescription.class.getSimpleName(), "Updates the Collections of the Item from its description", (PredefinedStep)new UpdateCollectionsFromDescription());
        this.predInit(UpdateProperitesFromDescription.class.getSimpleName(), "Updates the Properties of the Item from its description", (PredefinedStep)new UpdateProperitesFromDescription());
    }

    public void predInit(Class<?> clazz, String description, PredefinedStep act) {
        this.predInit(clazz.getSimpleName(), description, act);
    }

    public void predInit(String alias, String Description, PredefinedStep act) {
        act.setName(alias);
        act.setType(alias);
        act.getProperties().put("Description", Description);
        act.setCentrePoint(new GraphPoint());
        act.setIsPredefined(true);
        this.addChild(act, new GraphPoint(100, 75 * ++this.num));
    }

    @Override
    public boolean verify() {
        return true;
    }

    @Override
    public String getErrors() {
        return "predefined";
    }

    @Override
    public boolean getActive() {
        return true;
    }
}

