/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.item;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.CollectionDescription;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.CorbaServer;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.AgentPredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.item.ItemPredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateItemFromDescription
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(CreateItemFromDescription.class);

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath descItemPath, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException, ObjectAlreadyExistsException, CannotManageException, ObjectCannotBeUpdated, PersistencyException {
        String[] input = CreateItemFromDescription.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), descItemPath, input});
        String newName = input[0];
        String domPath = input[1];
        String descVer = input.length > 2 && StringUtils.isNotBlank((CharSequence)input[2]) ? input[2] : "last";
        PropertyArrayList initProps = input.length > 3 && StringUtils.isNotBlank((CharSequence)input[3]) ? this.unmarshallInitProperties(input[3]) : new PropertyArrayList();
        String outcome = input.length > 4 && StringUtils.isNotBlank((CharSequence)input[4]) ? input[4] : "";
        DomainPath context = new DomainPath(new DomainPath(domPath), newName);
        if (context.exists(transactionKey)) {
            throw new ObjectAlreadyExistsException("The path " + context + " exists already.");
        }
        ItemPath newItemPath = new ItemPath();
        log.info("Creating Item name:{} uuid:{} transactionKey:{}", new Object[]{newName, newItemPath, transactionKey});
        CorbaServer factory = Gateway.getCorbaServer();
        if (factory == null) {
            throw new CannotManageException("This process cannot create new Items");
        }
        factory.createItem(newItemPath, transactionKey);
        Gateway.getLookupManager().add(newItemPath, transactionKey);
        this.initialiseItem(newItemPath, agent, descItemPath, initProps, outcome, newName, descVer, context, newItemPath, transactionKey);
        return requestData;
    }

    protected void initialiseItem(ItemPath newItem, AgentPath agent, ItemPath descItemPath, PropertyArrayList initProps, String outcome, String newName, String descVer, DomainPath context, ItemPath newItemPath, TransactionKey transactionKey) throws ObjectCannotBeUpdated, CannotManageException, InvalidDataException, ObjectAlreadyExistsException, PersistencyException, ObjectNotFoundException {
        log.info("initialiseItem() - Initializing Item:" + newName);
        try {
            PropertyArrayList newProps = this.instantiateProperties(descItemPath, descVer, initProps, newName, agent, transactionKey);
            CollectionArrayList newColls = this.instantiateCollections(descItemPath, descVer, newProps, transactionKey);
            CompositeActivity newWorkflow = this.instantiateWorkflow(descItemPath, descVer, transactionKey);
            Viewpoint newViewpoint = this.instantiateViewpoint(descItemPath, descVer, transactionKey);
            CreateItemFromDescription.storeItem(agent, newItem, newProps, newColls, newWorkflow, newViewpoint, outcome, transactionKey);
        }
        catch (IOException | MappingException | MarshalException | ValidationException e) {
            log.error("", e);
            Gateway.getLookupManager().delete(newItemPath, transactionKey);
            throw new InvalidDataException("CreateItemFromDescription: Problem initializing new Item. See log: " + e.getMessage());
        }
        catch (InvalidDataException | ObjectNotFoundException | PersistencyException e) {
            log.error("", e);
            Gateway.getLookupManager().delete(newItemPath, transactionKey);
            throw e;
        }
        log.info("Creating " + context);
        context.setItemPath(newItemPath);
        Gateway.getLookupManager().add(context, transactionKey);
    }

    protected PropertyArrayList unmarshallInitProperties(String initPropString) throws InvalidDataException {
        try {
            return (PropertyArrayList)Gateway.getMarshaller().unmarshall(initPropString);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException("Initial property parameter was not a marshalled PropertyArrayList: " + initPropString);
        }
    }

    protected PropertyArrayList instantiateProperties(ItemPath descItemPath, String descVer, PropertyArrayList initProps, String newName, AgentPath agent, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        PropertyDescriptionList pdList = PropertyUtility.getPropertyDescriptionOutcome(descItemPath, descVer, transactionKey);
        PropertyArrayList props = pdList.instantiate(initProps);
        boolean foundName = false;
        for (Property prop : props.list) {
            if (!prop.getName().equals(BuiltInItemProperties.NAME.toString())) continue;
            foundName = true;
            prop.setValue(newName);
            break;
        }
        if (!foundName) {
            props.list.add(new Property(BuiltInItemProperties.NAME, newName, true));
        }
        props.list.add(new Property(BuiltInItemProperties.CREATOR, agent.getAgentName(transactionKey), false));
        return props;
    }

    protected CompositeActivity instantiateWorkflow(ItemPath descItemPath, String descVer, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException, PersistencyException {
        Collection thisCol = (Collection)Gateway.getStorage().get(descItemPath, (Object)((Object)ClusterType.COLLECTION) + "/" + (Object)((Object)BuiltInCollections.WORKFLOW) + "/" + descVer, transactionKey);
        CollectionMember wfMember = (CollectionMember)thisCol.getMembers().list.get(0);
        String wfDefName = wfMember.resolveItem(transactionKey).getName();
        Object wfVerObj = wfMember.getProperties().getBuiltInProperty(BuiltInVertexProperties.VERSION);
        if (wfVerObj == null || String.valueOf(wfVerObj).length() == 0) {
            throw new InvalidDataException("Workflow version number not set");
        }
        try {
            Integer wfDefVer = Integer.parseInt(wfVerObj.toString());
            if (wfDefName == null) {
                throw new InvalidDataException("No workflow given or defined");
            }
            CompositeActivityDef wfDef = (CompositeActivityDef)LocalObjectLoader.getActDef(wfDefName, wfDefVer, transactionKey);
            return (CompositeActivity)wfDef.instantiate(transactionKey);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Invalid workflow version number: " + wfVerObj.toString());
        }
        catch (ClassCastException ex) {
            log.error("Activity def '" + wfDefName + "' was not Composite", (Throwable)ex);
            throw new InvalidDataException("Activity def '" + wfDefName + "' was not Composite");
        }
    }

    protected CollectionArrayList instantiateCollections(ItemPath descItemPath, String descVer, PropertyArrayList newProps, TransactionKey transactionKey) throws ObjectNotFoundException, PersistencyException, InvalidDataException {
        String[] collNames;
        CollectionArrayList colls = new CollectionArrayList();
        for (String collName : collNames = Gateway.getStorage().getClusterContents(descItemPath, ClusterType.COLLECTION, transactionKey)) {
            Collection<?> newColl = CreateItemFromDescription.instantiateCollection(collName, descItemPath, descVer, newProps, transactionKey);
            if (newColl == null) continue;
            colls.put(newColl);
        }
        return colls;
    }

    public static Collection<?> instantiateCollection(String collName, ItemPath descItemPath, String descVer, PropertyArrayList newProps, TransactionKey transactionKey) throws PersistencyException, ObjectNotFoundException, InvalidDataException {
        Collection collOfDesc = (Collection)Gateway.getStorage().get(descItemPath, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/" + descVer, transactionKey);
        Collection newColl = null;
        if (collOfDesc instanceof CollectionDescription) {
            log.info("Instantiating CollectionDescription:" + collName);
            CollectionDescription collDesc = (CollectionDescription)((Object)collOfDesc);
            newColl = collDesc.newInstance(transactionKey);
        } else if (collOfDesc instanceof Dependency) {
            log.info("Instantiating Dependency:" + collName);
            ((Dependency)collOfDesc).addToItemProperties(newProps, transactionKey);
        } else {
            throw new InvalidDataException("CANNOT instantiate collection:" + collName + " class:" + collOfDesc.getClass().getName());
        }
        return newColl;
    }

    protected Viewpoint instantiateViewpoint(ItemPath descItemPath, String descVer, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException, PersistencyException {
        String collPath = (Object)((Object)ClusterType.COLLECTION) + "/" + (Object)((Object)BuiltInCollections.SCHEMA_INITIALISE);
        if (Gateway.getStorage().getClusterContents(descItemPath, collPath, transactionKey).length == 0) {
            return null;
        }
        Collection thisCol = (Collection)Gateway.getStorage().get(descItemPath, collPath + "/" + descVer, transactionKey);
        CollectionMember schemaMember = (CollectionMember)thisCol.getMembers().list.get(0);
        String schemaName = schemaMember.resolveItem(transactionKey).getName();
        Object schemaVerObj = schemaMember.getProperties().getBuiltInProperty(BuiltInVertexProperties.VERSION);
        Object viewNameObj = schemaMember.getProperties().get("View");
        if (schemaName == null) {
            throw new InvalidDataException("No schema given or defined");
        }
        if (schemaVerObj == null || String.valueOf(schemaVerObj).length() == 0) {
            throw new InvalidDataException("schema version number not set");
        }
        try {
            Integer schemaVer = Integer.parseInt(schemaVerObj.toString());
            String viewName = viewNameObj == null ? "last" : viewNameObj.toString();
            return new Viewpoint(new ItemPath(), schemaName, viewName, schemaVer, -1);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Invalid schema version number: " + schemaVerObj.toString());
        }
    }

    public static void storeItem(AgentPath agent, ItemPath item, PropertyArrayList props, CollectionArrayList colls, CompositeActivity ca, Viewpoint initViewpoint, String initOutcomeString, TransactionKey transactionKey) throws PersistencyException, ObjectNotFoundException, InvalidDataException, MarshalException, ValidationException, IOException, MappingException {
        PredefinedStepContainer cont;
        for (Property thisProp : props.list) {
            Gateway.getStorage().put(item, thisProp, transactionKey);
        }
        History hist = new History(item, transactionKey);
        Schema initSchema = LocalObjectLoader.getSchema("ItemInitialization", 0, transactionKey);
        Outcome initOutcome = new Outcome(0, Gateway.getMarshaller().marshall(props), initSchema);
        StateMachine predefSm = LocalObjectLoader.getStateMachine("PredefinedStep", 0, transactionKey);
        Event newEvent = hist.addEvent(agent, null, "", "Initialize", "", "", initSchema, predefSm, 0, "last");
        initOutcome.setID(newEvent.getID());
        Viewpoint newLastView = new Viewpoint(item, initSchema, "last", newEvent.getID());
        Gateway.getStorage().put(item, initOutcome, transactionKey);
        Gateway.getStorage().put(item, newLastView, transactionKey);
        if (initViewpoint != null) {
            Schema schema = LocalObjectLoader.getSchema(initViewpoint.getSchemaName(), initViewpoint.getSchemaVersion(), transactionKey);
            Outcome outcome = new Outcome(-1, initOutcomeString, schema);
            outcome.validateAndCheck();
            initViewpoint.setItemPath(item);
            Event intiEvent = hist.addEvent(agent, null, "", "Constructor", "", "", schema, predefSm, 0, initViewpoint.getName());
            initViewpoint.setEventId(intiEvent.getID());
            outcome.setID(intiEvent.getID());
            Gateway.getStorage().put(item, outcome, transactionKey);
            Gateway.getStorage().put(item, initViewpoint, transactionKey);
        }
        if (colls != null) {
            for (Collection thisColl : colls.list) {
                Gateway.getStorage().put(item, thisColl, transactionKey);
            }
        }
        Workflow lc = null;
        PredefinedStepContainer predefinedStepContainer = cont = item instanceof AgentPath ? new AgentPredefinedStepContainer() : new ItemPredefinedStepContainer();
        if (ca == null) {
            log.warn("storeItem({}) - CompositeActivity was null. Creating workflow with empty domain CompAct.", (Object)item);
            lc = new Workflow(new CompositeActivity(), cont);
        } else {
            lc = new Workflow(ca, cont);
        }
        lc.initialise(item, agent, transactionKey);
        Gateway.getStorage().put(item, lc, transactionKey);
    }
}

