/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.server;

import java.io.IOException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.imports.ImportItem;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateNewItem
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(CreateNewItem.class);

    public CreateNewItem() {
        this.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, "Item");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectCannotBeUpdated, ObjectNotFoundException, CannotManageException, ObjectAlreadyExistsException, InvalidCollectionModification {
        try {
            ImportItem newItem = (ImportItem)Gateway.getMarshaller().unmarshall(requestData);
            newItem.create(agent, false, transactionKey);
            return requestData;
        }
        catch (IOException | MappingException | MarshalException | ValidationException e) {
            log.error("CreateNewItem: Couldn't unmarshall new Item: " + requestData, e);
            throw new InvalidDataException("CreateNewItem: Couldn't unmarshall new Item: " + requestData);
        }
        catch (PersistencyException e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException("CreateNewItem: " + e.getMessage());
        }
    }
}

