/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.ActDefCache;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.PropertyDescriptionCache;
import org.cristalise.kernel.utils.QueryCache;
import org.cristalise.kernel.utils.SchemaCache;
import org.cristalise.kernel.utils.ScriptCache;
import org.cristalise.kernel.utils.StateMachineCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalObjectLoader {
    private static final Logger log = LoggerFactory.getLogger(LocalObjectLoader.class);
    private static ActDefCache actCache = new ActDefCache(null);
    private static ActDefCache compActCache = new ActDefCache(true);
    private static ActDefCache elemActCache = new ActDefCache(false);
    private static StateMachineCache smCache = new StateMachineCache();
    private static SchemaCache schCache = new SchemaCache();
    private static ScriptCache scrCache = new ScriptCache();
    private static QueryCache queryCache = new QueryCache();
    private static PropertyDescriptionCache propDescCache = new PropertyDescriptionCache();

    public static Script getScript(String scriptName, int scriptVersion) throws ObjectNotFoundException, InvalidDataException {
        return LocalObjectLoader.getScript(scriptName, scriptVersion, null);
    }

    public static Script getScript(String scriptName, int scriptVersion, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getScript({} v{}) - transactionKey:{}", new Object[]{scriptName, scriptVersion, transactionKey});
        return (Script)scrCache.get(scriptName, scriptVersion, transactionKey);
    }

    public static Script getScript(CastorHashMap properties) throws InvalidDataException, ObjectNotFoundException {
        return LocalObjectLoader.getScript(properties, null);
    }

    public static Script getScript(CastorHashMap properties, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        return (Script)LocalObjectLoader.getDescObjectByProperty(properties, BuiltInVertexProperties.SCRIPT_NAME, BuiltInVertexProperties.SCRIPT_VERSION, transactionKey);
    }

    public static Query getQuery(String queryName, int queryVersion) throws ObjectNotFoundException, InvalidDataException {
        return LocalObjectLoader.getQuery(queryName, queryVersion, null);
    }

    public static Query getQuery(String queryName, int queryVersion, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getQuery({} v{}) - transactionKey:{}", new Object[]{queryName, queryVersion, transactionKey});
        return (Query)queryCache.get(queryName, queryVersion, transactionKey);
    }

    public static Query getQuery(CastorHashMap properties) throws InvalidDataException, ObjectNotFoundException {
        return LocalObjectLoader.getQuery(properties, null);
    }

    public static Query getQuery(CastorHashMap properties, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        return (Query)LocalObjectLoader.getDescObjectByProperty(properties, BuiltInVertexProperties.QUERY_NAME, BuiltInVertexProperties.QUERY_VERSION, transactionKey);
    }

    public static Schema getSchema(String schemaName, int schemaVersion) throws ObjectNotFoundException, InvalidDataException {
        return LocalObjectLoader.getSchema(schemaName, schemaVersion, null);
    }

    public static Schema getSchema(String schemaName, int schemaVersion, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getSchema({} v{}) - transactionKey:{}", new Object[]{schemaName, schemaVersion, transactionKey});
        if (schemaName.equals("Schema") && schemaVersion == 0) {
            return new Schema(schemaName, schemaVersion, new ItemPath(new SystemKey(0L, 5L)), "");
        }
        return (Schema)schCache.get(schemaName, schemaVersion, transactionKey);
    }

    public static Schema getSchema(CastorHashMap properties) throws InvalidDataException, ObjectNotFoundException {
        return LocalObjectLoader.getSchema(properties, null);
    }

    public static Schema getSchema(CastorHashMap properties, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        return (Schema)LocalObjectLoader.getDescObjectByProperty(properties, BuiltInVertexProperties.SCHEMA_NAME, BuiltInVertexProperties.SCHEMA_VERSION, transactionKey);
    }

    public static ActivityDef getActDef(String actName, int actVersion) throws ObjectNotFoundException, InvalidDataException {
        return LocalObjectLoader.getActDef(actName, actVersion, null);
    }

    public static ActivityDef getActDef(String actName, int actVersion, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getActDef({} v{}) - transactionKey:{}", new Object[]{actName, actVersion, transactionKey});
        return (ActivityDef)actCache.get(actName, actVersion, transactionKey);
    }

    public static CompositeActivityDef getCompActDef(String actName, int actVersion) throws ObjectNotFoundException, InvalidDataException {
        return LocalObjectLoader.getCompActDef(actName, actVersion, null);
    }

    public static CompositeActivityDef getCompActDef(String actName, int actVersion, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getCompActDef({} v{}) - transactionKey:{}", new Object[]{actName, actVersion, transactionKey});
        return (CompositeActivityDef)compActCache.get(actName, actVersion, transactionKey);
    }

    public static ActivityDef getElemActDef(String actName, int actVersion) throws ObjectNotFoundException, InvalidDataException {
        return LocalObjectLoader.getElemActDef(actName, actVersion, null);
    }

    public static ActivityDef getElemActDef(String actName, int actVersion, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getElemActDef({} v{}) - transactionKey:{}", new Object[]{actName, actVersion, transactionKey});
        return (ActivityDef)elemActCache.get(actName, actVersion, transactionKey);
    }

    public static StateMachine getStateMachine(String smName, int smVersion) throws ObjectNotFoundException, InvalidDataException {
        return LocalObjectLoader.getStateMachine(smName, smVersion, null);
    }

    public static StateMachine getStateMachine(String smName, int smVersion, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getStateMachine({} v{}) - transactionKey:{}", new Object[]{smName, smVersion, transactionKey});
        return (StateMachine)smCache.get(smName, smVersion, transactionKey);
    }

    public static StateMachine getStateMachine(CastorHashMap properties) throws InvalidDataException, ObjectNotFoundException {
        return LocalObjectLoader.getStateMachine(properties, null);
    }

    public static StateMachine getStateMachine(CastorHashMap properties, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        return (StateMachine)LocalObjectLoader.getDescObjectByProperty(properties, BuiltInVertexProperties.STATE_MACHINE_NAME, BuiltInVertexProperties.STATE_MACHINE_VERSION, transactionKey);
    }

    public static PropertyDescriptionList getPropertyDescriptionList(String name, int version) throws ObjectNotFoundException, InvalidDataException {
        return LocalObjectLoader.getPropertyDescriptionList(name, version, null);
    }

    public static PropertyDescriptionList getPropertyDescriptionList(String name, int version, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getPropertyDescriptionList({} v{}) - transactionKey:{}", new Object[]{name, version, transactionKey});
        return (PropertyDescriptionList)propDescCache.get(name, version, transactionKey);
    }

    public static PropertyDescriptionList getPropertyDescriptionList(CastorHashMap properties) throws InvalidDataException, ObjectNotFoundException {
        return LocalObjectLoader.getPropertyDescriptionList(properties, null);
    }

    public static PropertyDescriptionList getPropertyDescriptionList(CastorHashMap properties, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        return (PropertyDescriptionList)LocalObjectLoader.getDescObjectByProperty(properties, BuiltInVertexProperties.PROPERTY_DEF_NAME, BuiltInVertexProperties.PROPERTY_DEF_VERSION, transactionKey);
    }

    private static DescriptionObject getDescObjectByProperty(CastorHashMap properties, BuiltInVertexProperties nameProp, BuiltInVertexProperties verProp, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        log.trace("getDescObjectByProperty(nameProp:{} verProp:{}) - transactionKey:{}", new Object[]{nameProp, verProp, transactionKey});
        String resName = (String)properties.getBuiltInProperty(nameProp);
        if (!properties.isAbstract(nameProp) && StringUtils.isNotBlank((CharSequence)resName)) {
            Integer resVer = LocalObjectLoader.deriveVersionNumber(properties.getBuiltInProperty(verProp));
            if (resVer == null && !properties.isAbstract(verProp)) {
                throw new InvalidDataException("Invalid version property '" + resVer + "' in " + (Object)((Object)verProp));
            }
            switch (nameProp) {
                case SCHEMA_NAME: {
                    return LocalObjectLoader.getSchema(resName, resVer, transactionKey);
                }
                case SCRIPT_NAME: {
                    return LocalObjectLoader.getScript(resName, resVer, transactionKey);
                }
                case QUERY_NAME: {
                    return LocalObjectLoader.getQuery(resName, resVer, transactionKey);
                }
                case STATE_MACHINE_NAME: {
                    return LocalObjectLoader.getStateMachine(resName, resVer, transactionKey);
                }
                case PROPERTY_DEF_NAME: {
                    return LocalObjectLoader.getPropertyDescriptionList(resName, resVer, transactionKey);
                }
            }
            throw new InvalidDataException(" CANNOT handle BuiltInVertexProperties:" + (Object)((Object)nameProp));
        }
        return null;
    }

    public static Integer deriveVersionNumber(Object value) throws InvalidDataException {
        if (value == null || "".equals(value)) {
            return null;
        }
        try {
            Integer version = Integer.valueOf(value.toString());
            if (version == -1) {
                return null;
            }
            return version;
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Invalid version number : " + value.toString());
        }
    }
}

