/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.utils.DescriptionObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyDescriptionCache
extends DescriptionObjectCache<PropertyDescriptionList> {
    private static final Logger log = LoggerFactory.getLogger(PropertyDescriptionCache.class);

    @Override
    public String getTypeCode() {
        return BuiltInResources.PROPERTY_DESC_RESOURCE.getTypeCode();
    }

    @Override
    public String getSchemaName() {
        return BuiltInResources.PROPERTY_DESC_RESOURCE.getSchemaName();
    }

    @Override
    public String getTypeRoot() {
        return BuiltInResources.PROPERTY_DESC_RESOURCE.getTypeRoot();
    }

    @Override
    public PropertyDescriptionList buildObject(String name, int version, ItemPath path, String data) throws InvalidDataException {
        try {
            PropertyDescriptionList pdl = (PropertyDescriptionList)Gateway.getMarshaller().unmarshall(data);
            pdl.setName(name);
            pdl.setVersion(version);
            pdl.setItemPath(path);
            return pdl;
        }
        catch (Exception ex) {
            log.error("Could not parse Schema '" + name + "' v" + version, (Throwable)ex);
            throw new InvalidDataException("Could not parse Schema '" + name + "' v" + version + ": " + ex.getMessage());
        }
    }
}

