/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.DescriptionObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptCache
extends DescriptionObjectCache<Script> {
    private static final Logger log = LoggerFactory.getLogger(ScriptCache.class);

    @Override
    public String getTypeCode() {
        return BuiltInResources.SCRIPT_RESOURCE.getTypeCode();
    }

    @Override
    public String getSchemaName() {
        return BuiltInResources.SCRIPT_RESOURCE.getSchemaName();
    }

    @Override
    public String getTypeRoot() {
        return BuiltInResources.SCRIPT_RESOURCE.getTypeRoot();
    }

    @Override
    public Script buildObject(String name, int version, ItemPath path, String data) throws InvalidDataException {
        try {
            return new Script(name, version, path, data);
        }
        catch (Exception ex) {
            log.error("Error parsing script '" + name + "' v" + version, (Throwable)ex);
            throw new InvalidDataException("Error parsing script '" + name + "' v" + version + ": " + ex.getMessage());
        }
    }
}

