/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.agent;

import java.nio.ByteBuffer;
import java.sql.Timestamp;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.process.Gateway;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocatorPOA;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveLocator
extends ServantLocatorPOA {
    private static final Logger log = LoggerFactory.getLogger(ActiveLocator.class);

    public Servant preinvoke(byte[] oid, POA poa, String operation, CookieHolder cookie) {
        try {
            ByteBuffer bb = ByteBuffer.wrap(oid);
            long msb = bb.getLong();
            long lsb = bb.getLong();
            AgentPath syskey = new AgentPath(new SystemKey(msb, lsb));
            log.info("===========================================================");
            log.info("Agent called at " + new Timestamp(System.currentTimeMillis()) + ": " + operation + "(" + syskey + ").");
            return Gateway.getCorbaServer().getAgent(syskey, null);
        }
        catch (ObjectNotFoundException ex) {
            log.error("preinvoke()", (Throwable)ex);
            throw new OBJECT_NOT_EXIST();
        }
        catch (InvalidItemPathException ex) {
            log.error("preinvoke()", (Throwable)ex);
            throw new INV_OBJREF();
        }
    }

    public void postinvoke(byte[] oid, POA poa, String operation, Object the_cookie, Servant the_servant) {
    }
}

