/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.proxy.ProxyClientConnection;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.server.SimpleTCPIPServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ProxyServer.class);
    ArrayList<ProxyClientConnection> proxyClients;
    SimpleTCPIPServer proxyListener = null;
    String serverName = null;
    boolean keepRunning = true;
    LinkedBlockingQueue<ProxyMessage> messageQueue;
    int port = 0;

    public ProxyServer(String serverName) throws InvalidDataException {
        log.info("ProxyServer(serverName:" + serverName + ") - Starting.....");
        this.port = Gateway.getProperties().getInt("ItemServer.Proxy.port", 0);
        if (this.port == 0) {
            String msg = "ItemServer.Proxy.port not defined in connect file. Remote proxies will not be informed of changes.";
            log.error(msg);
            throw new InvalidDataException(msg);
        }
        this.serverName = serverName;
        this.proxyClients = new ArrayList();
        this.messageQueue = new LinkedBlockingQueue();
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("ProxyServer");
        try {
            log.info("initServer - Initialising proxy informer on port " + this.port);
            this.proxyListener = new SimpleTCPIPServer(this.port, ProxyClientConnection.class, 200);
            this.proxyListener.startListening();
        }
        catch (Exception ex) {
            log.error("Error setting up Proxy Server. Remote proxies will not be informed of changes.", (Throwable)ex);
        }
        while (this.keepRunning) {
            Object object;
            ProxyMessage message = this.messageQueue.poll();
            if (message != null) {
                object = this.proxyClients;
                synchronized (object) {
                    for (ProxyClientConnection client : this.proxyClients) {
                        client.sendMessage(message);
                    }
                    continue;
                }
            }
            try {
                object = this;
                synchronized (object) {
                    if (this.messageQueue.isEmpty()) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendProxyEvent(ProxyMessage message) {
        try {
            ProxyServer proxyServer = this;
            synchronized (proxyServer) {
                this.messageQueue.put(message);
                this.notify();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportConnections(int logLevel) {
        ArrayList<ProxyClientConnection> arrayList = this.proxyClients;
        synchronized (arrayList) {
            log.debug("Currently connected proxy clients:");
            for (ProxyClientConnection client : this.proxyClients) {
                log.debug("   " + client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownServer() {
        log.info("Closing Server.");
        this.proxyListener.stopListening();
        Object object = this.proxyClients;
        synchronized (object) {
            for (ProxyClientConnection client : this.proxyClients) {
                client.shutdown();
            }
        }
        object = this;
        synchronized (object) {
            this.keepRunning = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProxyClient(ProxyClientConnection client) {
        ArrayList<ProxyClientConnection> arrayList = this.proxyClients;
        synchronized (arrayList) {
            this.proxyClients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterProxyClient(ProxyClientConnection client) {
        ArrayList<ProxyClientConnection> arrayList = this.proxyClients;
        synchronized (arrayList) {
            this.proxyClients.remove(client);
        }
    }
}

