/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.TransactionKey;

public interface LookupManager
extends Lookup {
    public void initializeDirectory(TransactionKey var1) throws ObjectNotFoundException;

    default public void add(Path newPath) throws ObjectCannotBeUpdated, ObjectAlreadyExistsException {
        this.add(newPath, null);
    }

    public void add(Path var1, TransactionKey var2) throws ObjectCannotBeUpdated, ObjectAlreadyExistsException;

    default public void delete(Path path) throws ObjectCannotBeUpdated {
        this.delete(path, null);
    }

    public void delete(Path var1, TransactionKey var2) throws ObjectCannotBeUpdated;

    default public RolePath createRole(RolePath role) throws ObjectAlreadyExistsException, ObjectCannotBeUpdated {
        return this.createRole(role, null);
    }

    public RolePath createRole(RolePath var1, TransactionKey var2) throws ObjectAlreadyExistsException, ObjectCannotBeUpdated;

    default public void addRole(AgentPath agent, RolePath rolePath) throws ObjectCannotBeUpdated, ObjectNotFoundException {
        this.addRole(agent, rolePath, null);
    }

    public void addRole(AgentPath var1, RolePath var2, TransactionKey var3) throws ObjectCannotBeUpdated, ObjectNotFoundException;

    default public void removeRole(AgentPath agent, RolePath role) throws ObjectCannotBeUpdated, ObjectNotFoundException {
        this.removeRole(agent, role, null);
    }

    public void removeRole(AgentPath var1, RolePath var2, TransactionKey var3) throws ObjectCannotBeUpdated, ObjectNotFoundException;

    default public void setAgentPassword(AgentPath agent, String newPassword) throws ObjectNotFoundException, ObjectCannotBeUpdated, NoSuchAlgorithmException {
        this.setAgentPassword(agent, newPassword, false, null);
    }

    default public void setAgentPassword(AgentPath agent, String newPassword, boolean temporary) throws ObjectNotFoundException, ObjectCannotBeUpdated, NoSuchAlgorithmException {
        this.setAgentPassword(agent, newPassword, temporary, null);
    }

    public void setAgentPassword(AgentPath var1, String var2, boolean var3, TransactionKey var4) throws ObjectNotFoundException, ObjectCannotBeUpdated, NoSuchAlgorithmException;

    default public void setHasJobList(RolePath role, boolean hasJobList) throws ObjectNotFoundException, ObjectCannotBeUpdated {
        this.setHasJobList(role, hasJobList, null);
    }

    public void setHasJobList(RolePath var1, boolean var2, TransactionKey var3) throws ObjectNotFoundException, ObjectCannotBeUpdated;

    default public void setIOR(ItemPath item, String ior) throws ObjectNotFoundException, ObjectCannotBeUpdated {
        this.setIOR(item, ior, null);
    }

    public void setIOR(ItemPath var1, String var2, TransactionKey var3) throws ObjectNotFoundException, ObjectCannotBeUpdated;

    default public void setPermission(RolePath role, String permission) throws ObjectNotFoundException, ObjectCannotBeUpdated {
        this.setPermission(role, permission, null);
    }

    public void setPermission(RolePath var1, String var2, TransactionKey var3) throws ObjectNotFoundException, ObjectCannotBeUpdated;

    default public void setPermissions(RolePath role, List<String> permissions) throws ObjectNotFoundException, ObjectCannotBeUpdated {
        this.setPermissions(role, permissions, null);
    }

    public void setPermissions(RolePath var1, List<String> var2, TransactionKey var3) throws ObjectNotFoundException, ObjectCannotBeUpdated;

    public void postStartServer();

    public void postBoostrap();
}

