/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;

public class RolePath
extends Path {
    private boolean hasJobList = false;
    private Set<String> permissions = new LinkedHashSet<String>();

    public RolePath() {
    }

    public RolePath(String path) {
        super(path);
    }

    public RolePath(RolePath parent, String roleName) {
        super(parent, roleName);
    }

    public RolePath(RolePath parent, String roleName, Set<String> newPermissions) {
        this(parent, roleName);
        this.setPermissions(newPermissions);
    }

    public RolePath(RolePath parent, String roleName, List<String> newPermissions) {
        this(parent, roleName, new LinkedHashSet<String>(newPermissions));
    }

    public RolePath(String path, boolean jobList) {
        super(path);
        this.hasJobList = jobList;
    }

    public RolePath(String path, boolean jobList, Set<String> newPermissions) {
        this(path, jobList);
        this.setPermissions(newPermissions);
    }

    public RolePath(String path, boolean jobList, List<String> newPermissions) {
        this(path, jobList, new LinkedHashSet<String>(newPermissions));
    }

    public RolePath(String[] path, boolean jobList) {
        super(path);
        this.hasJobList = jobList;
    }

    public RolePath(String[] path, boolean jobList, Set<String> newPermissions) {
        this(path, jobList);
        this.setPermissions(newPermissions);
    }

    public RolePath(String[] path, boolean jobList, List<String> newPermissions) {
        this(path, jobList);
        this.setPermissions(newPermissions);
    }

    public RolePath(RolePath parent, String roleName, boolean jobList) {
        this(parent, roleName);
        this.hasJobList = jobList;
    }

    public RolePath(RolePath parent, String roleName, boolean jobList, Set<String> newPermissions) {
        this(parent, roleName, jobList);
        this.setPermissions(newPermissions);
    }

    public RolePath(RolePath parent, String roleName, boolean jobList, List<String> newPermissions) {
        this(parent, roleName, jobList);
        this.setPermissions(newPermissions);
    }

    public RolePath getParent() throws ObjectNotFoundException {
        return this.getParent(null);
    }

    public RolePath getParent(TransactionKey transactionKey) throws ObjectNotFoundException {
        if (this.mPath.length < 2) {
            return null;
        }
        return Gateway.getLookup().getRolePath(this.mPath[this.mPath.length - 2], transactionKey);
    }

    public boolean hasJobList() {
        return this.hasJobList;
    }

    public void setHasJobList(boolean hasJobList) {
        this.hasJobList = hasJobList;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public List<String> getPermissionsList() {
        return new ArrayList<String>(this.permissions);
    }

    public void setPermissions(List<String> newPermissions) {
        this.permissions.clear();
        this.permissions.addAll(newPermissions);
    }

    public void setPermissions(Set<String> newPermissions) {
        this.permissions.clear();
        this.permissions.addAll(newPermissions);
    }

    public Iterator<Path> getChildren() {
        return this.getChildren(null);
    }

    public Iterator<Path> getChildren(TransactionKey transactionKey) {
        return Gateway.getLookup().getChildren(this, transactionKey);
    }

    @Override
    public String dump() {
        StringBuffer dump = new StringBuffer("RolePath: {\n");
        dump.append("  Path:" + this.toString() + "\n");
        dump.append("  JobList:" + this.hasJobList + "\n");
        for (String p : this.permissions) {
            dump.append("  Permission:" + p + "\n");
        }
        dump.append("}\n");
        return dump.toString();
    }

    @Override
    public String getRoot() {
        return "role";
    }

    @Override
    public String getName() {
        if (this.mPath.length > 0) {
            return this.mPath[this.mPath.length - 1];
        }
        return this.getRoot();
    }

    @Override
    public String getClusterPath() {
        return (Object)((Object)ClusterType.PATH) + "/Role/" + StringUtils.join((Object[])this.mPath, (String)"");
    }
}

