/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.module;

import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleDescRef;
import org.cristalise.kernel.process.module.ModuleResource;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.process.resource.ResourceImportHandler;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleActivity
extends ModuleResource {
    private static final Logger log = LoggerFactory.getLogger(ModuleActivity.class);
    ModuleDescRef script;
    ModuleDescRef schema;
    ModuleDescRef query;
    ModuleDescRef stateMachine;
    ActivityDef actDef;

    public ModuleActivity() {
        this.type = BuiltInResources.ELEM_ACT_DESC_RESOURCE;
    }

    public ModuleActivity(ItemProxy child, Integer version) throws ObjectNotFoundException, InvalidDataException {
        this();
        this.version = version;
        this.script = this.getDescRef(child, BuiltInCollections.SCRIPT);
        this.schema = this.getDescRef(child, BuiltInCollections.SCHEMA);
        this.query = this.getDescRef(child, BuiltInCollections.QUERY);
        this.stateMachine = this.getDescRef(child, BuiltInCollections.STATE_MACHINE);
    }

    public ModuleDescRef getDescRef(ItemProxy child, BuiltInCollections collection) throws ObjectNotFoundException, InvalidDataException {
        Collection<?> coll = child.getCollection(collection.getName(), (Integer)this.version);
        if (coll.size() == 1) {
            throw new InvalidDataException("Too many members in " + (Object)((Object)collection) + " collection in " + this.name);
        }
        CollectionMember collMem = (CollectionMember)coll.getMembers().list.get(0);
        return new ModuleDescRef(null, collMem.getChildUUID(), Integer.valueOf(collMem.getProperties().get("Version").toString()));
    }

    @Override
    public Path create(AgentPath agentPath, boolean reset, TransactionKey transactionKey) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, ObjectAlreadyExistsException, InvalidDataException {
        try {
            ResourceImportHandler importHandler = Gateway.getResourceImportHandler(this.type);
            this.domainPath = importHandler.importResource(this.ns, this.name, this.version, this.itemPath, this.getResourceLocation(), reset, transactionKey);
            this.resourceChangeDetails = importHandler.getResourceChangeDetails();
            this.itemPath = this.domainPath.getItemPath(transactionKey);
        }
        catch (Exception e) {
            log.error("Exception verifying module resource " + this.ns + "/" + this.name, (Throwable)e);
            throw new CannotManageException("Exception verifying module resource " + this.ns + "/" + this.name);
        }
        this.actDef = LocalObjectLoader.getActDef(this.name, this.version, transactionKey);
        this.populateActivityDef(transactionKey);
        CollectionArrayList colls = this.actDef.makeDescCollections(transactionKey);
        for (Collection coll : colls.list) {
            try {
                Gateway.getStorage().put(this.itemPath, coll, transactionKey);
                coll.setVersion(null);
                Gateway.getStorage().put(this.itemPath, coll, transactionKey);
            }
            catch (PersistencyException e) {
                log.error("Storing description collections for " + this.getName() + ".", (Throwable)e);
                throw new CannotManageException("Persistency exception storing description collections for " + this.getName() + ".");
            }
        }
        return this.domainPath;
    }

    public void populateActivityDef(TransactionKey transactionKey) throws ObjectNotFoundException, CannotManageException {
        try {
            if (this.schema != null) {
                this.actDef.setSchema(LocalObjectLoader.getSchema(this.schema.id == null ? this.schema.name : this.schema.id, this.schema.version, transactionKey));
            }
        }
        catch (NumberFormatException | InvalidDataException e) {
            log.error("", e);
            throw new CannotManageException("Schema definition in " + this.getName() + " not valid.");
        }
        try {
            if (this.script != null) {
                this.actDef.setScript(LocalObjectLoader.getScript(this.script.id == null ? this.script.name : this.script.id, this.script.version, transactionKey));
            }
        }
        catch (NumberFormatException | InvalidDataException e) {
            log.error("", e);
            throw new CannotManageException("Script definition in " + this.getName() + " not valid.");
        }
        try {
            if (this.query != null) {
                this.actDef.setQuery(LocalObjectLoader.getQuery(this.query.id == null ? this.query.name : this.query.id, this.query.version, transactionKey));
            }
        }
        catch (NumberFormatException | InvalidDataException e) {
            log.error("", e);
            throw new CannotManageException("Query definition in " + this.getName() + " not valid.");
        }
        try {
            if (this.stateMachine != null) {
                this.actDef.setStateMachine(LocalObjectLoader.getStateMachine(this.stateMachine.id == null ? this.stateMachine.name : this.stateMachine.id, this.stateMachine.version, transactionKey));
            }
        }
        catch (NumberFormatException | InvalidDataException e) {
            log.error("", e);
            throw new CannotManageException("State Machine definition in " + this.getName() + " not valid.");
        }
    }

    public ModuleDescRef getScript() {
        return this.script;
    }

    public ModuleDescRef getSchema() {
        return this.schema;
    }

    public ModuleDescRef getQuery() {
        return this.query;
    }

    public ModuleDescRef getStateMachine() {
        return this.stateMachine;
    }

    public ActivityDef getActDef() {
        return this.actDef;
    }

    public void setScript(ModuleDescRef script) {
        this.script = script;
    }

    public void setSchema(ModuleDescRef schema) {
        this.schema = schema;
    }

    public void setQuery(ModuleDescRef query) {
        this.query = query;
    }

    public void setStateMachine(ModuleDescRef stateMachine) {
        this.stateMachine = stateMachine;
    }

    public void setActDef(ActivityDef actDef) {
        this.actDef = actDef;
    }
}

