/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.resource;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.predefined.item.CreateItemFromDescription;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.LookupManager;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.process.resource.ResourceImportHandler;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.security.BuiltInAuthc;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.ObjectProperties;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceImportHandler
implements ResourceImportHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultResourceImportHandler.class);
    BuiltInResources type;
    DomainPath typeRootPath;
    PropertyDescriptionList props;
    String resourceChangeDetails = "";

    public DefaultResourceImportHandler(BuiltInResources resType) throws Exception {
        this.type = resType;
        this.typeRootPath = new DomainPath(this.type.getTypeRoot());
        this.props = (PropertyDescriptionList)Gateway.getMarshaller().unmarshall(Gateway.getResource().getTextResource(null, "boot/property/" + (Object)((Object)resType) + "Prop.xml"));
    }

    @Deprecated
    public DefaultResourceImportHandler(String resType) throws Exception {
        this(BuiltInResources.getValue(resType));
    }

    @Override
    public CollectionArrayList getCollections(String name, String ns, String location, Integer version, TransactionKey transactionKey) throws Exception {
        return this.getCollections(name, version, Gateway.getResource().getTextResource(ns, location), transactionKey);
    }

    @Override
    public CollectionArrayList getCollections(String name, Integer version, Outcome outcome, TransactionKey transactionKey) throws Exception {
        return this.getCollections(name, version, outcome.getData(), transactionKey);
    }

    private CollectionArrayList getCollections(String name, Integer version, String xml, TransactionKey transactionKey) throws Exception {
        if (this.type == BuiltInResources.SCHEMA_RESOURCE) {
            return new Schema(name, version, null, xml).makeDescCollections(transactionKey);
        }
        if (this.type == BuiltInResources.SCRIPT_RESOURCE) {
            return new Script(name, version, null, xml).makeDescCollections(transactionKey);
        }
        if (this.type == BuiltInResources.QUERY_RESOURCE) {
            return new Query(name, version, null, xml).makeDescCollections(transactionKey);
        }
        DescriptionObject descObject = (DescriptionObject)Gateway.getMarshaller().unmarshall(xml);
        descObject.setVersion(version);
        if (this.type == BuiltInResources.COMP_ACT_DESC_RESOURCE) {
            CompositeActivityDef caDesc = (CompositeActivityDef)descObject;
            caDesc.setRefChildActDef(caDesc.findRefActDefs(caDesc.getChildrenGraphModel(), transactionKey));
        }
        return descObject.makeDescCollections(transactionKey);
    }

    @Override
    public DomainPath getTypeRoot() {
        return this.typeRootPath;
    }

    @Override
    public String getName() {
        return this.type.getSchemaName();
    }

    @Override
    public DomainPath getPath(String name, String ns) {
        return new DomainPath(this.type.getTypeRoot() + "/" + (ns == null ? "kernel" : ns) + '/' + name);
    }

    @Override
    public Outcome getResourceOutcome(String name, String ns, String location, Integer version) throws InvalidDataException, ObjectNotFoundException {
        String data = Gateway.getResource().getTextResource(ns, location);
        if (data == null) {
            throw new ObjectNotFoundException("No data found for " + this.type.getSchemaName() + " " + name);
        }
        return new Outcome(-1, data, this.type.getSchemaName(), version);
    }

    @Override
    public PropertyDescriptionList getPropDesc() {
        return this.props;
    }

    @Override
    public String getWorkflowName() {
        return this.type.getWorkflowDef();
    }

    @Override
    public DomainPath createResource(String ns, String itemName, int version, Outcome outcome, boolean reset, TransactionKey transactionKey) throws Exception {
        return this.verifyResource(ns, itemName, version, null, outcome, reset, transactionKey);
    }

    @Override
    public DomainPath importResource(String ns, String itemName, int version, ItemPath itemPath, String dataLocation, boolean reset, TransactionKey transactionKey) throws Exception {
        return this.verifyResource(ns, itemName, version, itemPath, this.getResourceOutcome(itemName, ns, dataLocation, version), reset, transactionKey);
    }

    @Override
    public DomainPath importResource(String ns, String itemName, int version, ItemPath itemPath, Outcome outcome, boolean reset, TransactionKey transactionKey) throws Exception {
        return this.verifyResource(ns, itemName, version, itemPath, outcome, reset, transactionKey);
    }

    private DomainPath verifyResource(String ns, String itemName, int version, ItemPath itemPath, Outcome outcome, boolean reset, TransactionKey transactionKey) throws Exception {
        ItemProxy thisProxy;
        if (outcome == null) {
            log.warn("verifyResource() - NO Outcome was found nothing stored for Item '{}' of type '{}' version '{}'", new Object[]{itemName, this.getName(), version});
            return null;
        }
        log.debug("verifyResource() - Item '{}' of type '{}' version '{}'", new Object[]{itemName, this.getName(), version});
        DomainPath modDomPath = this.getPath(itemName, ns);
        if (modDomPath.exists(transactionKey)) {
            log.debug("verifyResource() - Found " + this.getName() + " " + itemName + ".");
            thisProxy = this.verifyPathAndModuleProperty(ns, itemName, itemPath, modDomPath, modDomPath, transactionKey);
        } else {
            log.debug("verifyResource() - " + this.getName() + " " + itemName + " not found. Creating new.");
            if (itemPath == null) {
                itemPath = new ItemPath();
            }
            thisProxy = this.createResourceItem(itemName, version, ns, itemPath, transactionKey);
        }
        ResourceImportHandler.Status status = this.checkToStoreOutcomeVersion(thisProxy, outcome, version, reset, transactionKey);
        log.info("verifyResource() - Outcome {} of item:{} schema:{} version:{} ", new Object[]{status.name(), thisProxy.getName(), outcome.getSchema().getName(), version});
        if (status == ResourceImportHandler.Status.NEW || status == ResourceImportHandler.Status.UPDATED || status == ResourceImportHandler.Status.OVERWRITTEN) {
            if (ns != null) {
                outcome.validateAndCheck();
            }
            PredefinedStep.storeOutcomeEventAndViews(thisProxy.getPath(), outcome, version, transactionKey);
            CollectionArrayList cols = this.getCollections(itemName, (Integer)version, outcome, transactionKey);
            for (Collection col : cols.list) {
                Gateway.getStorage().put(thisProxy.getPath(), col, transactionKey);
                Gateway.getStorage().clearCache(thisProxy.getPath(), (Object)((Object)ClusterType.COLLECTION) + "/" + col.getName());
                col.setVersion(null);
                Gateway.getStorage().put(thisProxy.getPath(), col, transactionKey);
            }
        } else if (status == ResourceImportHandler.Status.REMOVED) {
            // empty if block
        }
        this.resourceChangeDetails = this.convertToResourceChangeDetails(itemName, version, outcome.getSchema(), status);
        if (log.isTraceEnabled()) {
            log.trace("verifyResource() - resourceChangeDetails:{}", (Object)this.resourceChangeDetails.replace("\n", "").replaceAll(">\\s*<", "><"));
        }
        return modDomPath;
    }

    private ItemProxy verifyPathAndModuleProperty(String ns, String itemName, ItemPath itemPath, DomainPath modDomPath, DomainPath path, TransactionKey transactionKey) throws Exception {
        LookupManager lookupManager = Gateway.getLookupManager();
        ItemProxy thisProxy = Gateway.getProxyManager().getProxy(path, transactionKey);
        if (itemPath != null && !path.getItemPath().equals(itemPath)) {
            String error = "Resource " + (Object)((Object)this.type) + "/" + itemName + " should have path " + itemPath + " but was found with path " + path.getItemPath();
            log.error(error);
            throw new InvalidDataException(error);
        }
        if (itemPath == null) {
            itemPath = path.getItemPath();
        }
        String moduleName = ns == null ? "kernel" : ns;
        try {
            String itemModule = thisProxy.getProperty("Module");
            if (!(itemModule == null || itemModule.equals("") || itemModule.equals("null") || moduleName.equals(itemModule))) {
                String error = "Module clash! Resource '" + itemName + "' included in module " + moduleName + " but is assigned to '" + itemModule + "'.";
                log.error(error);
                throw new InvalidDataException(error);
            }
        }
        catch (ObjectNotFoundException ex) {
            String itemModule = "";
        }
        if (!modDomPath.equals(path)) {
            log.info("Module item " + itemName + " found with path " + path.toString() + ". Moving to " + modDomPath.toString());
            modDomPath.setItemPath(itemPath);
            if (!modDomPath.exists(transactionKey)) {
                lookupManager.add(modDomPath, transactionKey);
            }
            lookupManager.delete(path, transactionKey);
        }
        return thisProxy;
    }

    private ResourceImportHandler.Status checkToStoreOutcomeVersion(ItemProxy item, Outcome newOutcome, int version, boolean reset, TransactionKey transactionKey) throws PersistencyException, InvalidDataException, ObjectNotFoundException {
        Schema schema = newOutcome.getSchema(transactionKey);
        if (!item.checkViewpoint(schema.getName(), Integer.toString(version), transactionKey)) {
            return ResourceImportHandler.Status.NEW;
        }
        Viewpoint currentData = item.getViewpoint(schema.getName(), Integer.toString(version), transactionKey);
        if (newOutcome.isIdentical(currentData.getOutcome())) {
            return ResourceImportHandler.Status.IDENTICAL;
        }
        if (currentData.getEvent().getStepPath().equals("Bootstrap")) {
            return ResourceImportHandler.Status.UPDATED;
        }
        if (reset) {
            return ResourceImportHandler.Status.OVERWRITTEN;
        }
        return ResourceImportHandler.Status.SKIPPED;
    }

    private ItemProxy createResourceItem(String itemName, int version, String ns, ItemPath itemPath, TransactionKey transactionKey) throws Exception {
        PropertyDescriptionList pdList = this.getPropDesc();
        PropertyArrayList props = new PropertyArrayList();
        LookupManager lookupManager = Gateway.getLookupManager();
        for (int i = 0; i < pdList.list.size(); ++i) {
            PropertyDescription pd = (PropertyDescription)pdList.list.get(i);
            String propName = pd.getName();
            String propVal = pd.getDefaultValue();
            if (propName.equals(BuiltInItemProperties.NAME.toString())) {
                propVal = itemName;
            } else if (propName.equals(BuiltInItemProperties.MODULE.toString())) {
                propVal = ns == null ? "kernel" : ns;
            }
            props.list.add(new Property(propName, propVal, pd.getIsMutable()));
        }
        CompositeActivity ca = null;
        try {
            ca = (CompositeActivity)LocalObjectLoader.getCompActDef(this.getWorkflowName(), version, transactionKey).instantiate(transactionKey);
        }
        catch (ObjectNotFoundException pd) {
            // empty catch block
        }
        Gateway.getCorbaServer().createItem(itemPath, transactionKey);
        lookupManager.add(itemPath, transactionKey);
        CreateItemFromDescription.storeItem((AgentPath)BuiltInAuthc.SYSTEM_AGENT.getPath(transactionKey), itemPath, props, null, ca, null, null, transactionKey);
        DomainPath newDomPath = this.getPath(itemName, ns);
        newDomPath.setItemPath(itemPath);
        lookupManager.add(newDomPath, transactionKey);
        return Gateway.getProxyManager().getProxy(itemPath, transactionKey);
    }

    private String convertToResourceChangeDetails(String name, int version, Schema schema, ResourceImportHandler.Status status) throws IOException {
        String templ = FileStringUtility.url2String(ObjectProperties.class.getResource("resources/templates/ResourceChangeDetails_xsd.tmpl"));
        CompiledTemplate expr = TemplateCompiler.compileTemplate((String)templ);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("resourceName", StringEscapeUtils.escapeXml11((String)name));
        vars.put("resourceVersion", version);
        vars.put("schemaName", schema.getName());
        vars.put("changeType", status.name());
        return (String)TemplateRuntime.execute((CompiledTemplate)expr, vars);
    }

    @Override
    public String getResourceChangeDetails() {
        return this.resourceChangeDetails;
    }
}

