/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.DescriptionObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCache
extends DescriptionObjectCache<Schema> {
    private static final Logger log = LoggerFactory.getLogger(SchemaCache.class);

    @Override
    public String getTypeCode() {
        return BuiltInResources.SCHEMA_RESOURCE.getTypeCode();
    }

    @Override
    public String getSchemaName() {
        return BuiltInResources.SCHEMA_RESOURCE.getSchemaName();
    }

    @Override
    public String getTypeRoot() {
        return BuiltInResources.SCHEMA_RESOURCE.getTypeRoot();
    }

    @Override
    public Schema buildObject(String name, int version, ItemPath path, String data) throws InvalidDataException {
        try {
            Schema thisSchema = new Schema(name, version, path, data);
            thisSchema.validate();
            return thisSchema;
        }
        catch (Exception ex) {
            log.error("Could not parse Schema '" + name + "' v" + version, (Throwable)ex);
            throw new InvalidDataException("Could not parse Schema '" + name + "' v" + version + ": " + ex.getMessage());
        }
    }
}

