/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.collection;

import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.collection.AggregationVertexOutlineCreator;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.TypeNameAndConstructionInfo;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Aggregation
extends Collection<AggregationMember> {
    private static final Logger log = LoggerFactory.getLogger(Aggregation.class);
    protected GraphModel mLayout = new GraphModel(new AggregationVertexOutlineCreator());
    private final TypeNameAndConstructionInfo[] mVertexTypeNameAndConstructionInfo = new TypeNameAndConstructionInfo[]{new TypeNameAndConstructionInfo("Slot", "AggregationMember")};

    public Aggregation() {
        this.setName("Aggregation");
    }

    public Aggregation(String name) {
        this.setName(name);
    }

    public Aggregation(String name, Integer version) {
        this.setName(name);
        this.setVersion(version);
    }

    public GraphModel getLayout() {
        return this.mLayout;
    }

    public void setLayout(GraphModel layout) {
        this.mLayout = layout;
        layout.setVertexOutlineCreator(new AggregationVertexOutlineCreator());
    }

    public TypeNameAndConstructionInfo[] getVertexTypeNameAndConstructionInfo() {
        return this.mVertexTypeNameAndConstructionInfo;
    }

    public boolean exists(ItemPath itemPath) {
        for (int i = 0; i < this.size(); ++i) {
            AggregationMember element = (AggregationMember)this.mMembers.list.get(i);
            if (!element.getItemPath().equals(itemPath)) continue;
            return true;
        }
        return false;
    }

    public AggregationMember getMemberPair(int vertexID) {
        for (int i = 0; i < this.size(); ++i) {
            AggregationMember element = (AggregationMember)this.mMembers.list.get(i);
            if (element.getID() != vertexID) continue;
            return element;
        }
        return null;
    }

    public AggregationMember addSlot(CastorHashMap props, String classProps, GraphPoint location, int w, int h) {
        if (location == null) {
            location = new GraphPoint(100, 100 * this.getCounter());
        }
        if (w < 0) {
            w = 20;
        }
        if (h < 0) {
            h = 20;
        }
        AggregationMember aggMem = new AggregationMember();
        aggMem.setProperties(props);
        aggMem.setClassProps(classProps);
        Vertex vertex = new Vertex();
        vertex.setHeight(h);
        vertex.setWidth(w);
        this.mLayout.addVertexAndCreateId(vertex, location);
        aggMem.setCollection(this);
        aggMem.setID(vertex.getID());
        aggMem.setIsLayoutable(true);
        this.mMembers.list.add(aggMem);
        log.debug("addSlot() - new slot linked to vertexid " + vertex.getID());
        return aggMem;
    }

    public AggregationMember addMember(ItemPath itemPath, CastorHashMap props, String classProps, GraphPoint location, int w, int h, TransactionKey transactionKey) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        AggregationMember aggMem = this.addSlot(props, classProps, location, w, h);
        if (itemPath != null) {
            aggMem.assignItem(itemPath, transactionKey);
            aggMem.setIsComposite(Aggregation.getIsComposite(itemPath, this.getName(), transactionKey));
        }
        log.debug("addMember(" + String.valueOf(itemPath) + ") - assigned to new slot " + aggMem.getID());
        return aggMem;
    }

    @Override
    public AggregationMember addMember(ItemPath itemPath, CastorHashMap props, String classProps, TransactionKey transactionKey) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        return this.addMember(itemPath, props, classProps, null, -1, -1, transactionKey);
    }

    public AggregationMember addMember(CastorHashMap props, String classProps, GraphPoint location, int w, int h, TransactionKey transactionKey) throws InvalidCollectionModification {
        try {
            return this.addMember(null, props, classProps, location, w, h, transactionKey);
        }
        catch (ObjectAlreadyExistsException e) {
            return null;
        }
    }

    public AggregationMember addSlot(CastorHashMap props, String classProps) {
        return this.addSlot(props, classProps, null, -1, -1);
    }

    @Override
    public AggregationMember removeMember(int memberId) throws ObjectNotFoundException {
        for (AggregationMember element : this.mMembers.list) {
            if (element.getID() != memberId) continue;
            element.clearItem();
            this.mLayout.removeVertex(this.getLayout().getVertexById(memberId));
            return element;
        }
        throw new ObjectNotFoundException("Member " + memberId + " not found");
    }

    public static boolean getIsComposite(ItemPath itemPath, String name, TransactionKey transactionKey) {
        if (itemPath == null) {
            return false;
        }
        try {
            for (String collName : Gateway.getStorage().getClusterContents(itemPath, ClusterType.COLLECTION, transactionKey)) {
                if (name != null && !name.equals(collName)) continue;
                return true;
            }
        }
        catch (PersistencyException e) {
            return false;
        }
        return false;
    }
}

