/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.collection;

import java.util.ArrayList;
import java.util.List;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.CollectionMemberList;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.utils.CastorHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Collection<E extends CollectionMember>
implements C2KLocalObject {
    private static final Logger log = LoggerFactory.getLogger(Collection.class);
    private int mCounter = -1;
    protected CollectionMemberList<E> mMembers = new CollectionMemberList();
    protected String mName = "";
    protected Integer mVersion = null;

    public int getCounter() {
        if (this.mCounter == -1) {
            for (CollectionMember element : this.mMembers.list) {
                if (this.mCounter >= element.getID()) continue;
                this.mCounter = element.getID();
            }
        }
        return ++this.mCounter;
    }

    public int size() {
        return this.mMembers.list.size();
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public Integer getVersion() {
        return this.mVersion;
    }

    public void setVersion(Integer version) {
        this.mVersion = version;
    }

    public String getVersionName() {
        return this.mVersion == null ? "last" : String.valueOf(this.mVersion);
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.COLLECTION;
    }

    @Override
    public String getClusterPath() {
        return String.valueOf((Object)this.getClusterType()) + "/" + this.mName + "/" + this.getVersionName();
    }

    public void setMembers(CollectionMemberList<E> newMembers) {
        this.mMembers = newMembers;
    }

    public boolean contains(ItemPath itemPath) {
        for (CollectionMember element : this.mMembers.list) {
            if (!element.getItemPath().equals(itemPath)) continue;
            return true;
        }
        return false;
    }

    public String getDescVer(E mem) {
        String descVer = "last";
        Object descVerObj = mem.getProperties().getBuiltInProperty(BuiltInVertexProperties.VERSION);
        if (descVerObj != null) {
            descVer = descVerObj.toString();
        }
        return descVer;
    }

    public boolean isFull() {
        for (CollectionMember element : this.mMembers.list) {
            if (element.getItemPath() != null) continue;
            return false;
        }
        return true;
    }

    public E getMember(int memberId) throws ObjectNotFoundException {
        for (CollectionMember element : this.mMembers.list) {
            if (element.getID() != memberId) continue;
            return (E)element;
        }
        throw new ObjectNotFoundException("MemberId:" + memberId + " not found in Collection:" + this.mName);
    }

    public E getMember(ItemPath itemPath) throws ObjectNotFoundException {
        for (CollectionMember element : this.mMembers.list) {
            if (!element.getItemPath().equals(itemPath)) continue;
            return (E)element;
        }
        throw new ObjectNotFoundException("Member " + String.valueOf(itemPath) + " not found in " + this.mName);
    }

    public CollectionMemberList<E> getMembers() {
        return this.mMembers;
    }

    public abstract E addMember(ItemPath var1, CastorHashMap var2, String var3, TransactionKey var4) throws InvalidCollectionModification, ObjectAlreadyExistsException;

    public E removeMember(int memberId) throws ObjectNotFoundException {
        List<E> members = this.resolveMembers(memberId);
        if (members.size() == 1) {
            this.mMembers.list.remove(members.get(0));
            return (E)((CollectionMember)members.get(0));
        }
        throw new ObjectNotFoundException("Collection name:" + this.getName() + " has more then one MemberId:" + memberId);
    }

    public E removeMember(ItemPath ip) throws ObjectNotFoundException {
        List<E> members = this.resolveMembers(ip);
        if (members.size() == 1) {
            this.mMembers.list.remove(members.get(0));
            return (E)((CollectionMember)members.get(0));
        }
        throw new ObjectNotFoundException("Collection name:" + this.getName() + " has more then one Member:" + String.valueOf(ip));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mMembers == null ? 0 : this.mMembers.hashCode());
        result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Collection other = (Collection)obj;
        if (this.mMembers == null && other.mMembers != null) {
            return false;
        }
        if (!this.mMembers.equals(other.mMembers)) {
            return false;
        }
        if (this.mName == null && other.mName != null) {
            return false;
        }
        return this.mName.equals(other.mName);
    }

    public List<E> resolveMembers(ItemPath childPath) throws ObjectNotFoundException {
        return this.resolveMembers(-1, childPath);
    }

    public List<E> resolveMembers(int slotID) throws ObjectNotFoundException {
        return this.resolveMembers(slotID, null);
    }

    public List<E> resolveMembers(int slotID, ItemPath childPath) throws ObjectNotFoundException {
        ArrayList<E> members = new ArrayList<E>();
        if (slotID > -1) {
            E slot = this.getMember(slotID);
            if (childPath != null && !slot.getItemPath().equals(childPath)) {
                throw new ObjectNotFoundException("Item:" + String.valueOf(childPath) + " was not in slot:" + slotID + " of collection:" + this.getName());
            }
            members.add(slot);
        } else {
            for (CollectionMember member : this.getMembers().list) {
                if (!member.getItemPath().equals(childPath)) continue;
                members.add(member);
            }
        }
        if (members.isEmpty()) {
            throw new ObjectNotFoundException("Could not find Item:" + String.valueOf(childPath) + " in slot:" + slotID + " of collection:" + this.getName());
        }
        return members;
    }

    public static enum Cardinality {
        OneToMany,
        ManyToOne,
        OneToOne,
        ManyToMany;


        public Cardinality reverse() {
            switch (this.ordinal()) {
                case 2: 
                case 3: {
                    return this;
                }
                case 0: {
                    return ManyToOne;
                }
                case 1: {
                    return OneToMany;
                }
            }
            log.warn("reverse() - unrecognised value:{}", (Object)this);
            return null;
        }
    }

    public static enum Type {
        Bidirectional,
        Unidirectional;

    }
}

