/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.collection;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dependency
extends Collection<DependencyMember> {
    private static final Logger log = LoggerFactory.getLogger(Dependency.class);
    protected CastorHashMap mProperties = new CastorHashMap();
    protected String mClassProps = "";

    public Dependency() {
        this.setName("Dependency");
    }

    public Dependency(String name) {
        this.setName(name);
    }

    public Dependency(String name, Integer version) {
        this.setName(name);
        this.setVersion(version);
    }

    public Dependency(BuiltInCollections collection) {
        this(collection.getName());
    }

    public Dependency(BuiltInCollections collection, Integer version) {
        this(collection.getName(), version);
    }

    public CastorHashMap getProperties() {
        return this.mProperties;
    }

    public void setProperties(CastorHashMap props) {
        this.mProperties = props;
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.mProperties.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.mProperties.setKeyValuePairs(pairs);
    }

    public void setClassProps(String classProps) {
        this.mClassProps = classProps;
    }

    public String getClassProps() {
        return this.mClassProps;
    }

    public Property[] getClassProperties() {
        String[] classPropNames = this.getClassProps().split(",");
        Property[] props = new Property[classPropNames.length];
        int i = 0;
        for (String propName : classPropNames) {
            props[i++] = new Property(propName, (String)this.getProperties().get(propName));
        }
        return props;
    }

    public void updateMember(ItemPath childPath, CastorHashMap memberNewProps) throws ObjectNotFoundException, InvalidDataException, InvalidCollectionModification {
        this.updateMember(childPath, -1, memberNewProps);
    }

    public void updateMember(ItemPath childPath, int memberID, CastorHashMap memberNewProps) throws ObjectNotFoundException, InvalidDataException, InvalidCollectionModification {
        List members = this.resolveMembers(memberID, childPath);
        if (members.size() != 1) {
            throw new InvalidDataException("Child item '" + String.valueOf(childPath) + "' apperars more them once in collection " + this.mName);
        }
        DependencyMember member = (DependencyMember)members.get(0);
        member.updateProperties(memberNewProps);
    }

    public DependencyMember addMember(ItemPath itemPath, TransactionKey transactionKey) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        DependencyMember depMember = this.createMember(itemPath, transactionKey);
        this.mMembers.list.add(depMember);
        log.trace("addMember(" + String.valueOf(itemPath) + ") added to children with slotId:" + depMember.getID());
        return depMember;
    }

    public void addMember(DependencyMember depMember) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        this.mMembers.list.add(depMember);
    }

    public DependencyMember createMember(ItemPath itemPath, TransactionKey transactionKey) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        if (itemPath == null) {
            throw new InvalidCollectionModification("Cannot add empty slot to Dependency collection");
        }
        if (this.contains(itemPath)) {
            throw new ObjectAlreadyExistsException("Item " + itemPath.getItemName() + " already exists in Dependency:" + String.valueOf(this));
        }
        DependencyMember depMember = new DependencyMember();
        depMember.setID(this.getCounter());
        depMember.setProperties((CastorHashMap)this.mProperties.clone());
        depMember.setClassProps(this.mClassProps);
        depMember.assignItem(itemPath, transactionKey);
        return depMember;
    }

    public List<DependencyMember> compare(Dependency other) {
        ArrayList<DependencyMember> newMembers = new ArrayList<DependencyMember>();
        for (DependencyMember thisMember : other.getMembers().list) {
            if (this.contains(thisMember.getItemPath())) continue;
            newMembers.add(thisMember);
        }
        return newMembers;
    }

    @Override
    public DependencyMember addMember(ItemPath itemPath, CastorHashMap props, String classProps, TransactionKey transactionKey) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        DependencyMember depMember = this.createMember(itemPath, props, transactionKey);
        this.mMembers.list.add(depMember);
        log.trace("addMember(" + String.valueOf(itemPath) + ") added to children with slotId:" + depMember.getID());
        return depMember;
    }

    public DependencyMember createMember(ItemPath itemPath, CastorHashMap props, TransactionKey transactionKey) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        if (itemPath == null) {
            throw new InvalidCollectionModification("Cannot add empty slot to Dependency collection");
        }
        if (this.checkUniqueness() && this.contains(itemPath)) {
            throw new ObjectAlreadyExistsException("Item " + String.valueOf(itemPath) + " already exists in Dependency " + this.getName());
        }
        for (String classProp : this.mClassProps.split(",")) {
            if (!props.containsKey(classProp)) continue;
            throw new InvalidCollectionModification("Dependency cannot change classProperties:" + this.mClassProps);
        }
        DependencyMember depMember = new DependencyMember();
        depMember.setID(this.getCounter());
        if (StringUtils.isNotBlank((CharSequence)this.mClassProps)) {
            for (String classProp : this.mClassProps.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)classProp)) continue;
                props.put(classProp, this.mProperties.get(classProp));
            }
        }
        depMember.setProperties((CastorHashMap)this.mProperties.clone());
        depMember.getProperties().merge(props);
        depMember.setClassProps(this.mClassProps);
        depMember.assignItem(itemPath, transactionKey);
        return depMember;
    }

    private boolean checkUniqueness() {
        Boolean checkUniqueness = (Boolean)this.getBuiltInProperty(BuiltInVertexProperties.DEPENDENCY_ALLOW_DUPLICATE_ITEMS);
        if (checkUniqueness == null) {
            checkUniqueness = SystemProperties.Dependency_checkMemberUniqueness.getBoolean();
        }
        return checkUniqueness;
    }

    public void addToItemProperties(PropertyArrayList props, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        log.info("addToItemProperties(" + this.getName() + ") - Starting ...");
        BuiltInCollections builtInColl = BuiltInCollections.getValue(this.getName());
        if (this.convertToItemPropertyByScript(props, transactionKey) || builtInColl == null) {
            return;
        }
        block9: for (DependencyMember member : this.getMembers().list) {
            String memberUUID = member.getChildUUID();
            Integer memberVer = LocalObjectLoader.deriveVersionNumber(member.getBuiltInProperty(BuiltInVertexProperties.VERSION));
            if (memberVer == null) {
                throw new InvalidDataException("Version is null for Collection:" + this.getName() + ", MemberUUID:" + memberUUID);
            }
            if (member.convertToItemPropertyByScript(props, transactionKey) || builtInColl == null) continue;
            log.debug("addToItemProperties() - BuiltIn Dependency:" + this.getName() + " memberUUID:" + memberUUID);
            switch (builtInColl) {
                case AGGREGATE_SCRIPT: {
                    LocalObjectLoader.getScript(memberUUID, memberVer, transactionKey);
                    props.put(new Property(BuiltInItemProperties.AGGREGATE_SCRIPT_URN, memberUUID + ":" + memberVer));
                    continue block9;
                }
                case MASTER_SCHEMA: {
                    LocalObjectLoader.getSchema(memberUUID, memberVer, transactionKey);
                    props.put(new Property(BuiltInItemProperties.MASTER_SCHEMA_URN, memberUUID + ":" + memberVer));
                    continue block9;
                }
                case SCHEMA: {
                    LocalObjectLoader.getSchema(memberUUID, memberVer, transactionKey);
                    props.put(new Property(BuiltInItemProperties.SCHEMA_URN, memberUUID + ":" + memberVer));
                    continue block9;
                }
                case SCRIPT: {
                    LocalObjectLoader.getScript(memberUUID, memberVer, transactionKey);
                    props.put(new Property(BuiltInItemProperties.SCRIPT_URN, memberUUID + ":" + memberVer));
                    continue block9;
                }
                case QUERY: {
                    LocalObjectLoader.getQuery(memberUUID, memberVer, transactionKey);
                    props.put(new Property(BuiltInItemProperties.QUERY_URN, memberUUID + ":" + memberVer));
                    continue block9;
                }
                case STATE_MACHINE: {
                    if (!SystemProperties.Dependency_addStateMachineURN.getBoolean().booleanValue()) continue block9;
                    LocalObjectLoader.getStateMachine(memberUUID, memberVer, transactionKey);
                    props.put(new Property(BuiltInItemProperties.STATE_MACHINE_URN, memberUUID + ":" + memberVer));
                    continue block9;
                }
                case WORKFLOW: {
                    if (!SystemProperties.Dependency_addWorkflowURN.getBoolean().booleanValue()) continue block9;
                    LocalObjectLoader.getCompActDef(memberUUID, memberVer, transactionKey);
                    props.put(new Property(BuiltInItemProperties.WORKFLOW_URN, memberUUID + ":" + memberVer));
                    continue block9;
                }
            }
            log.trace("addToItemProperties() - Cannot handle BuiltIn Dependency:" + this.getName());
        }
    }

    private boolean convertToItemPropertyByScript(PropertyArrayList props, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        log.debug("convertToItemPropertyByScript() - Dependency:" + this.getName());
        String scriptName = (String)this.getBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME);
        if (StringUtils.isNotBlank((CharSequence)scriptName)) {
            Object result = this.evaluateScript(transactionKey);
            if (result != null && result instanceof PropertyArrayList) {
                props.merge((PropertyArrayList)result);
                return true;
            }
            throw new InvalidDataException("Script '" + scriptName + "' returned null or the wrong type");
        }
        return false;
    }

    public void addToVertexProperties(CastorHashMap props, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        log.debug("addToVertexProperties(" + this.getName() + ") - Starting ...");
        BuiltInCollections builtInColl = BuiltInCollections.getValue(this.getName());
        block15: for (DependencyMember member : this.getMembers().list) {
            String memberUUID = member.getChildUUID();
            Integer memberVer = LocalObjectLoader.deriveVersionNumber(member.getBuiltInProperty(BuiltInVertexProperties.VERSION));
            if (memberVer == null) {
                throw new InvalidDataException("Version is null for Collection:" + this.getName() + ", DependencyMember:" + memberUUID);
            }
            if (this.convertToVertextPropsByScript(props, member, transactionKey) || builtInColl == null) continue;
            log.debug("addToVertexProperties() - Dependency:" + this.getName() + " memberUUID:" + memberUUID);
            switch (builtInColl) {
                case SCHEMA: {
                    String uuid;
                    try {
                        LocalObjectLoader.getSchema(memberUUID, memberVer, transactionKey);
                        props.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, (Object)memberUUID);
                        props.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_VERSION, (Object)memberVer);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!props.containsKey(BuiltInVertexProperties.SCHEMA_NAME.getName())) continue block15;
                        log.trace("addToVertexProperties() - BACKWARD COMPABILITY: Dependency '" + this.getName() + "' is defined in Properties");
                        uuid = LocalObjectLoader.getSchema(props, transactionKey).getItemPath().getUUID().toString();
                        props.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, (Object)uuid);
                    }
                    break;
                }
                case SCRIPT: {
                    String uuid;
                    try {
                        LocalObjectLoader.getScript(memberUUID, memberVer, transactionKey);
                        props.setBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME, (Object)memberUUID);
                        props.setBuiltInProperty(BuiltInVertexProperties.SCRIPT_VERSION, (Object)memberVer);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!props.containsKey(BuiltInVertexProperties.SCRIPT_NAME.getName())) continue block15;
                        log.trace("addToVertexProperties() - BACKWARD COMPABILITY: Dependency '" + this.getName() + "' is defined in Properties");
                        uuid = LocalObjectLoader.getScript(props, transactionKey).getItemPath().getUUID().toString();
                        props.setBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME, (Object)uuid);
                    }
                    break;
                }
                case QUERY: {
                    String uuid;
                    try {
                        LocalObjectLoader.getQuery(memberUUID, memberVer, transactionKey);
                        props.setBuiltInProperty(BuiltInVertexProperties.QUERY_NAME, (Object)memberUUID);
                        props.setBuiltInProperty(BuiltInVertexProperties.QUERY_VERSION, (Object)memberVer);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!props.containsKey(BuiltInVertexProperties.QUERY_NAME.getName())) continue block15;
                        log.trace("addToVertexProperties() - BACKWARD COMPABILITY: Dependency '" + this.getName() + "' is defined in Properties");
                        uuid = LocalObjectLoader.getQuery(props, transactionKey).getItemPath().getUUID().toString();
                        props.setBuiltInProperty(BuiltInVertexProperties.QUERY_NAME, (Object)uuid);
                    }
                    break;
                }
                case STATE_MACHINE: {
                    String uuid;
                    try {
                        LocalObjectLoader.getStateMachine(memberUUID, memberVer, transactionKey);
                        props.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_NAME, (Object)memberUUID);
                        props.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_VERSION, (Object)memberVer);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!props.containsKey(BuiltInVertexProperties.STATE_MACHINE_NAME.getName())) continue block15;
                        log.trace("addToVertexProperties() -  BACKWARD COMPABILITY: Dependency '" + this.getName() + "' is defined in Properties");
                        uuid = LocalObjectLoader.getStateMachine(props, transactionKey).getItemPath().getUUID().toString();
                        props.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_NAME, (Object)uuid);
                    }
                    break;
                }
                case ACTIVITY: {
                    ActivityDef actDef = LocalObjectLoader.getActDef(memberUUID, memberVer, transactionKey);
                    CastorHashMap chm = null;
                    if (props.containsKey(BuiltInVertexProperties.ACTIVITY_DEF_URN.getName())) {
                        chm = (CastorHashMap)props.getBuiltInProperty(BuiltInVertexProperties.ACTIVITY_DEF_URN);
                    } else {
                        chm = new CastorHashMap();
                        props.setBuiltInProperty(BuiltInVertexProperties.ACTIVITY_DEF_URN, (Object)chm);
                    }
                    log.trace("addToVertexProperties(" + this.getName() + ") - actDef:" + actDef.getActName());
                    chm.put(actDef.getActName(), memberUUID + "~" + memberVer);
                    break;
                }
                default: {
                    log.trace("addToVertexProperties() - Cannot handle BuiltIn Dependency:" + this.getName());
                }
            }
        }
    }

    private boolean convertToVertextPropsByScript(CastorHashMap props, DependencyMember member, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        log.debug("convertToVertextPropsByScript() - Dependency:" + this.getName() + " memberUUID:" + member.getChildUUID());
        String scriptName = (String)member.getBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME);
        if (scriptName != null && scriptName.length() > 0) {
            CastorHashMap newProps = (CastorHashMap)member.evaluateScript(transactionKey);
            props.merge(newProps);
            return true;
        }
        return false;
    }

    public Object getBuiltInProperty(BuiltInVertexProperties prop) {
        return this.mProperties.getBuiltInProperty(prop);
    }

    public Object getBuiltInProperty(BuiltInVertexProperties prop, Object defValue) {
        return this.mProperties.getBuiltInProperty(prop, defValue);
    }

    public boolean containsBuiltInProperty(BuiltInVertexProperties prop) {
        return this.mProperties.containsKey(prop.getName());
    }

    protected Object evaluateScript(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        Script script = LocalObjectLoader.getScript(this.getProperties(), transactionKey);
        try {
            script.setInputParamValue("dependency", this);
            script.setInputParamValue("storage", Gateway.getStorage());
            script.setInputParamValue("lookup", Gateway.getLookup());
            return script.evaluate(null, this.getProperties(), null, null);
        }
        catch (ScriptingEngineException e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException(e.getMessage());
        }
    }

    public Collection.Type getType() {
        if (this.containsBuiltInProperty(BuiltInVertexProperties.DEPENDENCY_TYPE)) {
            return Collection.Type.valueOf((String)this.getBuiltInProperty(BuiltInVertexProperties.DEPENDENCY_TYPE));
        }
        return null;
    }

    public Collection.Cardinality getCardinality() {
        if (this.containsBuiltInProperty(BuiltInVertexProperties.DEPENDENCY_CARDINALITY)) {
            return Collection.Cardinality.valueOf((String)this.getBuiltInProperty(BuiltInVertexProperties.DEPENDENCY_CARDINALITY));
        }
        return null;
    }

    public String getToDependencyName(ItemPath referencedItem, TransactionKey transactionKey) throws InvalidDataException {
        String[] toDependencyNames;
        String toDependencyName = "";
        String currentItemType = PropertyUtility.getPropertyValue(referencedItem, BuiltInItemProperties.TYPE, "", transactionKey);
        for (String nameValueString : toDependencyNames = ((String)this.getBuiltInProperty(BuiltInVertexProperties.DEPENDENCY_TO, "")).trim().split(",")) {
            String[] nameValue = nameValueString.trim().split(":");
            if (nameValue.length == 1) {
                toDependencyName = nameValue[0].trim();
            } else if (currentItemType.equals(nameValue[0].trim())) {
                toDependencyName = nameValue[1].trim();
            }
            if (StringUtils.isNotBlank((CharSequence)toDependencyName)) break;
        }
        if (StringUtils.isBlank((CharSequence)toDependencyName)) {
            throw new InvalidDataException("Invalid value MemberProperty:" + String.valueOf((Object)BuiltInVertexProperties.DEPENDENCY_TO) + "=" + String.valueOf(toDependencyNames) + " item:" + referencedItem.getItemName(transactionKey));
        }
        return toDependencyName;
    }

    public String toString() {
        Collection.Type type = this.getType();
        Collection.Cardinality cardinality = this.getCardinality();
        return "Dependency(" + this.getName() + (String)(cardinality != null ? " " + String.valueOf((Object)cardinality) : "") + (String)(type != null ? " " + String.valueOf((Object)type) : "") + " size:" + this.getMembers().list.size() + ")";
    }
}

