/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.collection;

import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyMember
implements CollectionMember {
    private static final Logger log = LoggerFactory.getLogger(DependencyMember.class);
    private ItemPath mItemPath = null;
    private int mId = -1;
    private CastorHashMap mProperties = new CastorHashMap();
    private String mClassProps = "";

    @Override
    public ItemPath getItemPath() {
        return this.mItemPath;
    }

    public void setProperties(CastorHashMap props) {
        this.mProperties = props;
    }

    @Override
    public CastorHashMap getProperties() {
        return this.mProperties;
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.mProperties.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.mProperties.setKeyValuePairs(pairs);
    }

    @Override
    public int getID() {
        return this.mId;
    }

    public void setID(int id) {
        this.mId = id;
    }

    public void setClassProps(String props) {
        this.mClassProps = props;
    }

    @Override
    public String getClassProps() {
        return this.mClassProps;
    }

    private boolean checkType() {
        return this.getBuiltInProperty(BuiltInVertexProperties.DEPENDENCY_DISABLE_TYPE_CHECK) == null;
    }

    @Override
    public void assignItem(ItemPath itemPath, TransactionKey transactionKey) throws InvalidCollectionModification {
        if (itemPath == null) {
            log.warn("assignItem() -  Assigning null itemPath to a collection of Item:" + this.mItemPath.getItemName(transactionKey));
        } else if (this.checkType()) {
            if (this.mClassProps == null || this.getProperties() == null) {
                throw new InvalidCollectionModification("ClassProps not yet set. Cannot check membership validity.");
            }
            StringTokenizer sub = new StringTokenizer(this.mClassProps, ",");
            while (sub.hasMoreTokens()) {
                String aClassProp = sub.nextToken();
                try {
                    String memberValue = (String)this.getProperties().get(aClassProp);
                    Property itemProperty = (Property)Gateway.getStorage().get(itemPath, String.valueOf((Object)ClusterType.PROPERTY) + "/" + aClassProp, transactionKey);
                    if (itemProperty == null) {
                        throw new InvalidCollectionModification("Property " + aClassProp + " does not exist for item " + String.valueOf(itemPath));
                    }
                    if (itemProperty.getValue().equalsIgnoreCase(memberValue)) continue;
                    throw new InvalidCollectionModification("Values of mandatory prop " + aClassProp + " do not match " + itemProperty.getValue() + "!=" + memberValue);
                }
                catch (ObjectNotFoundException | PersistencyException ex) {
                    log.error("assignItem() - Error checking properties", (Throwable)ex);
                    throw new InvalidCollectionModification("Error checking properties", (Throwable)ex);
                }
            }
        }
        this.mItemPath = itemPath;
    }

    @Override
    public void clearItem() {
        this.mItemPath = null;
    }

    @Override
    public ItemProxy resolveItem(TransactionKey transactionKey) throws ObjectNotFoundException {
        return Gateway.getProxy(this.mItemPath, transactionKey);
    }

    public void setChildUUID(String uuid) throws InvalidCollectionModification, InvalidItemPathException {
        this.mItemPath = new ItemPath(uuid);
    }

    @Override
    public String getChildUUID() {
        return this.mItemPath.getUUID().toString();
    }

    public Object getProperty(String prop) {
        return this.mProperties.get(prop);
    }

    public void setProperty(String prop, Object val) {
        this.mProperties.put(prop, val, false);
    }

    public Object getBuiltInProperty(BuiltInVertexProperties prop) {
        return this.mProperties.get(prop.getName());
    }

    public void setBuiltInProperty(BuiltInVertexProperties prop, Object val) {
        this.mProperties.put(prop.getName(), val, false);
    }

    protected Object evaluateScript(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        log.debug("evaluateScript() - memberUUID:" + this.getChildUUID());
        Script script = LocalObjectLoader.getScript(this.getProperties(), transactionKey);
        try {
            script.setInputParamValue("dependencyMember", this);
            script.setInputParamValue("storage", Gateway.getStorage());
            script.setInputParamValue("lookup", Gateway.getLookup());
            return script.evaluate(this.getItemPath(), this.getProperties(), null, transactionKey);
        }
        catch (ScriptingEngineException e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException(e.getMessage());
        }
    }

    public void updatePropertieFromDescription(CastorHashMap propDesc, DependencyMember newMember) throws ObjectNotFoundException, InvalidCollectionModification {
        for (String key : propDesc.keySet()) {
            Object newValue = newMember != null ? (Object)newMember.mProperties.get(key) : null;
            Object newDefaultValue = propDesc.get(key);
            if (this.mProperties.containsKey(key)) {
                if (this.mClassProps.contains(key)) {
                    this.mProperties.put(key, newDefaultValue);
                    continue;
                }
                if (newValue == null) continue;
                this.mProperties.put(key, newValue);
                continue;
            }
            if (this.mClassProps.contains(key)) {
                this.mProperties.put(key, newDefaultValue);
                continue;
            }
            this.mProperties.put(key, newValue != null ? newValue : (Object)newDefaultValue);
        }
        Iterator propsNames = this.mProperties.keySet().iterator();
        while (propsNames.hasNext()) {
            String key;
            key = (String)propsNames.next();
            if (propDesc.containsKey(key)) continue;
            propsNames.remove();
        }
    }

    public void updateProperties(CastorHashMap newProps) throws ObjectNotFoundException, InvalidCollectionModification {
        for (Map.Entry newProp : newProps.entrySet()) {
            Object value;
            String key = (String)newProp.getKey();
            if (this.mClassProps.contains(key) && !(value = newProp.getValue()).equals(this.getProperties().get(newProp.getKey()))) {
                throw new InvalidCollectionModification("Dependency cannot change classProperties:" + key);
            }
            if (this.getProperties().containsKey(newProp.getKey())) {
                this.getProperties().put((String)newProp.getKey(), newProp.getValue());
                continue;
            }
            throw new ObjectNotFoundException("Property " + (String)newProp.getKey() + " does not exists for slotID:" + this.getID());
        }
    }

    public boolean convertToItemPropertyByScript(PropertyArrayList props, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        log.debug("convertToItemPropertyByScript() - memberUUID:" + this.getChildUUID());
        String scriptName = (String)this.getBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME);
        if (scriptName != null && scriptName.length() > 0) {
            Object result = this.evaluateScript(transactionKey);
            if (result != null && result instanceof PropertyArrayList) {
                props.merge((PropertyArrayList)result);
                return true;
            }
            throw new InvalidDataException("Script '" + scriptName + "' returned null or the wrong type");
        }
        return false;
    }
}

