/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.common;

import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import java.lang.runtime.SwitchBootstraps;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.scripting.ScriptErrorException;

public class CriseVertxException
extends Exception {
    private static final long serialVersionUID = 5606562389374279530L;
    private final int failureCode;

    public CriseVertxException() {
        this.failureCode = FailureCodes.InternalServerError.getId();
    }

    public CriseVertxException(String msg) {
        super(msg);
        this.failureCode = FailureCodes.InternalServerError.getId();
    }

    public CriseVertxException(Throwable cause) {
        super(cause.getMessage(), cause);
        this.failureCode = FailureCodes.InternalServerError.getId();
    }

    public CriseVertxException(String msg, Throwable cause) {
        super(msg, cause);
        this.failureCode = FailureCodes.InternalServerError.getId();
    }

    public CriseVertxException(FailureCodes code) {
        this.failureCode = code.getId();
    }

    public CriseVertxException(FailureCodes code, String msg) {
        super(msg);
        this.failureCode = code.getId();
    }

    public CriseVertxException(FailureCodes code, Throwable cause) {
        super(cause.getMessage(), cause);
        this.failureCode = code.getId();
    }

    public CriseVertxException(FailureCodes code, String msg, Throwable cause) {
        super(msg, cause);
        this.failureCode = code.getId();
    }

    public ServiceException toServiceException() {
        return new ServiceException(this.failureCode, this.getMessage(), this.getDebugInfo());
    }

    public static ServiceException toServiceException(Throwable t) {
        if (t instanceof CriseVertxException) {
            CriseVertxException criseEx = (CriseVertxException)t;
            return criseEx.toServiceException();
        }
        JsonObject debugInfo = CriseVertxException.convertToDebugInfo(t);
        return new ServiceException(FailureCodes.InternalServerError.getId(), t.getMessage(), debugInfo);
    }

    public <T> AsyncResult<T> failService() {
        return ServiceException.fail((int)this.failureCode, (String)this.getMessage(), (JsonObject)this.getDebugInfo());
    }

    public static <T> AsyncResult<T> failService(Throwable ex) {
        JsonObject debugInfo = CriseVertxException.convertToDebugInfo(ex);
        return ServiceException.fail((int)FailureCodes.InternalServerError.getId(), (String)ex.getMessage(), (JsonObject)debugInfo);
    }

    public static JsonObject convertToDebugInfo(Throwable ex) {
        if (ex == null) {
            return null;
        }
        JsonObject debugInfo = new JsonObject();
        debugInfo.put("type", (Object)ex.getClass().getSimpleName());
        JsonArray stackTrace = new JsonArray();
        debugInfo.put("stackTrace", (Object)stackTrace);
        for (String frame : ExceptionUtils.getStackFrames((Throwable)ex)) {
            stackTrace.add((Object)frame);
        }
        return debugInfo;
    }

    public JsonObject getDebugInfo() {
        return CriseVertxException.convertToDebugInfo(this);
    }

    public JsonObject getServiceDebugInfo() {
        Throwable cause = this.getCause();
        if (cause instanceof ServiceException) {
            return ((ServiceException)cause).getDebugInfo();
        }
        return null;
    }

    public static CriseVertxException convertThrowable(Throwable ex) {
        if (ex == null) {
            return null;
        }
        if (ex instanceof CriseVertxException) {
            return (CriseVertxException)ex;
        }
        if (ex instanceof ServiceException) {
            ServiceException serviceEx = (ServiceException)ex;
            int failureCode = serviceEx.failureCode();
            FailureCodes failureCodes = FailureCodes.getValue(failureCode);
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"AccessRightsError", "CannotManage", "InvalidCollectionModification", "InvalidData", "InvalidItemPath", "InvalidTransition", "ObjectAlreadyExists", "ObjectCannotBeUpdated", "ObjectNotFound", "PersistencyError", "ScriptError"}, (FailureCodes)failureCodes, n)) {
                case 0 -> new AccessRightsException(ex);
                case 1 -> new CannotManageException(ex);
                case 2 -> new InvalidCollectionModification(ex);
                case 3 -> new InvalidDataException(ex);
                case 4 -> new InvalidItemPathException(ex);
                case 5 -> new InvalidTransitionException(ex);
                case 6 -> new ObjectAlreadyExistsException(ex);
                case 7 -> new ObjectCannotBeUpdated(ex);
                case 8 -> new ObjectNotFoundException(ex);
                case 9 -> new PersistencyException(ex);
                case 10 -> new ScriptErrorException(ex);
                default -> null;
            };
        }
        return null;
    }

    public static CriseVertxException convertFutureException(ExecutionException futureException) {
        CriseVertxException result = CriseVertxException.convertThrowable(futureException.getCause());
        if (result == null) {
            result = new CriseVertxException(futureException);
        }
        return result;
    }

    public static enum FailureCodes {
        InternalServerError(999),
        AccessRightsError(101),
        CannotManage(102),
        InvalidCollectionModification(103),
        InvalidData(104),
        InvalidTransition(105),
        ObjectAlreadyExists(106),
        ObjectCannotBeUpdated(107),
        ObjectNotFound(108),
        PersistencyError(109),
        InvalidItemPath(110),
        ScriptError(111);

        private int id;

        private FailureCodes(int code) {
            this.id = code;
        }

        public static FailureCodes getValue(int id) {
            for (FailureCodes code : FailureCodes.values()) {
                if (code.getId() != id) continue;
                return code;
            }
            return null;
        }

        public int getId() {
            return this.id;
        }
    }
}

