/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.DescriptionObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainContext
implements DescriptionObject {
    private static final Logger log = LoggerFactory.getLogger(DomainContext.class);
    private String namespace;
    private String name;
    private Integer version;
    private ItemPath itemPath;
    private DomainPath domainPath;
    private List<DomainContext> subCcontexts = new ArrayList<DomainContext>();

    public DomainContext() {
    }

    public DomainContext(String path) throws InvalidDataException {
        this(new DomainPath(path));
    }

    public DomainContext(String path, Integer v) throws InvalidDataException {
        this(new DomainPath(path), null, v);
    }

    public DomainContext(DomainPath path) throws InvalidDataException {
        this(path, null, null);
    }

    public DomainContext(String path, String ns, Integer v) throws InvalidDataException {
        this(new DomainPath(path), ns, v);
    }

    public DomainContext(DomainPath path, String ns, Integer v) throws InvalidDataException {
        if (path.getTarget() != null) {
            throw new InvalidDataException("DomainContext '" + String.valueOf(path) + "' has target");
        }
        this.namespace = ns;
        this.version = v;
        this.domainPath = path;
        String[] origPath = this.domainPath.getPath();
        CharSequence[] capitalized = Arrays.stream(origPath).map(s -> StringUtils.capitalize((String)s)).collect(Collectors.toList()).toArray(new String[origPath.length]);
        this.name = String.join((CharSequence)"", capitalized) + "Context";
        log.debug("ctor() - name:{}", (Object)this.name);
    }

    @Override
    public String getItemID() {
        return this.itemPath != null ? this.itemPath.getUUID().toString() : null;
    }

    @Override
    public CollectionArrayList makeDescCollections(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        CollectionArrayList retArr = new CollectionArrayList();
        return retArr;
    }

    public DomainContext getParentContext() throws InvalidDataException {
        DomainPath parentPath = this.domainPath.getParent();
        if (parentPath != null) {
            return new DomainContext(parentPath.getStringPath());
        }
        return null;
    }

    public List<DomainContext> getSubContexts(TransactionKey transactionKey) {
        List<Path> children = Gateway.getLookup().getChildren((Path)this.domainPath, (int)0, (int)0, (boolean)true, (TransactionKey)transactionKey).rows;
        ArrayList<DomainContext> result = new ArrayList<DomainContext>();
        for (Path child : children) {
            DomainPath childDomainPath = (DomainPath)child;
            try {
                if (childDomainPath.getTarget() != null) continue;
                result.add(new DomainContext(childDomainPath));
            }
            catch (InvalidDataException invalidDataException) {}
        }
        return result;
    }

    public void setDomainPath(String path) {
        this.domainPath = new DomainPath(path);
    }

    public String getDomainPath() {
        return this.domainPath.getStringPath(false);
    }

    @Override
    public BuiltInResources getResourceType() {
        return BuiltInResources.DOMAIN_CONTEXT_RESOURCE;
    }

    public String toString() {
        return "DomainContext(" + this.getDomainPath() + ")";
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public ItemPath getItemPath() {
        return this.itemPath;
    }

    public List<DomainContext> getSubCcontexts() {
        return this.subCcontexts;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public void setItemPath(ItemPath itemPath) {
        this.itemPath = itemPath;
    }

    public void setSubCcontexts(List<DomainContext> subCcontexts) {
        this.subCcontexts = subCcontexts;
    }
}

