/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import java.util.List;
import org.cristalise.kernel.entity.Item;

public class ItemVertxEBProxy
implements Item {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public ItemVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public ItemVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
        this._vertx = vertx;
        this._address = address;
        this._options = options;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public Future<String> requestAction(String itemUuid, String agentUuid, String stepPath, int transitionID, String requestData, String fileName, List<Byte> attachment) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("itemUuid", (Object)itemUuid);
        _json.put("agentUuid", (Object)agentUuid);
        _json.put("stepPath", (Object)stepPath);
        _json.put("transitionID", (Object)transitionID);
        _json.put("requestData", (Object)requestData);
        _json.put("fileName", (Object)fileName);
        _json.put("attachment", (Object)new JsonArray(attachment));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "requestAction");
        _deliveryOptions.getHeaders().set("action", "requestAction");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (String)msg.body());
    }

    @Override
    public Future<String> queryLifeCycle(String itemUuid, String agentUuid, boolean filter) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("itemUuid", (Object)itemUuid);
        _json.put("agentUuid", (Object)agentUuid);
        _json.put("filter", (Object)filter);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "queryLifeCycle");
        _deliveryOptions.getHeaders().set("action", "queryLifeCycle");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (String)msg.body());
    }
}

