/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity;

import io.vertx.core.Future;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.shareddata.SharedData;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CriseVertxException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.Item;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.entity.JobArrayList;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.ItemPredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepContainer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.C2KLocalObjectMap;
import org.cristalise.kernel.persistency.ClusterStorageManager;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.security.SecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceableEntity
implements Item {
    private static final Logger log = LoggerFactory.getLogger(TraceableEntity.class);
    protected final ClusterStorageManager mStorage = Gateway.getStorage();

    protected PredefinedStepContainer getNewPredefStepContainer() {
        return new ItemPredefinedStepContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<String> requestAction(String itemUuid, String agentUuid, String stepPath, int transitionID, String requestData, String fileName, List<Byte> attachment) {
        Future future;
        TransactionKey transactionKey;
        AgentProxy agent;
        ItemProxy item;
        try {
            item = Gateway.getProxy(Gateway.getLookup().getItemPath(itemUuid));
            agent = Gateway.getAgentProxy((AgentPath)Gateway.getLookup().getItemPath(agentUuid));
            transactionKey = new TransactionKey(item.getPath());
        }
        catch (Throwable t) {
            log.error("requestAction()", t);
            return Future.failedFuture((Throwable)CriseVertxException.toServiceException(t));
        }
        SharedData sharedData = Gateway.getVertx().sharedData();
        Lock lock = (Lock)Future.await((Future)sharedData.getLockWithTimeout(itemUuid, 5000L));
        try {
            this.mStorage.begin(transactionKey);
            String finalOutcome = this.requestAction(item, agent, stepPath, transitionID, requestData, fileName, attachment, transactionKey);
            this.mStorage.commit(transactionKey);
            future = Future.succeededFuture((Object)finalOutcome);
        }
        catch (Throwable originalEx) {
            Future future2;
            try {
                log.error("requestAction() - item:{} by agent:{} executing {}", new Object[]{item, agent, stepPath, originalEx});
                try {
                    this.mStorage.abort(transactionKey);
                }
                catch (PersistencyException e) {
                    log.debug("requestAction() - Could not abort original transaction {}", (Object)transactionKey, (Object)e);
                }
                if (SystemProperties.StateMachine_enableErrorHandling.getBoolean().booleanValue()) {
                    this.handleError(stepPath, item, agent, originalEx);
                }
                future2 = Future.failedFuture((Throwable)CriseVertxException.toServiceException(originalEx));
            }
            catch (Throwable throwable) {
                try {
                    lock.release();
                    throw throwable;
                }
                catch (Throwable t) {
                    log.error("requestAction() - could not lock item:{}", (Object)itemUuid, (Object)t);
                    return Future.failedFuture((Throwable)CriseVertxException.toServiceException(t));
                }
            }
            lock.release();
            return future2;
        }
        lock.release();
        return future;
    }

    private String requestAction(ItemProxy item, AgentProxy agent, String stepPath, int transitionID, String requestData, String fileName, List<Byte> attachment, TransactionKey transactionKey) throws Exception {
        log.info("=======================================================================================");
        log.info("requestAction({}) Transition {} on {} by agent {}", new Object[]{item, transitionID, stepPath, agent});
        Workflow lifeCycle = (Workflow)this.mStorage.get(item.getPath(), String.valueOf((Object)ClusterType.LIFECYCLE) + "/workflow", transactionKey);
        SecurityManager secMan = Gateway.getSecurityManager();
        Activity act = (Activity)lifeCycle.search(stepPath);
        if (act != null) {
            if (!secMan.checkPermissions(agent.getPath(), act, item.getPath(), transactionKey)) {
                String errorMsg = "'" + agent.getName() + "' is NOT permitted to execute step:" + stepPath;
                if (log.isTraceEnabled()) {
                    log.error(errorMsg);
                    for (RolePath role : agent.getRoles()) {
                        log.error(role.dump());
                    }
                }
                throw new AccessRightsException(errorMsg);
            }
        } else {
            throw new InvalidDataException("Step '" + stepPath + "' is not available for item:" + String.valueOf(item));
        }
        byte[] bytes = ArrayUtils.toPrimitive((Byte[])attachment.toArray(new Byte[0]));
        String finalOutcome = lifeCycle.requestAction(agent.getPath(), stepPath, item.getPath(), transitionID, requestData, fileName, bytes, transactionKey);
        if (!stepPath.startsWith("workflow/predefined")) {
            this.mStorage.put(item.getPath(), lifeCycle, transactionKey);
            this.mStorage.removeCluster(item.getPath(), ClusterType.JOB, transactionKey);
            List newJobs = ((CompositeActivity)lifeCycle.search("workflow/domain")).calculateJobs(agent.getPath(), item.getPath(), true);
            for (Job newJob : newJobs) {
                this.mStorage.put(item.getPath(), newJob, transactionKey);
                if (!StringUtils.isNotBlank((CharSequence)newJob.getRoleOverride())) continue;
                newJob.sendToRoleChannel();
            }
        }
        if (stepPath.equals("workflow/predefined/Erase")) {
            log.info("requestAction() - deleting ItemPath:{}", (Object)item);
            Gateway.getLookupManager().delete(item.getPath(), transactionKey);
        }
        return finalOutcome;
    }

    private void handleError(String stepPath, ItemProxy item, AgentProxy agent, Throwable cause) {
        TransactionKey errorTransactionKey = new TransactionKey(item.getPath());
        try {
            this.mStorage.begin(errorTransactionKey);
            String errorOutcome = this.requestErrorAction(item, agent, stepPath, cause, errorTransactionKey);
            if (StringUtils.isNotBlank((CharSequence)errorOutcome)) {
                this.mStorage.commit(errorTransactionKey);
            } else {
                this.mStorage.abort(errorTransactionKey);
            }
        }
        catch (PersistencyException pex) {
            try {
                this.mStorage.abort(errorTransactionKey);
            }
            catch (PersistencyException e) {
                log.debug("handleError() - Could not abort error transaction {}", (Object)errorTransactionKey, (Object)e);
            }
            log.error("handleError() - ", (Throwable)pex);
        }
    }

    private String requestErrorAction(ItemProxy item, AgentProxy agent, String stepPath, Throwable cause, TransactionKey transactionKey) {
        try {
            Workflow lifeCycle = (Workflow)this.mStorage.get(item.getPath(), String.valueOf((Object)ClusterType.LIFECYCLE) + "/workflow", transactionKey);
            int errorTransitionId = ((Activity)lifeCycle.search(stepPath)).getErrorTransitionId();
            if (errorTransitionId == -1) {
                log.debug("requestErrorAction({}) - StateMachine does not define error transition for step:{}", (Object)item, (Object)stepPath);
                return null;
            }
            log.info("---------------------------------------------------------------------------------------");
            log.info("requestErrorAction({}) - transitionId {} on {} by {}", new Object[]{item, errorTransitionId, stepPath, agent});
            String errorOutcome = Gateway.getMarshaller().marshall(new ErrorInfo(cause));
            errorOutcome = lifeCycle.requestAction(agent.getPath(), stepPath, item.getPath(), errorTransitionId, errorOutcome, "", null, transactionKey);
            this.mStorage.put(item.getPath(), lifeCycle, transactionKey);
            return errorOutcome;
        }
        catch (Exception e) {
            log.error("requestErrorAction()", (Throwable)e);
            return "";
        }
    }

    @Override
    @Deprecated
    public Future<String> queryLifeCycle(String itemUuid, String agentUuid, boolean filter) {
        AgentProxy agent;
        ItemProxy item;
        try {
            item = Gateway.getProxy(Gateway.getLookup().getItemPath(itemUuid));
            agent = Gateway.getAgentProxy((AgentPath)Gateway.getLookup().getItemPath(agentUuid));
        }
        catch (Throwable t) {
            log.error("queryLifeCycle({})", (Object)itemUuid, (Object)t);
            return Future.failedFuture((Throwable)CriseVertxException.toServiceException(t));
        }
        log.info("=======================================================================================");
        log.info("queryLifeCycle({}) - agent:{}", (Object)item, (Object)agent);
        try {
            Workflow wf = (Workflow)this.mStorage.get(item.getPath(), String.valueOf((Object)ClusterType.LIFECYCLE) + "/workflow", null);
            C2KLocalObjectMap jobs = (C2KLocalObjectMap)this.mStorage.get(item.getPath(), ClusterType.JOB.getName(), null);
            SecurityManager secMan = Gateway.getSecurityManager();
            JobArrayList jobBag = new JobArrayList();
            for (Job j : jobs.values()) {
                Activity act = (Activity)wf.search(j.getStepPath());
                if (!secMan.checkPermissions(agent.getPath(), act, item.getPath(), null)) continue;
                try {
                    j.getTransition().checkPerformingRole(act, agent.getPath());
                    jobBag.list.add(j);
                }
                catch (AccessRightsException accessRightsException) {}
            }
            log.info("queryLifeCycle({}) - Returning {} jobs.", (Object)item, (Object)jobBag.list.size());
            try {
                String result = Gateway.getMarshaller().marshall(jobBag);
                return Future.succeededFuture((Object)result);
            }
            catch (Throwable t) {
                log.error("queryLifeCycle({})", (Object)item, (Object)t);
                return Future.failedFuture((Throwable)CriseVertxException.toServiceException(t));
            }
        }
        catch (Exception t) {
            log.error("queryLifeCycle({}) - Unknown error", (Object)item, (Object)t);
            return Future.failedFuture((Throwable)CriseVertxException.toServiceException(t));
        }
    }
}

