/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.imports.ImportRole;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ProxyManager;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.predefined.CreateItemFromDescription;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.LookupManager;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleImport;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.security.BuiltInAuthc;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportAgent
extends ModuleImport
implements DescriptionObject {
    private static final Logger log = LoggerFactory.getLogger(ImportAgent.class);
    protected Integer version;
    private String initialPath;
    private String password;
    private List<Property> properties = new ArrayList<Property>();
    private List<ImportRole> roles = new ArrayList<ImportRole>();

    public ImportAgent() {
    }

    public ImportAgent(String folder, String aName, Integer version, String pwd) {
        this.setInitialPath(folder);
        this.setName(aName);
        this.setVersion(version);
        this.setPassword(pwd);
    }

    public ImportAgent(String folder, String aName, String pwd) {
        this(folder, aName, null, pwd);
    }

    public ImportAgent(String aName, String pwd) {
        this(null, aName, null, pwd);
    }

    @Override
    public void setID(String uuid) throws InvalidItemPathException {
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            this.itemPath = new AgentPath(new ItemPath(uuid), this.name);
        }
    }

    @Override
    public DomainPath getDomainPath() {
        if (this.domainPath == null && StringUtils.isNotBlank((CharSequence)this.initialPath)) {
            this.domainPath = new DomainPath(new DomainPath(this.initialPath), this.name);
        }
        return this.domainPath;
    }

    @Override
    public boolean exists(TransactionKey transactionKey) {
        return this.getAgentPath(transactionKey).exists(transactionKey);
    }

    @Override
    public Path create(AgentPath agentPath, boolean reset, TransactionKey transactionKey) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, ObjectAlreadyExistsException {
        if (this.roles.isEmpty()) {
            throw new ObjectNotFoundException("Agent '" + this.name + "' must declare at least one Role ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.initialPath)) {
            this.getDomainPath();
            if (this.domainPath.exists(transactionKey)) {
                ItemPath domItem = this.domainPath.getItemPath(transactionKey);
                if (!this.getItemPath(transactionKey).equals(domItem)) {
                    throw new CannotManageException("'" + String.valueOf(this.domainPath) + "' was found with the different itemPath (" + String.valueOf(this.domainPath.getItemPath(transactionKey)) + " vs " + String.valueOf(this.getItemPath(transactionKey)) + ")");
                }
            } else {
                this.isDOMPathExists = false;
            }
        }
        this.properties.add(new Property(BuiltInItemProperties.NAME, this.name, true));
        this.properties.add(new Property(BuiltInItemProperties.TYPE, "Agent", false));
        LookupManager lookupManager = Gateway.getLookupManager();
        try {
            CreateItemFromDescription.storeItem(agentPath, this.getOrCreateAgentPath(transactionKey), new PropertyArrayList(this.properties), null, (CompositeActivity)LocalObjectLoader.getCompActDef("NoWorkflow", 0, transactionKey).instantiate(transactionKey), null, null, transactionKey);
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                lookupManager.setAgentPassword(this.getAgentPath(transactionKey), this.password, false, transactionKey);
            }
        }
        catch (Exception ex) {
            log.error("Error initialising new agent name:{}", (Object)this.name, (Object)ex);
            lookupManager.delete(this.getAgentPath(transactionKey), transactionKey);
            throw new CannotManageException("Error initialising new agent name:" + this.name);
        }
        for (ImportRole role : this.roles) {
            RolePath rp = role.getRolePath();
            if (rp.exists(transactionKey)) {
                if (this.getAgentPath().hasRole(rp, transactionKey)) continue;
                lookupManager.addRole(this.getAgentPath(), rp, transactionKey);
                continue;
            }
            if (SystemProperties.Module_ImportAgent_enableRoleCreation.getBoolean().booleanValue()) {
                RolePath thisRole = (RolePath)role.create(agentPath, reset, transactionKey);
                lookupManager.addRole(this.getAgentPath(), thisRole, transactionKey);
                continue;
            }
            throw new CannotManageException("Role '" + String.valueOf(rp) + "' does not exists");
        }
        if (this.domainPath != null && !this.isDOMPathExists) {
            this.domainPath.setItemPath(this.getItemPath(transactionKey));
            lookupManager.add(this.domainPath, transactionKey);
        }
        return this.getAgentPath();
    }

    private AgentPath getOrCreateAgentPath(TransactionKey transactionKey) throws ObjectNotFoundException, CannotManageException, ObjectAlreadyExistsException, ObjectCannotBeUpdated {
        AgentPath ap = this.getAgentPath(transactionKey);
        if (ap.exists(transactionKey)) {
            log.info("getActiveEntity() - Existing agent:{}", (Object)this.name);
            this.isNewItem = false;
        } else {
            log.info("getActiveEntity() - Creating agent:{}", (Object)this.name);
            Gateway.getLookupManager().add(ap, transactionKey);
        }
        return ap;
    }

    public AgentPath getAgentPath() {
        return this.getAgentPath(null);
    }

    public AgentProxy getProxy() {
        try {
            return ProxyManager.getAgentProxy(this.getAgentPath());
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    public AgentPath getAgentPath(TransactionKey transactionKey) {
        return (AgentPath)this.getItemPath(transactionKey);
    }

    @Override
    public ItemPath getItemPath(TransactionKey transactionKey) {
        if (this.itemPath == null) {
            try {
                this.itemPath = Gateway.getLookup().getAgentPath(this.name, transactionKey);
            }
            catch (ObjectNotFoundException ex) {
                this.itemPath = new AgentPath(new ItemPath(), this.name);
            }
        }
        return this.itemPath;
    }

    public void addRoles(List<RolePath> newRoles) {
        for (RolePath rp : newRoles) {
            this.roles.add(ImportRole.getImportRole(rp));
        }
    }

    public void addRole(BuiltInAuthc role) {
        this.addRole(role.getName());
    }

    public void addRole(String roleName) {
        this.addRole(new ImportRole(roleName));
    }

    public void addRole(ImportRole ir) {
        this.roles.add(ir);
    }

    public void addRole(RolePath rp) {
        this.addRole(ImportRole.getImportRole(rp));
    }

    @Override
    public String getItemID() {
        return this.getID();
    }

    @Override
    public CollectionArrayList makeDescCollections(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        return new CollectionArrayList();
    }

    @Override
    public BuiltInResources getResourceType() {
        return BuiltInResources.AGENT_DESC_RESOURCE;
    }

    public String toString() {
        return "ImportAgent(name:" + this.name + " version:" + this.version + " status:" + String.valueOf((Object)this.resourceChangeStatus) + ")";
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public String getInitialPath() {
        return this.initialPath;
    }

    public String getPassword() {
        return this.password;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<ImportRole> getRoles() {
        return this.roles;
    }

    @Override
    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setInitialPath(String initialPath) {
        this.initialPath = initialPath;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void setRoles(List<ImportRole> roles) {
        this.roles = roles;
    }
}

