/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.imports.ImportAggregation;
import org.cristalise.kernel.entity.imports.ImportDependency;
import org.cristalise.kernel.entity.imports.ImportOutcome;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.entity.proxy.ProxyManager;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.CreateItemFromDescription;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleImport;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.security.BuiltInAuthc;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportItem
extends ModuleImport
implements DescriptionObject {
    private static final Logger log = LoggerFactory.getLogger(ImportItem.class);
    protected Integer version;
    protected String initialPath;
    protected String workflow;
    protected Integer workflowVer;
    protected PropertyArrayList properties = new PropertyArrayList();
    protected ArrayList<ImportAggregation> aggregationList = new ArrayList();
    protected ArrayList<ImportDependency> dependencyList = new ArrayList();
    protected ArrayList<ImportOutcome> outcomes = new ArrayList();
    protected CompositeActivityDef compActDef;
    protected Workflow wf;

    public ImportItem() {
    }

    public ImportItem(String ns, String name, Integer version, String initialPath, ItemPath itemPath, String wf, Integer wfVer) {
        this.setNamespace(ns);
        this.setName(name);
        this.setVersion(version);
        this.setItemPath(itemPath);
        this.setInitialPath(initialPath);
        this.setWorkflow(wf);
        this.setWorkflowVer(wfVer);
        this.compActDef = null;
        wf = null;
    }

    public ImportItem(String ns, String name, String initialPath, ItemPath itemPath, String wf, Integer wfVer) {
        this(ns, name, null, initialPath, itemPath, wf, wfVer);
    }

    public ImportItem(String name, String initialPath, ItemPath itemPath, String wf) {
        this(null, name, null, initialPath, itemPath, wf, null);
    }

    @Override
    public DomainPath getDomainPath() {
        if (this.domainPath == null) {
            this.domainPath = new DomainPath(new DomainPath(this.initialPath), this.name);
        }
        return this.domainPath;
    }

    @Override
    public boolean exists(TransactionKey transactionKey) {
        return this.getDomainPath().exists(transactionKey);
    }

    @Override
    public ItemPath getItemPath() {
        return this.getItemPath(null);
    }

    public ItemProxy getProxy() {
        try {
            return ProxyManager.getProxy(this.getItemPath());
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    public int getWfVersion() {
        return this.workflowVer == null ? 0 : this.workflowVer;
    }

    @Override
    public ItemPath getItemPath(TransactionKey transactionKey) {
        if (this.itemPath == null) {
            this.getDomainPath();
            if (this.domainPath.exists(transactionKey)) {
                try {
                    this.itemPath = this.domainPath.getItemPath(transactionKey);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
            }
        }
        return this.itemPath;
    }

    @Override
    public void setNamespace(String ns) {
        super.setNamespace(ns);
        if (this.initialPath == null) {
            this.initialPath = "/desc/" + ns;
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    private void setOrCreateItemPath(TransactionKey transactionKey) throws ObjectNotFoundException, CannotManageException, ObjectAlreadyExistsException, ObjectCannotBeUpdated {
        this.getItemPath(transactionKey);
        if (this.itemPath != null && this.itemPath.exists(transactionKey)) {
            log.info("getOrCreateItemPath() - Verifying module item {} at {}", (Object)this.itemPath, (Object)this.domainPath);
            this.isNewItem = false;
        } else {
            if (this.itemPath == null) {
                this.itemPath = new ItemPath();
            }
            log.info("getOrCreateItemPath() - Creating module item {} at {}", (Object)this.itemPath, (Object)this.domainPath);
            Gateway.getLookupManager().add(this.itemPath, transactionKey);
        }
    }

    @Override
    public Path create(AgentPath agentPath, boolean reset, TransactionKey transactionKey) throws InvalidDataException, ObjectCannotBeUpdated, ObjectNotFoundException, CannotManageException, ObjectAlreadyExistsException, InvalidCollectionModification, PersistencyException {
        this.setOrCreateItemPath(transactionKey);
        log.info("create() - path:{}", (Object)this.domainPath);
        if (this.domainPath.exists(transactionKey)) {
            ItemPath domIp = this.domainPath.getItemPath(transactionKey);
            if (!domIp.equals(this.itemPath)) {
                throw new CannotManageException("Item " + String.valueOf(this.domainPath) + " was found with the wrong itemPath (" + String.valueOf(domIp) + " vs " + String.valueOf(this.itemPath) + ")");
            }
        } else {
            this.isDOMPathExists = false;
        }
        try {
            CreateItemFromDescription.storeItem(agentPath, this.itemPath, this.createItemProperties(), this.createCollections(transactionKey), this.createCompositeActivity(transactionKey), null, null, transactionKey);
        }
        catch (Exception ex) {
            log.error("Error initialising new item:{}", (Object)this.domainPath, (Object)ex);
            if (this.isNewItem) {
                Gateway.getLookupManager().delete(this.itemPath, transactionKey);
            }
            throw new CannotManageException("Problem initialising new item:" + String.valueOf(this.domainPath) + ". See server log:" + ex.getMessage());
        }
        History hist = new History(this.itemPath, transactionKey);
        for (ImportOutcome thisOutcome : this.outcomes) {
            Viewpoint impView;
            String outcomeData = thisOutcome.getData(this.ns);
            Schema schema = LocalObjectLoader.getSchema(thisOutcome.schema, thisOutcome.version, transactionKey);
            Outcome newOutcome = new Outcome(-1, outcomeData, schema);
            newOutcome.validateAndCheck();
            try {
                impView = (Viewpoint)Gateway.getStorage().get(this.itemPath, String.valueOf((Object)ClusterType.VIEWPOINT) + "/" + thisOutcome.schema + "/" + thisOutcome.viewname, transactionKey);
                if (newOutcome.isIdentical(impView.getOutcome())) {
                    log.debug("create() - View " + thisOutcome.schema + "/" + thisOutcome.viewname + " in " + this.ns + "/" + this.name + " identical, no update required");
                    continue;
                }
                log.info("create() - Difference found in view " + thisOutcome.schema + "/" + thisOutcome.viewname + " in " + this.ns + "/" + this.name);
                if (!reset && !impView.getEvent().getStepPath().equals("Import")) {
                    log.info("create() - Last edit was not done by import, and reset not requested. Not overwriting.");
                    continue;
                }
            }
            catch (ObjectNotFoundException ex) {
                log.info("create() - View " + thisOutcome.schema + "/" + thisOutcome.viewname + " not found in " + this.ns + "/" + this.name + ". Creating.");
                impView = new Viewpoint(this.itemPath, schema, thisOutcome.viewname, -1);
            }
            Event newEvent = hist.addEvent(agentPath, BuiltInAuthc.ADMIN_ROLE.getName(), "Import", "Import", "Import", schema, LocalObjectLoader.getStateMachine("PredefinedStep", 0, transactionKey), 0, thisOutcome.viewname);
            newOutcome.setID(newEvent.getID());
            impView.setEventId(newEvent.getID());
            Gateway.getStorage().put(this.itemPath, newOutcome, transactionKey);
            Gateway.getStorage().put(this.itemPath, impView, transactionKey);
        }
        if (!this.isDOMPathExists) {
            this.domainPath.setItemPath(this.itemPath);
            Gateway.getLookupManager().add(this.domainPath, transactionKey);
        }
        return this.domainPath;
    }

    protected PropertyArrayList createItemProperties() {
        if (!this.properties.contains(BuiltInItemProperties.NAME.getName())) {
            this.properties.put(new Property(BuiltInItemProperties.NAME, this.name, true));
        }
        return this.properties;
    }

    protected CompositeActivity createCompositeActivity(TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        if (this.wf != null) {
            log.info("createCompositeActivity() - use Workflow instance");
            return (CompositeActivity)this.wf.search("workflow/domain");
        }
        if (this.compActDef == null) {
            if (StringUtils.isNotBlank((CharSequence)this.workflow)) {
                this.compActDef = LocalObjectLoader.getCompActDef(this.workflow, this.getWfVersion(), transactionKey);
            } else {
                log.warn("createCompositeActivity() - NO Workflow was set for domainPath:" + String.valueOf(this.domainPath));
                this.compActDef = LocalObjectLoader.getCompActDef("NoWorkflow", this.getWfVersion(), transactionKey);
            }
        }
        return (CompositeActivity)this.compActDef.instantiate(transactionKey);
    }

    protected CollectionArrayList createCollections(TransactionKey transactionKey) throws InvalidCollectionModification, ObjectNotFoundException, ObjectAlreadyExistsException {
        CollectionArrayList colls = new CollectionArrayList();
        for (ImportDependency importDependency : this.dependencyList) {
            Dependency newDep = importDependency.create(transactionKey);
            colls.put(newDep);
        }
        for (ImportAggregation importAggregation : this.aggregationList) {
            Aggregation newAgg = importAggregation.create(transactionKey);
            colls.put(newAgg);
        }
        log.info("createCollections() - name:{} number of colls:{}", (Object)this.name, (Object)colls.list.size());
        return colls;
    }

    @Override
    public String getItemID() {
        return this.getID();
    }

    @Override
    public CollectionArrayList makeDescCollections(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        return new CollectionArrayList();
    }

    @Override
    public BuiltInResources getResourceType() {
        return BuiltInResources.ITEM_DESC_RESOURCE;
    }

    public String toString() {
        return "ImportItem(name:" + this.name + " version:" + this.version + " status:" + String.valueOf((Object)this.resourceChangeStatus) + ")";
    }

    public ArrayList<Property> getProperties() {
        return this.properties.list;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public String getInitialPath() {
        return this.initialPath;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public Integer getWorkflowVer() {
        return this.workflowVer;
    }

    public ArrayList<ImportAggregation> getAggregationList() {
        return this.aggregationList;
    }

    public ArrayList<ImportDependency> getDependencyList() {
        return this.dependencyList;
    }

    public ArrayList<ImportOutcome> getOutcomes() {
        return this.outcomes;
    }

    public CompositeActivityDef getCompActDef() {
        return this.compActDef;
    }

    public Workflow getWf() {
        return this.wf;
    }

    @Override
    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setInitialPath(String initialPath) {
        this.initialPath = initialPath;
    }

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }

    public void setWorkflowVer(Integer workflowVer) {
        this.workflowVer = workflowVer;
    }

    public void setProperties(PropertyArrayList properties) {
        this.properties = properties;
    }

    public void setAggregationList(ArrayList<ImportAggregation> aggregationList) {
        this.aggregationList = aggregationList;
    }

    public void setDependencyList(ArrayList<ImportDependency> dependencyList) {
        this.dependencyList = dependencyList;
    }

    public void setOutcomes(ArrayList<ImportOutcome> outcomes) {
        this.outcomes = outcomes;
    }

    public void setCompActDef(CompositeActivityDef compActDef) {
        this.compActDef = compActDef;
    }

    public void setWf(Workflow wf) {
        this.wf = wf;
    }
}

