/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleImport;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.DescriptionObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportRole
extends ModuleImport
implements DescriptionObject {
    private static final Logger log = LoggerFactory.getLogger(ImportRole.class);
    public Integer version;
    public Boolean jobList = null;
    public ArrayList<String> permissions = new ArrayList();

    public ImportRole() {
    }

    public ImportRole(String n) {
        this.name = n;
    }

    public RolePath getRolePath() {
        return new RolePath(this.name.split("/"), this.jobList == null ? false : this.jobList, this.permissions);
    }

    @Override
    public boolean exists(TransactionKey transactionKey) {
        return this.getRolePath().exists(transactionKey);
    }

    @Override
    public Path create(AgentPath agentPath, boolean reset, TransactionKey transactionKey) throws ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, ObjectNotFoundException {
        RolePath newRolePath = this.getRolePath();
        if (newRolePath.exists(transactionKey)) {
            if (this.jobList != null) {
                this.update(agentPath, transactionKey);
            }
        } else {
            log.info("create() - Creating Role:" + this.name + " joblist:" + this.jobList);
            newRolePath.getParent(transactionKey);
            Gateway.getLookupManager().createRole(newRolePath, transactionKey);
            Gateway.getLookupManager().setPermissions(newRolePath, newRolePath.getPermissionsList(), transactionKey);
        }
        return newRolePath;
    }

    public void update(AgentPath agentPath, TransactionKey transactionKey) throws ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, ObjectNotFoundException {
        log.info("update() - Updating Role:" + this.name + " joblist:" + this.jobList);
        RolePath rolePath = this.getRolePath();
        if (!rolePath.exists(transactionKey)) {
            throw new ObjectNotFoundException("Role '" + rolePath.getName() + "' does NOT exists.");
        }
        Gateway.getLookupManager().setHasJobList(rolePath, this.jobList == null ? false : this.jobList, transactionKey);
        Gateway.getLookupManager().setPermissions(rolePath, rolePath.getPermissionsList(), transactionKey);
    }

    public static ImportRole getImportRole(RolePath rp) {
        ImportRole ir = new ImportRole();
        ir.setName(rp.getName());
        ir.jobList = rp.hasJobList();
        ir.permissions = new ArrayList<String>(rp.getPermissionsList());
        return ir;
    }

    @Override
    public ItemPath getItemPath(TransactionKey transactionKey) {
        return this.getItemPath();
    }

    @Override
    public String getItemID() {
        return this.getID();
    }

    @Override
    public CollectionArrayList makeDescCollections(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        return new CollectionArrayList();
    }

    @Override
    public BuiltInResources getResourceType() {
        return BuiltInResources.ROLE_DESC_RESOURCE;
    }

    public String toString() {
        return "ImportRole(name:" + this.name + " version:" + this.version + " status:" + String.valueOf((Object)this.resourceChangeStatus) + ")";
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public Boolean getJobList() {
        return this.jobList;
    }

    public ArrayList<String> getPermissions() {
        return this.permissions;
    }

    @Override
    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setJobList(Boolean jobList) {
        this.jobList = jobList;
    }

    public void setPermissions(ArrayList<String> permissions) {
        this.permissions = permissions;
    }
}

