/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import com.google.errorprone.annotations.Immutable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cristalise.kernel.common.CriseVertxException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.ChangeName;
import org.cristalise.kernel.lifecycle.instance.predefined.Erase;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.predefined.RemoveC2KObject;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.SetAgentPassword;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.Sign;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.scripting.Parameter;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptErrorException;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class AgentProxy
extends ItemProxy {
    private static final Logger log = LoggerFactory.getLogger(AgentProxy.class);
    String mAgentName;

    protected AgentProxy(AgentPath agentPath) throws ObjectNotFoundException {
        super(agentPath);
    }

    protected AgentProxy(AgentPath agentPath, TransactionKey transKey) {
        super(agentPath, transKey);
    }

    public String execute(Job job, Job errorJob) throws CriseVertxException {
        if (errorJob == null) {
            throw new InvalidDataException("errorJob cannot be null");
        }
        try {
            return this.execute(job);
        }
        catch (Exception ex) {
            log.trace("execute(errorJob)", (Throwable)ex);
            errorJob.setAgentPath(this.getPath());
            errorJob.setOutcome(Gateway.getMarshaller().marshall(new ErrorInfo(job, ex)));
            return this.execute(errorJob);
        }
    }

    /*
     * Unable to fully structure code
     */
    public String execute(Job job) throws CriseVertxException {
        item = Gateway.getProxy(job.getItemPath(), this.transactionKey);
        startTime = new Date();
        AgentProxy.log.info("execute(job) - {}", (Object)job);
        if (job.hasScript()) {
            try {
                scriptErrors = this.callScript(item, job);
                errorString = scriptErrors.toString();
                if (scriptErrors.getFatal()) {
                    AgentProxy.log.error("execute(job) - fatal script errors:{}", (Object)scriptErrors);
                    throw new ScriptErrorException(scriptErrors);
                }
                if (errorString.length() <= 0) ** GOTO lbl24
                AgentProxy.log.warn("Script errors: {}", (Object)errorString);
            }
            catch (ScriptingEngineException ex) {
                cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof CriseVertxException) {
                        throw (CriseVertxException)cause;
                    }
                    throw new ScriptErrorException(cause);
                }
                throw new ScriptErrorException(ex);
            }
        } else if (job.hasQuery() && !"Query".equals(job.getActProp(BuiltInVertexProperties.OUTCOME_INIT))) {
            AgentProxy.log.debug("execute(job) - executing query (OutcomeInit != Query)");
            job.setOutcome(item.executeQuery(job.getQuery()));
        }
lbl24:
        // 5 sources

        if (job.hasOutcome() && job.isOutcomeSet()) {
            job.getOutcome().validateAndCheck();
        }
        job.setAgentPath(this.getPath());
        if (job.hasOutcome() && ((Boolean)job.getActProp(BuiltInVertexProperties.SIMPLE_ELECTRONIC_SIGNATURE, (Object)false)).booleanValue()) {
            AgentProxy.log.info("execute(job) - executing SimpleElectonicSignature predefStep");
            xml = Sign.getSimpleElectonicSignature(job);
            if (xml != null) {
                this.execute((ItemProxy)this, (Class<?>)Sign.class, xml);
            }
        }
        AgentProxy.log.debug("execute(job) - submitting job to item proxy");
        result = item.requestAction(job);
        if (AgentProxy.log.isDebugEnabled()) {
            timeNow = new Date();
            secsNow = (timeNow.getTime() - startTime.getTime()) / 1000L;
            AgentProxy.log.debug("execute(job) - execution DONE in {} seconds", (Object)secsNow);
        }
        return result;
    }

    private ErrorInfo callScript(ItemProxy item, Job job) throws ScriptingEngineException, InvalidDataException, ObjectNotFoundException {
        Script script = job.getScript();
        log.debug("callScript() - executing {}", (Object)script);
        CastorHashMap params = new CastorHashMap();
        params.put("item", item);
        params.put("agent", this);
        params.put("job", job);
        Object returnVal = script.evaluate(item.getPath(), params, job.getStepPath(), true, null);
        if (returnVal instanceof Map) {
            return (ErrorInfo)((Map)returnVal).get(this.getErrorInfoParameterName(script));
        }
        if (returnVal instanceof ErrorInfo) {
            return (ErrorInfo)returnVal;
        }
        throw new InvalidDataException("Script " + script.getName() + " return value must be of org.cristalise.kernel.scripting.ErrorInfo");
    }

    private String getErrorInfoParameterName(Script script) throws InvalidDataException {
        Parameter p = script.getOutputParams().size() == 1 ? script.getOutputParams().values().iterator().next() : script.getOutputParams().get("errors");
        if (p.getType() != ErrorInfo.class) {
            throw new InvalidDataException("Script " + script.getName() + " must have at least one output of org.cristalise.kernel.scripting.ErrorInfo");
        }
        return p.getName();
    }

    public String execute(ItemProxy item, Class<?> predefStep, C2KLocalObject obj) throws CriseVertxException {
        return this.execute(item, predefStep.getSimpleName(), obj);
    }

    public String execute(ItemProxy item, String predefStep, C2KLocalObject obj) throws CriseVertxException {
        String param;
        try {
            param = this.marshall(obj);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            throw new InvalidDataException("Error on marshall");
        }
        return this.execute(item, predefStep, param);
    }

    public String execute(ItemProxy item, Class<?> predefStep, String ... params) throws CriseVertxException {
        return this.execute(item, predefStep.getSimpleName(), params);
    }

    public String execute(ItemProxy item, String predefStep, String ... params) throws CriseVertxException {
        String schemaName = PredefinedStep.getPredefStepSchemaName(predefStep);
        String param = null;
        if (schemaName.equals("PredefinedStepOutcome")) {
            param = PredefinedStep.bundleData(params);
        } else if (params.length == 0) {
            param = "";
        } else if (params.length == 1) {
            param = params[0];
        } else {
            throw new InvalidDataException("predefStep:'" + predefStep + "' schemaName:'" + schemaName + "' incorrect params:" + Arrays.toString(params));
        }
        log.info("execute(predefStep) - item:{} step:{}", (Object)item, (Object)predefStep);
        String result = this.requestAction(item.getPath().toString(), this.getPath().toString(), "workflow/predefined/" + predefStep, 0, param, "", new ArrayList<Byte>());
        String[] clearCacheSteps = new String[]{ChangeName.class.getSimpleName(), Erase.class.getSimpleName(), SetAgentPassword.class.getSimpleName(), RemoveC2KObject.class.getSimpleName()};
        if (Arrays.asList(clearCacheSteps).contains(predefStep)) {
            Gateway.getStorage().clearCache(item.getPath());
        }
        return result;
    }

    public String execute(ItemProxy item, Class<?> predefStep) throws CriseVertxException {
        return this.execute(item, predefStep.getSimpleName());
    }

    public String execute(ItemProxy item, String predefStep) throws CriseVertxException {
        return this.execute(item, predefStep, new String[0]);
    }

    public String execute(ItemProxy item, Class<?> predefStep, String param) throws CriseVertxException {
        return this.execute(item, predefStep.getSimpleName(), param);
    }

    public String execute(ItemProxy item, String predefStep, String param) throws CriseVertxException {
        return this.execute(item, predefStep, new String[]{param});
    }

    public ItemProxy searchItem(String name) throws ObjectNotFoundException {
        return this.searchItem(new DomainPath(""), name);
    }

    public ItemProxy searchItem(Path root, String name) throws ObjectNotFoundException {
        Iterator<Path> results = Gateway.getLookup().search(root, name);
        Path returnPath = null;
        if (!results.hasNext()) {
            throw new ObjectNotFoundException(name);
        }
        while (results.hasNext()) {
            Path nextMatch = results.next();
            if (returnPath != null) {
                if (!this.isItemPathAndNotNull(nextMatch)) continue;
                if (!returnPath.getItemPath().getUUID().equals(nextMatch.getItemPath().getUUID())) {
                    throw new ObjectNotFoundException("Too many different items with name:" + name);
                }
                returnPath = nextMatch;
                continue;
            }
            if (!this.isItemPathAndNotNull(nextMatch)) continue;
            returnPath = nextMatch;
            log.debug("searchItem() - found for " + name + " UUID = " + String.valueOf(returnPath.getItemPath().getUUID()));
        }
        if (returnPath == null) {
            throw new ObjectNotFoundException(name);
        }
        return Gateway.getProxy(returnPath, this.transactionKey);
    }

    private boolean isItemPathAndNotNull(Path pPath) {
        boolean ok = false;
        try {
            ok = pPath.getItemPath() != null;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return ok;
    }

    public List<ItemProxy> searchItems(Path start, PropertyDescriptionList props) {
        Iterator<Path> results = Gateway.getLookup().search(start, props);
        return this.createItemProxyList(results);
    }

    public List<ItemProxy> searchItems(Path start, Property[] props) {
        Iterator<Path> results = Gateway.getLookup().search(start, props);
        return this.createItemProxyList(results);
    }

    private List<ItemProxy> createItemProxyList(Iterator<Path> results) {
        ArrayList<ItemProxy> returnList = new ArrayList<ItemProxy>();
        while (results.hasNext()) {
            Path nextMatch = results.next();
            try {
                returnList.add(Gateway.getProxy(nextMatch, this.transactionKey));
            }
            catch (ObjectNotFoundException e) {
                log.error("Path '" + String.valueOf(nextMatch) + "' did not resolve to an Item");
            }
        }
        return returnList;
    }

    public ItemProxy getItem(String itemPath) throws ObjectNotFoundException {
        return this.getItem(new DomainPath(itemPath));
    }

    @Override
    public AgentPath getPath() {
        return (AgentPath)this.mItemPath;
    }

    public ItemProxy getItem(Path itemPath) throws ObjectNotFoundException {
        return Gateway.getProxy(itemPath, this.transactionKey);
    }

    public ItemProxy getItemByUUID(String uuid) throws ObjectNotFoundException, InvalidItemPathException {
        return Gateway.getProxy(new ItemPath(uuid), this.transactionKey);
    }

    public RolePath[] getRoles() {
        return Gateway.getLookup().getRoles(this.getPath(), this.transactionKey);
    }
}

