/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import com.google.errorprone.annotations.Immutable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.CriseVertxException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.Item;
import org.cristalise.kernel.entity.ItemVerticle;
import org.cristalise.kernel.entity.ItemVertxEBProxy;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.WriteProperty;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.C2KLocalObjectMap;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.OutcomeAttachment;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.security.SecurityManager;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class ItemProxy {
    private static final Logger log = LoggerFactory.getLogger(ItemProxy.class);
    protected Item mItem = null;
    protected ItemPath mItemPath;
    protected TransactionKey transactionKey = null;

    protected ItemProxy(ItemPath itemPath) {
        this(itemPath, null);
    }

    protected ItemProxy(ItemPath itemPath, TransactionKey transKey) {
        this.mItemPath = itemPath;
        this.transactionKey = transKey;
    }

    public Item getItem() {
        if (this.mItem == null) {
            this.mItem = new ItemVertxEBProxy(Gateway.getVertx(), ItemVerticle.ebAddress);
        }
        return this.mItem;
    }

    public ItemPath getPath() {
        return this.mItemPath;
    }

    public String getUuid() {
        return this.mItemPath.getName();
    }

    public void setProperty(AgentProxy agent, String name, String value) throws AccessRightsException, PersistencyException, InvalidDataException {
        try {
            String[] params = new String[]{name, value};
            agent.execute(this, WriteProperty.class.getSimpleName(), params);
        }
        catch (AccessRightsException | InvalidDataException | PersistencyException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Could not store property {}", (Object)name, (Object)e);
            throw new PersistencyException("Could not store property:" + e.getMessage());
        }
    }

    public String requestAction(String itemUuid, String agentUuid, String stepPath, int transitionID, String requestData, String fileName, List<Byte> attachment) throws CriseVertxException {
        log.debug("requestAction() - item:{} agent:{} stepPath:{}", new Object[]{this, agentUuid, stepPath});
        try {
            Future<String> future = this.getItem().requestAction(itemUuid, agentUuid, stepPath, transitionID, requestData, fileName, attachment);
            return this.await(future);
        }
        catch (ExecutionException e) {
            log.error("requestAction() - item:{} agent:{}", new Object[]{this, agentUuid, e});
            throw CriseVertxException.convertFutureException(e);
        }
        catch (CriseVertxException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("requestAction() - item:{} agent:{} stepPath:{}", new Object[]{this, agentUuid, stepPath, e});
            throw new CannotManageException("Error while waiting for the requestAction() return value item:" + itemUuid + " agent:" + agentUuid, (Throwable)e);
        }
    }

    private <T> T await(Future<T> future) throws Exception {
        if (Context.isOnVertxThread()) {
            return (T)Future.await(future);
        }
        CompletableFuture futureResult = new CompletableFuture();
        future.onSuccess(futureResult::complete).onFailure(futureResult::completeExceptionally);
        return futureResult.get(ItemVerticle.requestTimeout, TimeUnit.SECONDS);
    }

    public String requestAction(Job thisJob) throws CriseVertxException {
        if (thisJob.getAgentPath() == null) {
            throw new InvalidDataException("No Agent specified.");
        }
        if (!thisJob.getItemPath().equals(this.getPath())) {
            throw new InvalidDataException("Job:" + String.valueOf(thisJob) + " is not for this Item:" + String.valueOf(this));
        }
        String outcome = thisJob.getOutcomeString();
        if (outcome == null) {
            if (thisJob.isOutcomeRequired()) {
                throw new InvalidDataException("Outcome is required.");
            }
            outcome = "";
        }
        OutcomeAttachment attachment = thisJob.getAttachment();
        String attachmentFileName = "";
        byte[] attachmentBinary = new byte[]{};
        if (attachment != null) {
            attachmentFileName = attachment.getFileName();
            attachmentBinary = attachment.getBinaryData();
        }
        log.debug("requestAction() - executing job:{}", (Object)thisJob);
        return this.requestAction(this.mItemPath.toString(), thisJob.getAgentPath().toString(), thisJob.getStepPath(), thisJob.getTransition().getId(), outcome, attachmentFileName, Arrays.asList(ArrayUtils.toObject((byte[])attachmentBinary)));
    }

    public List<Job> getJobs(AgentPath agentPath) throws CriseVertxException {
        return this.getJobsForAgent(agentPath);
    }

    public boolean checkJobForAgent(Job job, AgentPath agentPath) throws CriseVertxException {
        String stepPath = job.getStepPath();
        Activity act = (Activity)this.getWorkflow().search(stepPath);
        SecurityManager secMan = Gateway.getSecurityManager();
        return secMan.checkPermissions(agentPath, act, this.getPath(), null);
    }

    private List<Job> getJobsForAgent(AgentPath agentPath) throws CriseVertxException {
        ArrayList<Job> jobBag = new ArrayList<Job>();
        Gateway.getStorage().clearCache(this.getPath(), ClusterType.JOB);
        Gateway.getStorage().clearCache(this.getPath(), ClusterType.LIFECYCLE);
        for (Job j : this.getJobs().values()) {
            if (!this.checkJobForAgent(j, agentPath)) continue;
            jobBag.add(j);
        }
        log.debug("getJobsForAgent() - {} returning #{} jobs for agent:{}", new Object[]{this, jobBag.size(), agentPath.getAgentName()});
        return jobBag;
    }

    public List<Job> getJobs(AgentProxy agent) throws CriseVertxException {
        return this.getJobsForAgent(agent.getPath());
    }

    public List<Job> getJobs(AgentPath agent, String stepPath) throws CriseVertxException {
        ArrayList<Job> resultJobs = new ArrayList<Job>();
        for (Job job : this.getJobsForAgent(agent)) {
            if (!job.getStepPath().equals(stepPath)) continue;
            resultJobs.add(job);
        }
        return resultJobs;
    }

    private Job getJobByName(String actName, AgentPath agent) throws CriseVertxException {
        C2KLocalObjectMap<Job> jobMap = this.getJobs();
        for (String key : jobMap.keySet()) {
            Job job;
            String stepName = key.split("/")[0];
            if (!stepName.equals(actName) || !(job = (Job)jobMap.get(key)).getTransition().isFinishing() || !this.checkJobForAgent(job, agent)) continue;
            return job;
        }
        return null;
    }

    public boolean checkCollection(BuiltInCollections collection) throws ObjectNotFoundException {
        return this.checkCollection(collection, this.transactionKey);
    }

    public boolean checkCollection(BuiltInCollections collection, TransactionKey transKey) throws ObjectNotFoundException {
        return this.checkCollection(collection.getName(), transKey);
    }

    public boolean checkCollection(String collection) throws ObjectNotFoundException {
        return this.checkCollection(collection, this.transactionKey);
    }

    public boolean checkCollection(String collection, TransactionKey transKey) throws ObjectNotFoundException {
        return this.checkContent(ClusterType.COLLECTION, collection, transKey == null ? this.transactionKey : transKey);
    }

    public Collection<?> getCollection(BuiltInCollections collection) throws ObjectNotFoundException {
        return this.getCollection(collection, (Integer)null);
    }

    public Collection<?> getCollection(BuiltInCollections collection, TransactionKey transKey) throws ObjectNotFoundException {
        return this.getCollection(collection, (Integer)null, transKey == null ? this.transactionKey : transKey);
    }

    public Collection<?> getCollection(BuiltInCollections collection, Integer version) throws ObjectNotFoundException {
        return this.getCollection(collection, version, this.transactionKey);
    }

    public Collection<?> getCollection(BuiltInCollections collection, Integer version, TransactionKey transKey) throws ObjectNotFoundException {
        return this.getCollection(collection.getName(), version, transKey == null ? this.transactionKey : transKey);
    }

    public Collection<?> getCollection(String collName) throws ObjectNotFoundException {
        return this.getCollection(collName, (Integer)null, this.transactionKey);
    }

    public Collection<?> getCollection(String collName, TransactionKey transKey) throws ObjectNotFoundException {
        return this.getCollection(collName, (Integer)null, transKey == null ? this.transactionKey : transKey);
    }

    public Collection<?> getCollection(String collName, Integer version) throws ObjectNotFoundException {
        return this.getCollection(collName, version, this.transactionKey);
    }

    public Collection<?> getCollection(String collName, Integer version, TransactionKey transKey) throws ObjectNotFoundException {
        String verStr = version == null ? "last" : String.valueOf(version);
        return (Collection)this.getObject(String.valueOf((Object)ClusterType.COLLECTION) + "/" + collName + "/" + verStr, transKey == null ? this.transactionKey : transKey);
    }

    public Workflow getWorkflow() throws ObjectNotFoundException {
        return this.getWorkflow(null);
    }

    public Workflow getWorkflow(TransactionKey transKey) throws ObjectNotFoundException {
        return (Workflow)this.getObject(String.valueOf((Object)ClusterType.LIFECYCLE) + "/workflow", transKey == null ? this.transactionKey : transKey);
    }

    public boolean checkViewpoint(String schemaName, String viewName) throws ObjectNotFoundException {
        return this.checkContent(String.valueOf((Object)ClusterType.VIEWPOINT) + "/" + schemaName, viewName);
    }

    public boolean checkViewpoint(String schemaName, String viewName, TransactionKey transKey) throws ObjectNotFoundException {
        return this.checkContent(String.valueOf((Object)ClusterType.VIEWPOINT) + "/" + schemaName, viewName, transKey == null ? this.transactionKey : transKey);
    }

    public String[] getViewpoints(String schemaName) throws ObjectNotFoundException {
        return this.getContents(String.valueOf((Object)ClusterType.VIEWPOINT) + "/" + schemaName);
    }

    public String[] getViewpoints(String schemaName, TransactionKey transKey) throws ObjectNotFoundException {
        return this.getContents(String.valueOf((Object)ClusterType.VIEWPOINT) + "/" + schemaName, transKey == null ? this.transactionKey : transKey);
    }

    public Viewpoint getViewpoint(String schemaName, String viewName) throws ObjectNotFoundException {
        return (Viewpoint)this.getObject(String.valueOf((Object)ClusterType.VIEWPOINT) + "/" + schemaName + "/" + viewName);
    }

    public Viewpoint getViewpoint(String schemaName, String viewName, TransactionKey transKey) throws ObjectNotFoundException {
        return (Viewpoint)this.getObject(String.valueOf((Object)ClusterType.VIEWPOINT) + "/" + schemaName + "/" + viewName, transKey == null ? this.transactionKey : transKey);
    }

    public boolean checkOutcome(String schemaName, int schemaVersion, int eventId) throws ObjectNotFoundException {
        return this.checkOutcome(schemaName, schemaVersion, eventId, this.transactionKey);
    }

    public boolean checkOutcome(String schemaName, int schemaVersion, int eventId, TransactionKey transKey) throws ObjectNotFoundException {
        try {
            TransactionKey tk = transKey == null ? this.transactionKey : transKey;
            return this.checkOutcome(LocalObjectLoader.getSchema(schemaName, schemaVersion, tk), eventId, tk);
        }
        catch (InvalidDataException e) {
            log.error("Schema was not found:{}", (Object)schemaName, (Object)e);
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    public boolean checkOutcome(Schema schema, int eventId) throws ObjectNotFoundException {
        return this.checkOutcome(schema, eventId, this.transactionKey);
    }

    public boolean checkOutcome(Schema schema, int eventId, TransactionKey transKey) throws ObjectNotFoundException {
        return this.checkContent(String.valueOf((Object)ClusterType.OUTCOME) + "/" + schema.getName() + "/" + schema.getVersion(), String.valueOf(eventId), transKey == null ? this.transactionKey : transKey);
    }

    public Outcome getOutcome(String schemaName, int schemaVersion, int eventId) throws ObjectNotFoundException {
        return this.getOutcome(schemaName, schemaVersion, eventId, this.transactionKey);
    }

    public Outcome getOutcome(String schemaName, int schemaVersion, int eventId, TransactionKey transKey) throws ObjectNotFoundException {
        try {
            TransactionKey tk = transKey == null ? this.transactionKey : transKey;
            return this.getOutcome(LocalObjectLoader.getSchema(schemaName, schemaVersion, tk), eventId, tk);
        }
        catch (InvalidDataException e) {
            log.error("Schema was not found:{}", (Object)schemaName, (Object)e);
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    public Outcome getOutcome(Schema schema, int eventId) throws ObjectNotFoundException {
        return this.getOutcome(schema, eventId, this.transactionKey);
    }

    public Outcome getOutcome(Schema schema, int eventId, TransactionKey transKey) throws ObjectNotFoundException {
        return (Outcome)this.getObject(String.valueOf((Object)ClusterType.OUTCOME) + "/" + schema.getName() + "/" + schema.getVersion() + "/" + eventId, transKey == null ? this.transactionKey : transKey);
    }

    public Outcome getOutcome(Viewpoint view) throws ObjectNotFoundException {
        return this.getOutcome(view, this.transactionKey);
    }

    public Outcome getOutcome(Viewpoint view, TransactionKey transKey) throws ObjectNotFoundException {
        try {
            return view.getOutcome(transKey == null ? this.transactionKey : transKey);
        }
        catch (PersistencyException e) {
            log.error("Could not retrieve outcome for view:{}", (Object)view, (Object)e);
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    public Outcome getOutcome(Event event) throws ObjectNotFoundException {
        return this.getOutcome(event, this.transactionKey);
    }

    public Outcome getOutcome(Event event, TransactionKey transKey) throws ObjectNotFoundException {
        return this.getOutcome(event.getSchemaName(), event.getSchemaVersion(), event.getID(), transKey);
    }

    public boolean checkOutcomeAttachment(Schema schema, int eventId) throws ObjectNotFoundException {
        return this.checkOutcomeAttachment(schema, eventId, this.transactionKey);
    }

    public boolean checkOutcomeAttachment(Schema schema, int eventId, TransactionKey transKey) throws ObjectNotFoundException {
        return this.checkContent(String.valueOf((Object)ClusterType.ATTACHMENT) + "/" + schema.getName() + "/" + schema.getVersion(), String.valueOf(eventId), transKey == null ? this.transactionKey : transKey);
    }

    public OutcomeAttachment getOutcomeAttachment(String schemaName, int schemaVersion, int eventId) throws ObjectNotFoundException {
        return this.getOutcomeAttachment(schemaName, schemaVersion, eventId, this.transactionKey);
    }

    public OutcomeAttachment getOutcomeAttachment(String schemaName, int schemaVersion, int eventId, TransactionKey transKey) throws ObjectNotFoundException {
        try {
            TransactionKey tk = transKey == null ? this.transactionKey : transKey;
            return this.getOutcomeAttachment(LocalObjectLoader.getSchema(schemaName, schemaVersion, tk), eventId, tk);
        }
        catch (InvalidDataException e) {
            log.error("Could not retrieve attachment for schema:{}", (Object)schemaName, (Object)e);
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    public OutcomeAttachment getOutcomeAttachment(Schema schema, int eventId) throws ObjectNotFoundException {
        return this.getOutcomeAttachment(schema, eventId, this.transactionKey);
    }

    public OutcomeAttachment getOutcomeAttachment(Schema schema, int eventId, TransactionKey transKey) throws ObjectNotFoundException {
        return (OutcomeAttachment)this.getObject(String.valueOf((Object)ClusterType.ATTACHMENT) + "/" + schema.getName() + "/" + schema.getVersion() + "/" + eventId, transKey == null ? this.transactionKey : transKey);
    }

    public Job getJobByName(String actName, AgentProxy agent) throws CriseVertxException {
        return this.getJobByName(actName, agent.getPath());
    }

    public Job getJobByTransitionName(String actName, String transName, AgentProxy agent) throws CriseVertxException {
        return this.getJobByTransitionName(actName, transName, agent.getPath());
    }

    public Job getJobByTransitionName(String actName, String transName, AgentPath agentPath) throws CriseVertxException {
        for (Job job : this.getJobsForAgent(agentPath)) {
            if (!job.getTransition().getName().equals(transName) || (!actName.contains("/") || !job.getStepPath().equals(actName)) && !job.getStepName().equals(actName)) continue;
            return job;
        }
        return null;
    }

    public String queryData(String path) throws ObjectNotFoundException {
        return this.queryData(path, this.transactionKey);
    }

    public String queryData(String path, TransactionKey transKey) throws ObjectNotFoundException {
        log.debug("queryData() - {}/{}", (Object)this.mItemPath, (Object)path);
        try {
            if (path.endsWith("all")) {
                log.trace("queryData() - listing contents");
                String[] result = Gateway.getStorage().getClusterContents(this.mItemPath, path.substring(0, path.length() - 3), transKey == null ? this.transactionKey : transKey);
                StringBuffer retString = new StringBuffer();
                for (int i = 0; i < result.length; ++i) {
                    retString.append(result[i]);
                    if (i >= result.length - 1) continue;
                    retString.append(",");
                }
                log.trace("queryData() - retString:{}", (Object)retString);
                return retString.toString();
            }
            C2KLocalObject target = Gateway.getStorage().get(this.mItemPath, path, transKey == null ? this.transactionKey : transKey);
            return Gateway.getMarshaller().marshall(target);
        }
        catch (ObjectNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            log.error("queryData() - could not read data for path:{}/{}", new Object[]{this.mItemPath, path, e});
            return "<ERROR>" + e.getMessage() + "</ERROR>";
        }
    }

    public boolean checkContent(String path, String name) throws ObjectNotFoundException {
        return this.checkContent(path, name, this.transactionKey);
    }

    public boolean checkContent(ClusterType cluster, String name) throws ObjectNotFoundException {
        return this.checkContent(cluster.getName(), name, this.transactionKey);
    }

    public boolean checkContent(ClusterType cluster, String name, TransactionKey transKey) throws ObjectNotFoundException {
        return this.checkContent(cluster.getName(), name, transKey);
    }

    public boolean checkContent(String path, String name, TransactionKey transKey) throws ObjectNotFoundException {
        String[] contents;
        for (String key : contents = this.getContents(path, transKey == null ? this.transactionKey : transKey)) {
            if (!key.equals(name)) continue;
            return true;
        }
        return false;
    }

    public String[] getContents(ClusterType type) throws ObjectNotFoundException {
        return this.getContents(type.getName());
    }

    public String[] getContents(ClusterType type, TransactionKey transKey) throws ObjectNotFoundException {
        return this.getContents(type.getName(), transKey == null ? this.transactionKey : transKey);
    }

    public String[] getContents(String path) throws ObjectNotFoundException {
        return this.getContents(path, this.transactionKey);
    }

    public String[] getContents(String path, TransactionKey transKey) throws ObjectNotFoundException {
        try {
            return Gateway.getStorage().getClusterContents(this.mItemPath, path, transKey == null ? this.transactionKey : transKey);
        }
        catch (PersistencyException e) {
            throw new ObjectNotFoundException(e.toString());
        }
    }

    public String executeQuery(Query query) throws PersistencyException {
        return Gateway.getStorage().executeQuery(query);
    }

    public C2KLocalObject getObject(ClusterType type) throws ObjectNotFoundException {
        return this.getObject(type.getName(), this.transactionKey);
    }

    public C2KLocalObject getObject(ClusterType type, TransactionKey transKey) throws ObjectNotFoundException {
        C2KLocalObjectMap c2kObjMap = (C2KLocalObjectMap)this.getObject(type.getName(), transKey);
        c2kObjMap.setTransactionKey(transKey);
        return c2kObjMap;
    }

    public C2KLocalObject getObject(String path) throws ObjectNotFoundException {
        return this.getObject(path, this.transactionKey);
    }

    public C2KLocalObject getObject(String path, TransactionKey transKey) throws ObjectNotFoundException {
        try {
            return Gateway.getStorage().get(this.mItemPath, path, transKey == null ? this.transactionKey : transKey);
        }
        catch (PersistencyException ex) {
            log.error("getObject() - Exception loading object:{}/{}", new Object[]{this.mItemPath, path, ex});
            throw new ObjectNotFoundException(ex.toString());
        }
    }

    public String getProperty(BuiltInItemProperties prop) throws ObjectNotFoundException {
        return this.getProperty(prop.getName());
    }

    public String getProperty(BuiltInItemProperties prop, String defaultValue) {
        return this.getProperty(prop, defaultValue, this.transactionKey);
    }

    public String getProperty(BuiltInItemProperties prop, String defaultValue, TransactionKey transKey) {
        return this.getProperty(prop.getName(), defaultValue, transKey);
    }

    public String getProperty(String name, String defaultValue) {
        return this.getProperty(name, defaultValue, this.transactionKey);
    }

    public String getProperty(String name, String defaultValue, TransactionKey transKey) {
        try {
            if (this.checkProperty(name, transKey)) {
                return this.getProperty(name, transKey);
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return defaultValue;
    }

    public String getProperty(String name) throws ObjectNotFoundException {
        return this.getProperty(name, (TransactionKey)null);
    }

    public String getProperty(String name, TransactionKey transKey) throws ObjectNotFoundException {
        Property prop = (Property)this.getObject(String.valueOf((Object)ClusterType.PROPERTY) + "/" + name, transKey == null ? this.transactionKey : transKey);
        if (prop != null) {
            return prop.getValue();
        }
        throw new ObjectNotFoundException("COULD not find property " + name + " from item " + String.valueOf(this.mItemPath));
    }

    public boolean checkProperty(BuiltInItemProperties prop) throws ObjectNotFoundException {
        return this.checkProperty(prop, this.transactionKey);
    }

    public boolean checkProperty(BuiltInItemProperties prop, TransactionKey transKey) throws ObjectNotFoundException {
        return this.checkProperty(prop.getName(), transKey == null ? this.transactionKey : transKey);
    }

    public boolean checkProperty(String name) throws ObjectNotFoundException {
        return this.checkContent(ClusterType.PROPERTY.getName(), name);
    }

    public boolean checkProperty(String name, TransactionKey transKey) throws ObjectNotFoundException {
        return this.checkContent(ClusterType.PROPERTY.getName(), name, transKey == null ? this.transactionKey : transKey);
    }

    public String getName() {
        return this.getName(this.transactionKey);
    }

    public String getName(TransactionKey transKey) {
        return this.getProperty(BuiltInItemProperties.NAME, (String)null, transKey == null ? this.transactionKey : transKey);
    }

    public String getType() {
        return this.getType(this.transactionKey);
    }

    public String getType(TransactionKey transKey) {
        return this.getProperty(BuiltInItemProperties.TYPE, (String)null, transKey);
    }

    public Event getEvent(int eventId) throws ObjectNotFoundException {
        return this.getEvent(eventId, this.transactionKey);
    }

    public Event getEvent(int eventId, TransactionKey transKey) throws ObjectNotFoundException {
        return (Event)this.getObject(String.valueOf((Object)ClusterType.HISTORY) + "/" + eventId, transKey == null ? this.transactionKey : transKey);
    }

    public History getHistory() throws ObjectNotFoundException {
        return this.getHistory(null);
    }

    public History getHistory(TransactionKey transKey) throws ObjectNotFoundException {
        return (History)this.getObject(ClusterType.HISTORY, transKey == null ? this.transactionKey : transKey);
    }

    public Job getJob(String id) throws ObjectNotFoundException {
        return this.getJob(id, null);
    }

    public Job getJob(String id, TransactionKey transKey) throws ObjectNotFoundException {
        return (Job)this.getObject(String.valueOf((Object)ClusterType.JOB) + "/" + id, transKey == null ? this.transactionKey : transKey);
    }

    public C2KLocalObjectMap<Job> getJobs() {
        return this.getJobs((TransactionKey)null);
    }

    public C2KLocalObjectMap<Job> getJobs(TransactionKey transKey) {
        try {
            return (C2KLocalObjectMap)this.getObject(ClusterType.JOB, transKey == null ? this.transactionKey : transKey);
        }
        catch (ObjectNotFoundException e) {
            return new C2KLocalObjectMap<Job>(this.mItemPath, ClusterType.JOB, this.transactionKey);
        }
    }

    public Schema getMasterSchema() throws InvalidDataException, ObjectNotFoundException {
        return this.getMasterSchema(null, null);
    }

    public Schema getMasterSchema(String schemaName, Integer schemaVersion) throws InvalidDataException, ObjectNotFoundException {
        String masterSchemaUrn = this.getProperty(BuiltInItemProperties.MASTER_SCHEMA_URN, null);
        if (StringUtils.isBlank((CharSequence)masterSchemaUrn)) {
            masterSchemaUrn = this.getProperty(BuiltInItemProperties.SCHEMA_URN, null);
        }
        if (StringUtils.isBlank((CharSequence)schemaName)) {
            schemaName = StringUtils.isNotBlank((CharSequence)masterSchemaUrn) ? masterSchemaUrn.split(":")[0] : this.getType();
        }
        if (schemaVersion == null) {
            if (StringUtils.isBlank((CharSequence)masterSchemaUrn)) {
                if (SystemProperties.Module_Versioning_strict.getBoolean().booleanValue()) {
                    throw new InvalidDataException("Version for Schema '" + schemaName + "' cannot be null");
                }
                log.warn("getMasterSchema() - Version for Schema '{}' was null, using version 0 as default", (Object)schemaName);
                schemaVersion = 0;
            } else {
                schemaVersion = Integer.valueOf(masterSchemaUrn.split(":")[1]);
            }
        }
        return LocalObjectLoader.getSchema(schemaName, schemaVersion, this.transactionKey);
    }

    public Schema getUpdateSchema() throws ObjectNotFoundException, InvalidDataException {
        String schemaName = null;
        Integer schemaVersion = null;
        if (this.checkCollection(BuiltInCollections.SCHEMA_INITIALISE)) {
            Collection<?> initSchemaCollection = this.getCollection(BuiltInCollections.SCHEMA_INITIALISE);
            DependencyMember member = (DependencyMember)initSchemaCollection.getMembers().list.get(0);
            schemaName = member.getChildUUID();
            Object initSchemaVersion = member.getProperties().getBuiltInProperty(BuiltInVertexProperties.VERSION);
            schemaVersion = initSchemaVersion instanceof String ? Integer.valueOf(Integer.parseInt((String)initSchemaVersion)) : (Integer)initSchemaVersion;
        } else {
            String[] nameAndVersion = this.getProperty(BuiltInItemProperties.UPDATE_SCHEMA).split(":");
            schemaName = nameAndVersion[0];
            schemaVersion = Integer.parseInt(nameAndVersion[1]);
        }
        return LocalObjectLoader.getSchema(schemaName, schemaVersion);
    }

    public Script getAggregateScript() throws InvalidDataException, ObjectNotFoundException {
        return this.getAggregateScript(null, null);
    }

    public Script getAggregateScript(String scriptName, Integer scriptVersion) throws InvalidDataException, ObjectNotFoundException {
        String aggregateScriptUrn = this.getProperty(BuiltInItemProperties.AGGREGATE_SCRIPT_URN, null);
        if (StringUtils.isBlank((CharSequence)aggregateScriptUrn)) {
            aggregateScriptUrn = this.getProperty(BuiltInItemProperties.SCRIPT_URN, null);
        }
        if (StringUtils.isBlank((CharSequence)scriptName)) {
            scriptName = StringUtils.isBlank((CharSequence)aggregateScriptUrn) ? this.getType() + "_Aggregate" : aggregateScriptUrn.split(":")[0];
        }
        if (scriptVersion == null) {
            if (StringUtils.isBlank((CharSequence)aggregateScriptUrn)) {
                if (SystemProperties.Module_Versioning_strict.getBoolean().booleanValue()) {
                    throw new InvalidDataException("Version for Script '" + (String)scriptName + "' cannot be null");
                }
                log.warn("getAggregateScript() - Version for Script '{}' was null, using version 0 as default", scriptName);
                scriptVersion = 0;
            } else {
                scriptVersion = Integer.valueOf(aggregateScriptUrn.split(":")[1]);
            }
        }
        return LocalObjectLoader.getScript((String)scriptName, scriptVersion, this.transactionKey);
    }

    public String marshall(Object obj) throws Exception {
        return Gateway.getMarshaller().marshall(obj);
    }

    public Object unmarshall(String obj) throws Exception {
        return Gateway.getMarshaller().unmarshall(obj);
    }

    public void clearCache() {
        Gateway.getStorage().clearCache(this.mItemPath);
    }

    public String toString() {
        if (log.isTraceEnabled()) {
            return this.getName() + "(" + String.valueOf(this.getPath().getUUID()) + "/" + this.getType() + ")";
        }
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemProxy)) {
            return false;
        }
        ItemProxy other = (ItemProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ItemPath this$mItemPath = this.mItemPath;
        ItemPath other$mItemPath = other.mItemPath;
        return !(this$mItemPath == null ? other$mItemPath != null : !((Object)this$mItemPath).equals(other$mItemPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemProxy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ItemPath $mItemPath = this.mItemPath;
        result = result * 59 + ($mItemPath == null ? 43 : ((Object)$mItemPath).hashCode());
        return result;
    }

    public TransactionKey getTransactionKey() {
        return this.transactionKey;
    }
}

