/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyManager {
    private static final Logger log = LoggerFactory.getLogger(ProxyManager.class);

    private static ItemProxy createProxy(ItemPath itemPath, TransactionKey transactionKey) throws ObjectNotFoundException {
        log.trace("createProxy() - Item:{}", (Object)itemPath);
        if (itemPath instanceof AgentPath) {
            return new AgentProxy((AgentPath)itemPath, transactionKey);
        }
        return new ItemProxy(itemPath, transactionKey);
    }

    public static ItemProxy getProxy(Path path) throws ObjectNotFoundException {
        return ProxyManager.getProxy(path, null);
    }

    public static ItemProxy getProxy(Path path, TransactionKey transactionKey) throws ObjectNotFoundException {
        ItemPath itemPath = null;
        log.trace("getProxy() - path:{}", (Object)path);
        if (path instanceof ItemPath) {
            try {
                itemPath = Gateway.getLookup().getItemPath(((ItemPath)path).getName(), transactionKey);
            }
            catch (InvalidItemPathException e) {
                throw new ObjectNotFoundException(e);
            }
        } else if (path instanceof DomainPath) {
            ((DomainPath)path).setTargetUUID(null);
            itemPath = path.getItemPath(transactionKey);
        }
        if (itemPath == null) {
            throw new ObjectNotFoundException("Cannot use RolePath");
        }
        return ProxyManager.createProxy(itemPath, transactionKey);
    }

    public static AgentProxy getAgentProxy(String agentName) throws ObjectNotFoundException {
        return ProxyManager.getAgentProxy(agentName, null);
    }

    public static AgentProxy getAgentProxy(String agentName, TransactionKey transactionKey) throws ObjectNotFoundException {
        AgentPath path = Gateway.getLookup().getAgentPath(agentName, transactionKey);
        return (AgentProxy)ProxyManager.getProxy(path, transactionKey);
    }

    public static AgentProxy getAgentProxy(AgentPath path) throws ObjectNotFoundException {
        return ProxyManager.getAgentProxy(path, null);
    }

    public static AgentProxy getAgentProxy(AgentPath path, TransactionKey transactionKey) throws ObjectNotFoundException {
        return (AgentProxy)ProxyManager.getProxy(path, transactionKey);
    }
}

