/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;

public class ProxyMessage {
    public static final String ebAddress = "cristalise-proxyMessage";
    public static final String ebLocalAddress = "cristalise-localProxyMessage";
    private ItemPath itemPath = null;
    private String path = "";
    private Type messageType = Type.ADD;
    private boolean clusterStoreMesssage = true;

    public ProxyMessage() {
    }

    public ProxyMessage(ItemPath itemPath, String path, Type type) {
        this();
        this.setItemPath(itemPath);
        this.setPath(path);
        this.setMessageType(type);
    }

    public ProxyMessage(String message) throws InvalidDataException {
        if (StringUtils.isBlank((CharSequence)message)) {
            throw new InvalidDataException("Blank proxy message");
        }
        Object[] msgSections = message.split(":", 2);
        if (msgSections.length != 2) {
            throw new InvalidDataException("Invalid proxy message (use ':' as separator):'" + Arrays.toString(msgSections) + "'");
        }
        if (StringUtils.isNotBlank((CharSequence)msgSections[0])) {
            if (((String)msgSections[0]).equals("tree")) {
                this.clusterStoreMesssage = false;
            } else {
                try {
                    this.itemPath = new ItemPath((String)msgSections[0]);
                }
                catch (InvalidItemPathException e) {
                    throw new InvalidDataException("Invalid UUID in proxy message:'" + Arrays.toString(msgSections) + "'", (Throwable)e);
                }
            }
        }
        if (((String)msgSections[1]).startsWith("-")) {
            this.messageType = Type.DELETE;
            this.path = ((String)msgSections[1]).substring(1);
        } else {
            this.path = msgSections[1];
        }
    }

    public ClusterType getClusterType() {
        if (this.clusterStoreMesssage) {
            int slashIdx = this.path.indexOf(47);
            if (slashIdx != -1) {
                return ClusterType.getValue(this.path.substring(0, slashIdx));
            }
            return ClusterType.ROOT;
        }
        return null;
    }

    public String getObjectKey() {
        if (this.clusterStoreMesssage) {
            int slashIdx = this.path.indexOf(47);
            if (slashIdx != -1) {
                return this.path.substring(slashIdx + 1);
            }
            return this.path;
        }
        return this.path;
    }

    public String getLocalEventBusAddress() {
        if (this.clusterStoreMesssage) {
            return this.itemPath.getName() + "/" + String.valueOf((Object)this.getClusterType());
        }
        return "tree";
    }

    public String getLocalEventBusMessage() {
        return this.getObjectKey() + ":" + String.valueOf((Object)this.messageType);
    }

    public String toString() {
        return String.valueOf(this.itemPath == null ? "tree" : this.itemPath.getUUID()) + ":" + (this.messageType == Type.DELETE ? "-" : "") + this.path;
    }

    public ItemPath getItemPath() {
        return this.itemPath;
    }

    public String getPath() {
        return this.path;
    }

    public Type getMessageType() {
        return this.messageType;
    }

    public boolean isClusterStoreMesssage() {
        return this.clusterStoreMesssage;
    }

    public void setItemPath(ItemPath itemPath) {
        this.itemPath = itemPath;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMessageType(Type messageType) {
        this.messageType = messageType;
    }

    public void setClusterStoreMesssage(boolean clusterStoreMesssage) {
        this.clusterStoreMesssage = clusterStoreMesssage;
    }

    public static enum Type {
        ADD,
        DELETE;

    }
}

