/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameHelper;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameParser;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.entity.ItemVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpBridgeClientVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(TcpBridgeClientVerticle.class);
    NetSocket socket;

    public void start(Promise<Void> startPromise) throws Exception {
        NetClient tcpClient = Vertx.vertx().createNetClient();
        String host = SystemProperties.TcpBridge_host.getString();
        int port = SystemProperties.TcpBridge_port.getInteger();
        tcpClient.connect(port, host, result -> {
            if (result.succeeded()) {
                this.socket = (NetSocket)result.result();
                this.vertx.eventBus().consumer(ItemVerticle.ebAddress, message -> {
                    JsonObject body = (JsonObject)message.body();
                    String action = message.headers().get("action");
                    log.debug("handler() - action:{} body:{}", (Object)action, (Object)body);
                    JsonObject header = new JsonObject();
                    header.put("action", (Object)action);
                    FrameHelper.sendFrame((String)"send", (String)ItemVerticle.ebAddress, (String)ItemVerticle.ebAddress, (JsonObject)header, (Boolean)true, (Object)body, (WriteStream)this.socket);
                    this.socket.handler((Handler)new FrameParser(bufferResult -> {
                        if (bufferResult.succeeded()) {
                            JsonObject resultJson = (JsonObject)bufferResult.result();
                            log.trace("handler() - returnJson:{}", (Object)resultJson);
                            if (resultJson.getString("type").equals("err")) {
                                message.fail(500, resultJson.toString());
                            } else if (resultJson.getString("type").equals("pong")) {
                                log.warn("handler() - received 'pong' returnJson:{}", (Object)this, (Object)resultJson);
                                message.reply((Object)"pong");
                            } else {
                                log.debug("handler() - returning:{}", (Object)resultJson.getString("body"));
                                message.reply((Object)resultJson.getString("body"));
                            }
                        } else {
                            message.fail(500, bufferResult.cause().getMessage());
                        }
                    }));
                });
                startPromise.complete();
                log.info("start() - connected to {}:{}", (Object)host, (Object)port);
            } else {
                startPromise.fail(result.cause());
                log.error("start() - failed connection to {}:{}", new Object[]{host, port, result.cause()});
            }
        });
    }

    public void stop() throws Exception {
        String host = SystemProperties.TcpBridge_host.getString();
        int port = SystemProperties.TcpBridge_port.getInteger();
        log.info("stop() - closing connection to {}:{}", (Object)host, (Object)port);
        this.socket.close();
    }
}

