/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.events;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.C2KLocalObjectMap;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class History
extends C2KLocalObjectMap<Event> {
    private static final Logger log = LoggerFactory.getLogger(History.class);

    public History(ItemPath itemPath) {
        super(itemPath, ClusterType.HISTORY);
    }

    public History(ItemPath itemPath, TransactionKey transactionKey) {
        super(itemPath, ClusterType.HISTORY, transactionKey);
    }

    public Event getEvent(int id) {
        return (Event)this.get(String.valueOf(id));
    }

    public Event get(Integer id) {
        return (Event)this.get((Object)id);
    }

    @Override
    public Event remove(Object key) {
        throw new UnsupportedOperationException("Event cannot be removed");
    }

    private synchronized Event storeNewEvent(Event newEvent) {
        newEvent.setID(this.getLastId() + 1);
        this.put(newEvent.getName(), newEvent);
        return newEvent;
    }

    public Event addEvent(AgentPath agentPath, String agentRole, String stepName, String stepPath, String stepType, StateMachine stateMachine, int transitionId) {
        return this.storeNewEvent(new Event(this.itemPath, agentPath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId));
    }

    public Event addEvent(AgentPath agentPath, String agentRole, String stepName, String stepPath, String stepType, Schema schema, StateMachine stateMachine, int transitionId, String viewName) {
        Event newEvent = new Event(this.itemPath, agentPath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId);
        newEvent.addOutcomeDetails(schema, viewName);
        return this.storeNewEvent(newEvent);
    }

    public Event addEvent(AgentPath agentPath, String agentRole, String stepName, String stepPath, String stepType, Schema schema, StateMachine stateMachine, int transitionId, String viewName, boolean hasAttachment) {
        Event newEvent = new Event(this.itemPath, agentPath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId, hasAttachment);
        newEvent.addOutcomeDetails(schema, viewName);
        return this.storeNewEvent(newEvent);
    }

    public Event addEvent(AgentPath agentPath, String agentRole, String stepName, String stepPath, String stepType, StateMachine stateMachine, int transitionId, String timeString) throws InvalidDataException {
        Event newEvent = new Event(this.itemPath, agentPath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId);
        newEvent.setTimeString(timeString);
        return this.storeNewEvent(newEvent);
    }

    public Event addEvent(AgentPath agentPath, String agentRole, String stepName, String stepPath, String stepType, Schema schema, StateMachine stateMachine, int transitionId, String viewName, String timeString) throws InvalidDataException {
        Event newEvent = new Event(this.itemPath, agentPath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId);
        newEvent.addOutcomeDetails(schema, viewName);
        newEvent.setTimeString(timeString);
        return this.storeNewEvent(newEvent);
    }

    @Override
    protected Set<String> loadKeys(String path) throws PersistencyException {
        HashSet<String> keys = new HashSet<String>();
        for (int i = 0; i <= this.getLastId(); ++i) {
            keys.add(String.valueOf(i));
        }
        return keys;
    }

    public Map<Integer, Event> list(int start, int batchSize, Boolean descending) {
        LinkedHashMap<Integer, Event> batch = new LinkedHashMap<Integer, Event>();
        int last = this.getLastId();
        if (descending.booleanValue()) {
            for (int i = last - start; i >= 0 && batch.size() < batchSize; --i) {
                batch.put(i, this.getEvent(i));
            }
        } else {
            Integer i = start;
            while (i <= last && batch.size() < batchSize) {
                batch.put(i, this.getEvent(i));
                Integer n = i;
                i = i + 1;
            }
        }
        return batch;
    }

    @Override
    public Set<Map.Entry<String, Event>> entrySet() {
        throw new UnsupportedOperationException("Cannot retrieve full content of History:" + String.valueOf(this.itemPath));
    }

    @Override
    public Collection<Event> values() {
        throw new UnsupportedOperationException("Cannot retrieve full content of History:" + String.valueOf(this.itemPath));
    }

    @Override
    public int size() {
        return this.getLastId() + 1;
    }

    public boolean containsKey(Integer id) {
        return this.containsKey((Object)id);
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            int id = key instanceof String ? Integer.valueOf((String)key).intValue() : ((Integer)key).intValue();
            return id >= 0 && id <= this.getLastId();
        }
        catch (Exception ex) {
            log.error("containsKey() - cannot convert key:{}", key, (Object)ex);
            return false;
        }
    }
}

