/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.graph.layout;

import java.util.Vector;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.JoinDef;
import org.cristalise.kernel.lifecycle.LoopDef;
import org.cristalise.kernel.lifecycle.instance.Join;
import org.cristalise.kernel.lifecycle.instance.Loop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphLayoutGenerator {
    private static final Logger log = LoggerFactory.getLogger(DefaultGraphLayoutGenerator.class);
    private static int mTopMargin = 50;
    private static int mLeftMargin = 100;
    private static int mHorzGap = 180;
    private static int mVertGap = 80;

    private DefaultGraphLayoutGenerator() {
    }

    public static void layoutGraph(GraphModel graphModel) {
        Vertex start = graphModel.getStartVertex();
        Vector<Vector<Vertex>> rowVector = new Vector<Vector<Vertex>>(10, 10);
        int[] midPoints = null;
        int valueOfLargestMidPoint = 0;
        if (start == null) {
            log.warn("Error graph must have a starting vertex to be layed out");
            return;
        }
        graphModel.clearTags(start);
        DefaultGraphLayoutGenerator.visitVertex(graphModel, start, 0, rowVector, start);
        midPoints = new int[rowVector.size()];
        valueOfLargestMidPoint = DefaultGraphLayoutGenerator.calculateRowMidPoints(rowVector, midPoints, valueOfLargestMidPoint);
        DefaultGraphLayoutGenerator.fillInVertexLocations(graphModel, rowVector, valueOfLargestMidPoint, midPoints);
        DefaultGraphLayoutGenerator.fillInEdgeLocations(graphModel);
        graphModel.forceNotify();
    }

    private static void visitVertex(GraphModel graphModel, Vertex vertex, int rowIndex, Vector<Vector<Vertex>> rowVector, Object tag) {
        int i = 0;
        Vertex[] children = graphModel.getOutVertices(vertex);
        vertex.setTag(tag);
        DefaultGraphLayoutGenerator.addVertexToRow(vertex, rowIndex, rowVector);
        for (i = 0; i < children.length; ++i) {
            if (children[i].hasTag(tag)) continue;
            DefaultGraphLayoutGenerator.visitVertex(graphModel, children[i], rowIndex + 1, rowVector, tag);
        }
    }

    private static void addVertexToRow(Vertex vertex, int rowIndex, Vector<Vector<Vertex>> rowVector) {
        Vector<Vertex> rowsVertices = null;
        if (rowVector.size() == rowIndex) {
            rowVector.add(new Vector(10, 10));
        }
        rowsVertices = rowVector.elementAt(rowIndex);
        rowsVertices.add(vertex);
    }

    private static int calculateRowMidPoints(Vector<Vector<Vertex>> rowVector, int[] midPoints, int valueOfLargestMidPoint) {
        Vector<Vertex> rowsVertices = null;
        int newValueOfLargestMidPoint = valueOfLargestMidPoint;
        int rowsWidth = 0;
        int i = 0;
        for (i = 0; i < midPoints.length; ++i) {
            rowsVertices = rowVector.elementAt(i);
            rowsWidth = mHorzGap * (rowsVertices.size() - 1);
            midPoints[i] = rowsWidth / 2;
            if (midPoints[i] <= newValueOfLargestMidPoint) continue;
            newValueOfLargestMidPoint = midPoints[i];
        }
        return newValueOfLargestMidPoint;
    }

    private static void fillInVertexLocations(GraphModel graphModel, Vector<Vector<Vertex>> rowVector, int valueOfLargestMidPoint, int[] midPoints) {
        Vector<Vertex> rowsVertices = null;
        int rowsLeftMargin = 0;
        GraphPoint point = new GraphPoint(0, 0);
        for (int rowIndex = 0; rowIndex < rowVector.size(); ++rowIndex) {
            rowsVertices = rowVector.elementAt(rowIndex);
            rowsLeftMargin = mLeftMargin + valueOfLargestMidPoint - midPoints[rowIndex];
            for (int column = 0; column < rowsVertices.size(); ++column) {
                GraphableVertex currentVertex = (GraphableVertex)rowsVertices.elementAt(column);
                point.x = rowsLeftMargin + column * mHorzGap;
                point.y = mTopMargin + rowIndex * mVertGap;
                if (currentVertex instanceof Loop || currentVertex instanceof LoopDef) {
                    point.x += mVertGap;
                } else if (currentVertex instanceof Join || currentVertex instanceof JoinDef) {
                    for (Vertex inVertex : currentVertex.getInGraphables()) {
                        Boolean isMyPair = currentVertex.isMyPair((GraphableVertex)inVertex);
                        if (isMyPair == null || !isMyPair.booleanValue()) continue;
                        point.x += mVertGap;
                    }
                }
                currentVertex.moveAbsolute(point);
                graphModel.checkSize(currentVertex);
            }
        }
    }

    private static void fillInEdgeLocations(GraphModel graphModel) {
        Vertex[] vertices = graphModel.getVertices();
        GraphPoint centrePoint = null;
        DirectedEdge[] inEdges = null;
        DirectedEdge[] outEdges = null;
        int i = 0;
        int j = 0;
        for (i = 0; i < vertices.length; ++i) {
            centrePoint = vertices[i].getCentrePoint();
            inEdges = graphModel.getInEdges(vertices[i]);
            outEdges = graphModel.getOutEdges(vertices[i]);
            for (j = 0; j < inEdges.length; ++j) {
                inEdges[j].setTerminusPoint(centrePoint);
            }
            for (j = 0; j < outEdges.length; ++j) {
                outEdges[j].setOriginPoint(centrePoint);
            }
        }
    }
}

