/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.graph.model;

import org.cristalise.kernel.graph.model.BuiltInEdgeProperties;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.renderer.DefaultDirectedEdgeRenderer;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;

public abstract class GraphableEdge
extends DirectedEdge {
    private GraphableVertex mParent;
    private CastorHashMap mProperties = new CastorHashMap();

    public GraphableEdge() {
    }

    public GraphableEdge(GraphableVertex pre, GraphableVertex nex) {
        this.setParent(pre.getParent());
        pre.getParent().getChildrenGraphModel().addEdgeAndCreateId((DirectedEdge)this, pre, nex);
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.mProperties.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.mProperties.setKeyValuePairs(pairs);
    }

    public Object getBuiltInProperty(BuiltInEdgeProperties prop) {
        return this.mProperties.getBuiltInProperty(prop);
    }

    public Object getBuiltInProperty(BuiltInEdgeProperties prop, Object defaultValue) {
        return this.mProperties.getBuiltInProperty(prop, defaultValue);
    }

    public void setBuiltInProperty(BuiltInEdgeProperties prop, Object val) {
        this.mProperties.put(prop.getName(), val);
    }

    @Override
    public boolean containsPoint(GraphPoint p) {
        GraphPoint originPoint = this.getOriginPoint();
        GraphPoint terminusPoint = this.getTerminusPoint();
        GraphPoint midPoint = new GraphPoint();
        DefaultDirectedEdgeRenderer.EdgeRouting type = DefaultDirectedEdgeRenderer.EdgeRouting.getValue(this.getBuiltInProperty(BuiltInEdgeProperties.TYPE, "").toString());
        switch (type) {
            case BROKEN_PLUS: {
                midPoint.x = (originPoint.x + terminusPoint.x) / 2;
                midPoint.y = (originPoint.y + terminusPoint.y) / 2;
                break;
            }
            case BROKEN_MINUS: {
                boolean arrowOnY = originPoint.y - terminusPoint.y >= 60 || originPoint.y - terminusPoint.y <= -60;
                midPoint.x = arrowOnY ? terminusPoint.x : (originPoint.x + terminusPoint.x) / 2;
                midPoint.y = arrowOnY ? (originPoint.y + terminusPoint.y) / 2 : originPoint.y;
                break;
            }
            case BROKEN_PIPE: {
                boolean arrowOnY = originPoint.y - terminusPoint.y >= 60 || originPoint.y - terminusPoint.y <= -60;
                midPoint.x = arrowOnY ? originPoint.x : (originPoint.x + terminusPoint.x) / 2;
                midPoint.y = arrowOnY ? (originPoint.y + terminusPoint.y) / 2 : terminusPoint.y;
                break;
            }
            default: {
                midPoint.x = originPoint.x + (terminusPoint.x - originPoint.x) / 2;
                midPoint.y = originPoint.y + (terminusPoint.y - originPoint.y) / 2;
            }
        }
        int minX = midPoint.x - 10;
        int minY = midPoint.y - 10;
        int maxX = midPoint.x + 10;
        int maxY = midPoint.y + 10;
        return p.x >= minX && p.x <= maxX && p.y >= minY && p.y <= maxY;
    }

    public GraphableVertex getParent() {
        return this.mParent;
    }

    public CastorHashMap getProperties() {
        return this.mProperties;
    }

    public void setParent(GraphableVertex mParent) {
        this.mParent = mParent;
    }

    public void setProperties(CastorHashMap mProperties) {
        this.mProperties = mProperties;
    }
}

