/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.TypeNameAndConstructionInfo;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lifecycle.ActivitySlotDef;
import org.cristalise.kernel.lifecycle.AndSplitDef;
import org.cristalise.kernel.lifecycle.JoinDef;
import org.cristalise.kernel.lifecycle.LifecycleVertexOutlineCreator;
import org.cristalise.kernel.lifecycle.LoopDef;
import org.cristalise.kernel.lifecycle.NextDef;
import org.cristalise.kernel.lifecycle.OrSplitDef;
import org.cristalise.kernel.lifecycle.WfVertexDef;
import org.cristalise.kernel.lifecycle.XOrSplitDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompositeActivityDef
extends ActivityDef {
    private static final Logger log = LoggerFactory.getLogger(CompositeActivityDef.class);
    private List<ActivityDef> refChildActDef = new ArrayList<ActivityDef>();
    private final TypeNameAndConstructionInfo[] mVertexTypeNameAndConstructionInfo = new TypeNameAndConstructionInfo[]{new TypeNameAndConstructionInfo("Activity", "Atomic"), new TypeNameAndConstructionInfo("Local Activity", "AtomicLocal"), new TypeNameAndConstructionInfo("Composite", "Composite"), new TypeNameAndConstructionInfo("Sub-workflow", "CompositeLocal"), new TypeNameAndConstructionInfo("AND Split", "And"), new TypeNameAndConstructionInfo("OR Split", "Or"), new TypeNameAndConstructionInfo("XOR Split", "XOr"), new TypeNameAndConstructionInfo("Join", "Join"), new TypeNameAndConstructionInfo("Loop", "Loop")};
    private final TypeNameAndConstructionInfo[] mEdgeTypeNameAndConstructionInfo = new TypeNameAndConstructionInfo[]{new TypeNameAndConstructionInfo("Next Edge", "Next")};

    public CompositeActivityDef() {
        this.setBuiltInProperty(BuiltInVertexProperties.ABORTABLE, false);
        this.setBuiltInProperty(BuiltInVertexProperties.REPEAT_WHEN, false);
        this.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_NAME, StateMachine.getDefaultStateMachine("Composite"));
        try {
            this.setChildrenGraphModel(new GraphModel(new LifecycleVertexOutlineCreator()));
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        this.setIsComposite(true);
    }

    public CompositeActivityDef(String n, Integer v) {
        this();
        this.setName(n);
        this.setVersion(v);
    }

    public List<ActivityDef> getRefChildActDef() {
        return this.refChildActDef;
    }

    public void setRefChildActDef(List<ActivityDef> refChildActDef) {
        this.refChildActDef = refChildActDef;
    }

    public TypeNameAndConstructionInfo[] getVertexTypeNameAndConstructionInfo() {
        return this.mVertexTypeNameAndConstructionInfo;
    }

    public TypeNameAndConstructionInfo[] getEdgeTypeNameAndConstructionInfo() {
        return this.mEdgeTypeNameAndConstructionInfo;
    }

    public NextDef addNextDef(WfVertexDef origin, WfVertexDef terminus) {
        NextDef returnNxt = new NextDef(origin, terminus);
        this.getChildrenGraphModel().addEdgeAndCreateId((DirectedEdge)returnNxt, origin, terminus);
        return returnNxt;
    }

    public ActivitySlotDef addExistingActivityDef(String name, ActivityDef actDef, GraphPoint point) throws InvalidDataException {
        this.changed = true;
        boolean newActDef = true;
        for (ActivityDef existingActDef : this.refChildActDef) {
            if (!existingActDef.getName().equals(actDef.getName())) continue;
            if (existingActDef.getVersion().equals(actDef.getVersion())) {
                actDef = existingActDef;
                newActDef = false;
                break;
            }
            throw new InvalidDataException("Cannot use same activity def with different version in the same composite activity");
        }
        if (newActDef) {
            this.refChildActDef.add(actDef);
        }
        ActivitySlotDef child = new ActivitySlotDef(name, actDef);
        this.addChild(child, point);
        return child;
    }

    public ActivityDef addLocalActivityDef(String name, String type, GraphPoint point) {
        this.changed = true;
        ActivityDef child = type.startsWith("Composite") ? new CompositeActivityDef() : new ActivityDef();
        child.setName(name);
        child.setIsLayoutable(true);
        this.addChild(child, point);
        return child;
    }

    @Deprecated
    public WfVertexDef newChild(String Name, String Type2, Integer version, GraphPoint location) throws ObjectNotFoundException, InvalidDataException {
        List<String> splits = Arrays.asList("Or", "XOr", "And", "Loop");
        if (splits.contains(Type2)) {
            Type2 = (String)Type2 + "Split";
        }
        return this.newChild(Name, WfVertex.Types.valueOf((String)Type2), version, location);
    }

    public WfVertexDef newChild(String name, WfVertex.Types type, Integer version, GraphPoint location) throws ObjectNotFoundException, InvalidDataException {
        this.changed = true;
        boolean wasAdded = false;
        WfVertexDef child = null;
        switch (type) {
            case OrSplit: {
                child = new OrSplitDef();
                break;
            }
            case XOrSplit: {
                child = new XOrSplitDef();
                break;
            }
            case AndSplit: {
                child = new AndSplitDef();
                break;
            }
            case LoopSplit: {
                child = new LoopDef();
                break;
            }
            case Join: 
            case Route: {
                child = new JoinDef();
                child.getProperties().put("Type", type.toString());
                break;
            }
            case Atomic: {
                ActivityDef eaDef = LocalObjectLoader.getElemActDef(name, version);
                child = this.addExistingActivityDef(eaDef.getActName(), eaDef, location);
                wasAdded = true;
                break;
            }
            case Composite: {
                CompositeActivityDef caDef = LocalObjectLoader.getCompActDef(name, version);
                child = this.addExistingActivityDef(caDef.getActName(), caDef, location);
                wasAdded = true;
                break;
            }
            case LocalAtomic: 
            case LocalComposite: {
                child = this.addLocalActivityDef(name, type.toString(), location);
                wasAdded = true;
                break;
            }
            default: {
                throw new InvalidDataException("Unknown child type '" + String.valueOf((Object)type) + "' for name:'" + name + "'");
            }
        }
        if (!wasAdded) {
            this.addChild(child, location);
        }
        log.debug("newChild() - Type:" + String.valueOf((Object)type) + " ID:" + child.getID() + " added to ID:" + this.getID());
        return child;
    }

    @Override
    public WfVertex instantiate(TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        return this.instantiate(this.getName(), transactionKey);
    }

    @Override
    public WfVertex instantiate(String name, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        CompositeActivity caInstance = new CompositeActivity();
        log.info("instantiate(name:" + name + ") - Starting.");
        caInstance.setName(name);
        this.configureInstance(caInstance, transactionKey);
        if (this.getItemPath() != null) {
            caInstance.setType(this.getItemID());
        }
        caInstance.getChildrenGraphModel().setStartVertexId(this.getChildrenGraphModel().getStartVertexId());
        caInstance.getChildrenGraphModel().setVertices(this.intantiateVertices(caInstance, transactionKey));
        caInstance.getChildrenGraphModel().setEdges(this.instantiateEdges(caInstance));
        caInstance.getChildrenGraphModel().setNextId(this.getChildrenGraphModel().getNextId());
        caInstance.getChildrenGraphModel().resetVertexOutlines();
        this.propagateCollectionProperties(caInstance);
        return caInstance;
    }

    private void propagateCollectionProperties(CompositeActivity caInstance) throws InvalidDataException {
        CastorHashMap caProps = caInstance.getProperties();
        ArrayList<String> keysToDelete = new ArrayList<String>();
        for (Map.Entry aCAProp : caProps.entrySet()) {
            if (!(aCAProp.getValue() instanceof CastorHashMap)) continue;
            for (Vertex vertex : caInstance.getChildrenGraphModel().getVertices()) {
                CastorHashMap propsToPropagate = (CastorHashMap)aCAProp.getValue();
                BuiltInVertexProperties builtInProp = BuiltInVertexProperties.getValue((String)aCAProp.getKey());
                if (builtInProp == null) {
                    ((GraphableVertex)vertex).updatePropertiesFromCollection(Integer.parseInt((String)aCAProp.getKey()), propsToPropagate);
                    continue;
                }
                ((GraphableVertex)vertex).updatePropertiesFromCollection(builtInProp, propsToPropagate);
            }
            keysToDelete.add((String)aCAProp.getKey());
        }
        for (String key : keysToDelete) {
            caProps.remove(key);
        }
    }

    public Next[] instantiateEdges(CompositeActivity ca) {
        Next[] nexts = new Next[this.getChildrenGraphModel().getEdges().length];
        for (int i = 0; i < this.getChildrenGraphModel().getEdges().length; ++i) {
            NextDef nextDef = (NextDef)this.getChildrenGraphModel().getEdges()[i];
            nexts[i] = nextDef.instantiate();
            nexts[i].setParent(ca);
        }
        return nexts;
    }

    public WfVertex[] intantiateVertices(CompositeActivity ca, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        GraphableVertex[] vertexDefs = this.getLayoutableChildren();
        WfVertex[] wfVertices = new WfVertex[vertexDefs.length];
        for (int i = 0; i < vertexDefs.length; ++i) {
            WfVertexDef vertDef = (WfVertexDef)vertexDefs[i];
            wfVertices[i] = vertDef.instantiate(transactionKey);
            wfVertices[i].setParent(ca);
        }
        return wfVertices;
    }

    @Override
    public CollectionArrayList makeDescCollections(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        CollectionArrayList retArr = super.makeDescCollections(transactionKey);
        retArr.put(this.makeActDefCollection(transactionKey));
        return retArr;
    }

    public Dependency makeActDefCollection(TransactionKey transactionKey) throws InvalidDataException {
        return this.makeDescCollection(BuiltInCollections.ACTIVITY, transactionKey, this.refChildActDef.toArray(new ActivityDef[this.refChildActDef.size()]));
    }

    public List<ActivityDef> findRefActDefs(GraphModel graph, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        LinkedHashMap<String, ActivityDef> graphActDefs = new LinkedHashMap<String, ActivityDef>();
        for (Vertex elem : graph.getVertices()) {
            if (!(elem instanceof ActivitySlotDef)) continue;
            ActivitySlotDef actSlotDef = (ActivitySlotDef)elem;
            actSlotDef.setTheActivityDef(null);
            ActivityDef actDef = actSlotDef.getTheActivityDef(transactionKey);
            if (graphActDefs.containsKey(actDef.getActName())) continue;
            graphActDefs.put(actDef.getActName(), actDef);
        }
        return new ArrayList<ActivityDef>(graphActDefs.values());
    }

    public boolean hasGoodNumberOfActivity() {
        int endingAct = 0;
        GraphableVertex[] graphableVertices = this.getLayoutableChildren();
        if (graphableVertices != null) {
            for (GraphableVertex graphableVertice : graphableVertices) {
                WfVertexDef vertex = (WfVertexDef)graphableVertice;
                if (this.getChildrenGraphModel().getOutEdges(vertex).length != 0) continue;
                ++endingAct;
            }
        }
        return endingAct <= true;
    }

    @Override
    public String getPath() {
        if (this.getParent() == null) {
            return this.getName();
        }
        return super.getPath();
    }

    @Override
    public void setChildrenGraphModel(GraphModel childrenGraph) throws InvalidDataException {
        this.setChildrenGraphModel(childrenGraph, null);
    }

    public void setChildrenGraphModel(GraphModel childrenGraph, TransactionKey transactionKey) throws InvalidDataException {
        super.setChildrenGraphModel(childrenGraph);
        childrenGraph.setVertexOutlineCreator(new LifecycleVertexOutlineCreator());
        try {
            this.setRefChildActDef(this.findRefActDefs(childrenGraph, transactionKey));
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidDataException(e.getMessage());
        }
    }

    @Deprecated
    public String[] getCastorNonLayoutableChildren() {
        return new String[0];
    }

    @Deprecated
    public void setCastorNonLayoutableChildren(String[] dummy) {
    }

    @Override
    public boolean verify() {
        boolean isCorrect = super.verify();
        GraphableVertex[] vChildren = this.getChildren();
        for (int i = 0; i < vChildren.length; ++i) {
            WfVertexDef wfvChild = (WfVertexDef)vChildren[i];
            if (wfvChild.verify()) continue;
            this.mErrors.add(wfvChild.getName() + ": " + wfvChild.getErrors());
            isCorrect = false;
        }
        if (!isCorrect) {
            log.error("verify() - errors:{}", (Object)this.getErrors());
        }
        return isCorrect;
    }

    @Override
    public void export(Writer imports, File dir, boolean shallow) throws InvalidDataException, ObjectNotFoundException, IOException {
        this.export(imports, dir, shallow, true);
    }

    public void export(Writer imports, File dir, boolean shallow, boolean rebuild) throws InvalidDataException, ObjectNotFoundException, IOException {
        if (rebuild) {
            List<ActivityDef> list = this.findRefActDefs(this.getChildrenGraphModel(), null);
            this.setRefChildActDef(list);
        }
        if (!shallow) {
            for (GraphableVertex vert : this.getChildren()) {
                if (vert instanceof AndSplitDef) {
                    try {
                        ((AndSplitDef)vert).getRoutingScript(null).export(imports, dir, shallow);
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {}
                    continue;
                }
                if (!(vert instanceof ActivitySlotDef)) continue;
                ActivityDef refAct = ((ActivitySlotDef)vert).getTheActivityDef(null);
                refAct.export(imports, dir, shallow);
            }
        }
        String string = this.getResourceType().getTypeCode();
        try {
            String compactXML = new Outcome(Gateway.getMarshaller().marshall(this)).getData(true);
            if (SystemProperties.Export_replaceActivitySlotDefUUIDWithName.getBoolean().booleanValue()) {
                compactXML = this.replaceActivitySlotDefUUIDWithName(compactXML);
            }
            FileStringUtility.string2File(new File(new File(dir, string), this.getActName() + (String)(this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml"), compactXML);
        }
        catch (XPathExpressionException e) {
            throw new InvalidDataException("Couldn't export CompositeActivityDef:" + this.getActName(), (Throwable)e);
        }
        if (imports != null) {
            imports.write("<Workflow " + this.getExportAttributes(string) + ">" + this.getExportCollections());
            for (ActivityDef childActDef : this.refChildActDef) {
                imports.write("<Activity name=\"" + childActDef.getActName() + "\" id=\"" + childActDef.getItemID() + "\" version=\"" + childActDef.getVersion() + "\"/>");
            }
            imports.write("</Workflow>\n");
        }
    }

    @Override
    public BuiltInResources getResourceType() {
        return BuiltInResources.COMP_ACT_DESC_RESOURCE;
    }

    private String replaceActivitySlotDefUUIDWithName(String compactXML) throws InvalidDataException, XPathExpressionException, ObjectNotFoundException {
        Outcome outcome = new Outcome(compactXML);
        NodeList nodeList = outcome.getNodesByXPath("/CompositeActivityDef/childrenGraphModel/GraphModelCastorData/ActivitySlotDef");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node activityDefNode = (Node)outcome.evaluateXpath(nodeList.item(i), "activityDef/text()", XPathConstants.NODE);
            String syskey = activityDefNode.getNodeValue();
            log.debug("replaceActivitySlotDefUUIDWithName(name:{}) - replacing UIID:{}", (Object)this.getActName(), (Object)syskey);
            try {
                if (StringUtils.isNotBlank((CharSequence)syskey) && ItemPath.isUUID(syskey)) {
                    ItemPath itemPath = Gateway.getLookup().getItemPath(syskey);
                    String itemName = Gateway.getProxy(itemPath).getName();
                    activityDefNode.setNodeValue(itemName);
                    log.debug("replaceActivitySlotDefUUIDWithName(name:{}) - replaced UIID:{} with name:{}", new Object[]{this.getActName(), syskey, itemName});
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)syskey)) continue;
                log.trace("replaceActivitySlotDefUUIDWithName(name:{}) - UIID:{} was not replaced - not null & neither UUID", (Object)this.getActName(), (Object)syskey);
                continue;
            }
            catch (Exception e) {
                String actDefName;
                Node actDefNameNode = (Node)outcome.evaluateXpath(nodeList.item(i), "Properties/KeyValuePair[@Key='" + String.valueOf((Object)BuiltInVertexProperties.ACTIVITY_DEF_NAME) + "']", XPathConstants.NODE);
                String string = actDefName = actDefNameNode == null ? null : actDefNameNode.getAttributes().getNamedItem("String").getNodeValue();
                if (StringUtils.isBlank(actDefName) && !(actDefName = ((Node)outcome.evaluateXpath(nodeList.item(i), "Properties/KeyValuePair[@Key='Name']", XPathConstants.NODE)).getAttributes().getNamedItem("String").getNodeValue()).contains("_")) {
                    actDefName = null;
                }
                if (StringUtils.isNotBlank((CharSequence)actDefName)) {
                    activityDefNode.setNodeValue(actDefName);
                    log.debug("replaceActivitySlotDefUUIDWithName(name:{}) - replaced UIID:{} with name:{}", new Object[]{this.getActName(), syskey, actDefName});
                    continue;
                }
                log.error("replaceActivitySlotDefUUIDWithName() - Cannot find item with UIID:{} with Name property={}", new Object[]{syskey, actDefName, e});
                throw new ObjectNotFoundException("Cannot find item with UIID: " + nodeList.item(i).getNodeValue());
            }
        }
        return outcome.getData(true);
    }
}

