/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.utils.KeyValuePair;

public abstract class WfVertexDef
extends GraphableVertex {
    public Vector<String> mErrors = new Vector(0, 1);
    protected boolean loopTested;

    public WfVertexDef() {
        this.setIsLayoutable(true);
    }

    public abstract WfVertex instantiate(TransactionKey var1) throws ObjectNotFoundException, InvalidDataException;

    public void configureInstance(WfVertex newVertex, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        for (KeyValuePair element : this.getProperties().getKeyValuePairs()) {
            newVertex.getProperties().put(element.getKey(), element.getValue(), element.isAbstract());
        }
        newVertex.setID(this.getID());
        if (this.getIsLayoutable()) {
            newVertex.setInEdgeIds(this.getInEdgeIds());
            newVertex.setOutEdgeIds(this.getOutEdgeIds());
            newVertex.setCentrePoint(this.getCentrePoint());
            newVertex.setOutlinePoints(this.getOutlinePoints());
        }
    }

    public abstract boolean verify();

    public String getErrors() {
        if (this.mErrors.size() == 0) {
            return "No error";
        }
        if (this.mErrors.size() == 1) {
            return this.mErrors.elementAt(0);
        }
        StringBuffer errorBuffer = new StringBuffer();
        for (String error : this.mErrors) {
            if (errorBuffer.length() > 0) {
                errorBuffer.append(", ");
            }
            errorBuffer.append(error);
        }
        return errorBuffer.toString();
    }

    public boolean loop() {
        boolean loop2 = false;
        if (!this.loopTested) {
            this.loopTested = true;
            if (this.getOutGraphables().length != 0) {
                loop2 = ((WfVertexDef)this.getOutGraphables()[0]).loop();
            }
        }
        this.loopTested = false;
        return loop2;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (StringUtils.isNotBlank((CharSequence)this.getName()) ? "name:" + this.getName() : "id:" + this.getID()) + ")";
    }
}

