/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.WfCastorHashMap;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.stateMachine.State;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.OutcomeAttachment;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.DateUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Activity
extends WfVertex {
    private static final Logger log = LoggerFactory.getLogger(Activity.class);
    public static final String PREDEF_STEPS_ELEMENT = "PredefinedSteps";
    protected static final String XPATH_TOKEN = "xpath:";
    protected Vector<String> mErrors;
    private StateMachine machine;
    protected int state = -1;
    public boolean active = false;
    private boolean loopTested;
    private GTimeStamp mStateDate;
    private String mType;
    private String mTypeName;

    public Activity() {
        this.setProperties(new WfCastorHashMap());
        this.mErrors = new Vector(0, 1);
        this.mStateDate = new GTimeStamp();
        DateUtility.setToNow(this.mStateDate);
    }

    Next addNext(String idNext) {
        return this.addNext((WfVertex)this.getParent().search(idNext));
    }

    @Override
    public Next addNext(WfVertex vertex) {
        return new Next(this, vertex);
    }

    public StateMachine getStateMachine() throws InvalidDataException {
        return this.getStateMachine(null);
    }

    public StateMachine getStateMachine(TransactionKey transKey) throws InvalidDataException {
        if (this.machine == null) {
            try {
                this.machine = LocalObjectLoader.getStateMachine(this.getProperties(), transKey);
            }
            catch (ObjectNotFoundException e) {
                throw new InvalidDataException(e);
            }
        }
        return this.machine;
    }

    public int getState() throws InvalidDataException {
        if (this.state == -1) {
            this.state = this.getStateMachine().getInitialStateCode();
        }
        return this.state;
    }

    public int getErrorTransitionId() {
        try {
            return this.getStateMachine().getErrorTransitionIdForState(this.getState());
        }
        catch (InvalidDataException e) {
            return -1;
        }
    }

    public String getStateName() throws InvalidDataException {
        return this.getStateMachine().getState(this.getState()).getName();
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isFinished() throws InvalidDataException {
        return this.getStateMachine().getState(this.getState()).isFinished();
    }

    public String request(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, String attachmentType, byte[] attachment, TransactionKey transactionKey) throws AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, InvalidCollectionModification {
        boolean validateOutcomeDefault = SystemProperties.Activity_validateOutcome.getBoolean();
        boolean validateOutcome = (Boolean)this.getBuiltInProperty(BuiltInVertexProperties.VALIDATE_OUTCOME, validateOutcomeDefault);
        return this.request(agent, itemPath, transitionID, requestData, attachmentType, attachment, validateOutcome, transactionKey);
    }

    public String request(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, String attachmentType, byte[] attachment, boolean validateOutcome, TransactionKey transactionKey) throws AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, InvalidCollectionModification {
        Transition transition = this.getStateMachine().getTransition(transitionID);
        log.trace("request() - {}/{} trans:{}", new Object[]{itemPath.getItemName(), this, transition});
        transition.checkPerformingRole(this, agent);
        boolean storeOutcome = false;
        if (transition.hasOutcome(this.getProperties())) {
            if (StringUtils.isNotBlank((CharSequence)requestData)) {
                storeOutcome = true;
            } else if (transition.getOutcome().isRequired()) {
                throw new InvalidDataException("Transition requires outcome data, but none was given");
            }
        }
        State oldState = this.getStateMachine().getState(this.state);
        State newState = this.getStateMachine().traverse(this, transition, agent);
        String outcome = this.runActivityLogic(agent, itemPath, transitionID, requestData, transactionKey);
        this.setState(newState.getId());
        this.setBuiltInProperty(BuiltInVertexProperties.AGENT_NAME, transition.getReservation(this, agent));
        History hist = new History(itemPath, transactionKey);
        if (storeOutcome) {
            Schema schema = transition.getSchema(this.getProperties());
            Outcome newOutcome = new Outcome(-1, outcome, schema);
            if (validateOutcome) {
                newOutcome.validateAndCheck();
            }
            this.executePredefinedSteps(agent, itemPath, newOutcome, transactionKey);
            String viewpoint = this.resolveViewpointName(newOutcome);
            boolean hasAttachment = attachment.length > 0;
            int eventID = hist.addEvent(agent, null, this.getName(), this.getPath(), this.getType(), schema, this.getStateMachine(), transitionID, viewpoint, hasAttachment).getID();
            newOutcome.setID(eventID);
            Gateway.getStorage().put(itemPath, newOutcome, transactionKey);
            if (hasAttachment) {
                Gateway.getStorage().put(itemPath, new OutcomeAttachment(itemPath, newOutcome, attachmentType, attachment), transactionKey);
            }
            if (!viewpoint.equals("last")) {
                Gateway.getStorage().put(itemPath, new Viewpoint(itemPath, schema, viewpoint, eventID), transactionKey);
            }
            Gateway.getStorage().put(itemPath, new Viewpoint(itemPath, schema, "last", eventID), transactionKey);
            this.updateItemProperties(itemPath, newOutcome, transactionKey);
        } else {
            this.updateItemProperties(itemPath, null, transactionKey);
            hist.addEvent(agent, null, this.getName(), this.getPath(), this.getType(), this.getStateMachine(), transitionID);
        }
        boolean breakPoint = (Boolean)this.getBuiltInProperty(BuiltInVertexProperties.BREAKPOINT, Boolean.FALSE);
        if (newState.isFinished() && !oldState.isFinished() && !breakPoint) {
            this.runNext(transactionKey);
        } else {
            DateUtility.setToNow(this.mStateDate);
        }
        return outcome;
    }

    private void executePredefinedSteps(AgentPath agent, ItemPath itemPath, Outcome newOutcome, TransactionKey transactionKey) throws AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, InvalidCollectionModification {
        try {
            Node predefinedStepsNode = newOutcome.getNodeByXPath("/" + newOutcome.getRootName() + "/PredefinedSteps");
            if (predefinedStepsNode == null) {
                return;
            }
            NodeList predefinedStepsChildNodes = predefinedStepsNode.getChildNodes();
            for (int i = 0; i < predefinedStepsChildNodes.getLength(); ++i) {
                if (predefinedStepsChildNodes.item(i).getNodeType() != 1) continue;
                Node predefStepNode = predefinedStepsChildNodes.item(i);
                String predefStepName = predefStepNode.getNodeName();
                PredefinedStep predefStep = PredefinedStep.getStepInstance(predefStepName.trim());
                Objects.requireNonNull(predefStep, "Outome does not contain valid PredefinedStep:" + predefStepName + " outcome:" + String.valueOf(newOutcome));
                Node predefSteptOutcomeNode = predefStep.getPredefStepOutcomeNode(predefStepNode);
                Objects.requireNonNull(predefSteptOutcomeNode, "Outome does not contain data to execute PredefinedStep:" + predefStepName + " outcome:" + String.valueOf(newOutcome));
                predefStep.computeUpdates(itemPath, this, predefSteptOutcomeNode, transactionKey);
                for (Map.Entry<ItemPath, String> entry : predefStep.getAutoUpdates().entrySet()) {
                    predefStep.request(agent, entry.getKey(), entry.getValue(), transactionKey);
                }
            }
        }
        catch (XPathExpressionException e) {
            log.error("executePredefinedSteps()", (Throwable)e);
        }
    }

    private String resolveViewpointName(Outcome outcome) throws InvalidDataException {
        String viewpointString = (String)this.getBuiltInProperty(BuiltInVertexProperties.VIEW_POINT);
        log.debug("resolveViewpointName() - act:{} viewpointString:{}", (Object)this.getName(), (Object)viewpointString);
        if (StringUtils.isBlank((CharSequence)viewpointString)) {
            viewpointString = "last";
        } else if (viewpointString.startsWith(XPATH_TOKEN)) {
            try {
                viewpointString = outcome.getFieldByXPath(viewpointString.substring(XPATH_TOKEN.length()));
            }
            catch (XPathExpressionException e) {
                throw new InvalidDataException(e.getMessage());
            }
        }
        if (StringUtils.isBlank((CharSequence)viewpointString)) {
            throw new InvalidDataException("Resolved viewpoint name cannot be blank for activity:" + this.getName());
        }
        return viewpointString;
    }

    private void updateItemProperties(ItemPath itemPath, Outcome outcome, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectCannotBeUpdated, ObjectNotFoundException {
        for (Map.Entry entry : this.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith("ItemProperty.")) continue;
            String propName = ((String)entry.getKey()).substring(13);
            if (StringUtils.isNotBlank((CharSequence)propName)) {
                if (propName.equals(BuiltInItemProperties.NAME.getName())) {
                    throw new InvalidDataException("Use ChangeName predef step");
                }
                String propValue = entry.getValue().toString();
                if (outcome != null && StringUtils.isNotBlank((CharSequence)propValue) && propValue.startsWith(XPATH_TOKEN)) {
                    try {
                        propValue = outcome.getFieldByXPath(propValue.substring(XPATH_TOKEN.length()));
                    }
                    catch (XPathExpressionException e) {
                        throw new InvalidDataException(e.getMessage());
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)propValue)) continue;
                PropertyUtility.writeProperty(itemPath, propName, propValue, transactionKey);
                continue;
            }
            throw new InvalidDataException("Incomplete vertex property name:" + (String)entry.getKey());
        }
    }

    protected String runActivityLogic(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException, ObjectCannotBeUpdated, ObjectNotFoundException, PersistencyException, CannotManageException, AccessRightsException {
        return requestData;
    }

    @Override
    public boolean verify() {
        this.mErrors.removeAllElements();
        int nbInEdgres = this.getInEdges().length;
        int nbOutEdges = this.getOutEdges().length;
        if (nbInEdgres == 0 && this.getID() != this.getParent().getChildrenGraphModel().getStartVertexId()) {
            this.mErrors.add("Unreachable");
            return false;
        }
        if (nbInEdgres > 1) {
            this.mErrors.add("Bad nb of previous");
            return false;
        }
        if (nbOutEdges > 1) {
            this.mErrors.add("too many next");
            return false;
        }
        if (nbOutEdges == 0 && !this.getParentCA().hasGoodNumberOfActivity()) {
            this.mErrors.add("too many endpoints");
            return false;
        }
        return true;
    }

    @Override
    public boolean loop() {
        boolean loop2 = false;
        if (!this.loopTested) {
            this.loopTested = true;
            if (this.getOutGraphables().length != 0) {
                loop2 = ((WfVertex)this.getOutGraphables()[0]).loop();
            }
        }
        this.loopTested = false;
        return loop2;
    }

    private CompositeActivity getParentCA() {
        GraphableVertex theParent = this.getParent();
        if (theParent != null) {
            return (CompositeActivity)theParent;
        }
        return null;
    }

    @Override
    public void runNext(TransactionKey transactionKey) throws InvalidDataException {
        CompositeActivity parent;
        log.trace("runNext() - {}", (Object)this);
        this.setActive(false);
        Vertex[] outVertices = this.getOutGraphables();
        if (outVertices.length > 0) {
            ((WfVertex)outVertices[0]).run(transactionKey);
        }
        if ((parent = this.getParentCA()).isFinishable(this.findLastVertex())) {
            parent.runNext(transactionKey);
        }
    }

    public Next getNext() {
        if (this.getOutEdges().length > 0) {
            return (Next)this.getOutEdges()[0];
        }
        return null;
    }

    @Override
    public void reinit(int idLoop) throws InvalidDataException {
        log.trace("reinit(id:{}, idLoop:{}) - parent:{} act:{}", new Object[]{this.getID(), idLoop, this.getParent().getName(), this.getPath()});
        this.setState(this.getStateMachine().getInitialState().getId());
        Vertex[] outVertices = this.getOutGraphables();
        if (outVertices.length > 0 && idLoop != this.getID()) {
            ((WfVertex)outVertices[0]).reinit(idLoop);
        }
    }

    @Override
    public String getErrors() {
        if (this.mErrors.size() == 0) {
            return "No error";
        }
        return this.mErrors.elementAt(0);
    }

    @Override
    public void run(TransactionKey transactionKey) throws InvalidDataException {
        log.trace("run() - {}", (Object)this);
        if (this.isFinished()) {
            this.runNext(transactionKey);
        } else {
            if (!this.getActive()) {
                this.setActive(true);
            }
            DateUtility.setToNow(this.mStateDate);
        }
    }

    @Override
    public void runFirst(TransactionKey transactionKey) throws InvalidDataException {
        log.trace("runFirst() - {}", (Object)this);
        this.run(transactionKey);
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean acti) {
        this.active = acti;
    }

    public String getDescription() {
        if (this.getProperties().containsKey("Description")) {
            return (String)this.getBuiltInProperty(BuiltInVertexProperties.DESCRIPTION);
        }
        return "No description";
    }

    public String getCurrentAgentName() {
        return (String)this.getBuiltInProperty(BuiltInVertexProperties.AGENT_NAME);
    }

    public String getCurrentAgentRole() {
        return (String)this.getBuiltInProperty(BuiltInVertexProperties.AGENT_ROLE);
    }

    public List<Job> calculateJobs(AgentPath agent, ItemPath itemPath, boolean recurse) throws ObjectNotFoundException, InvalidDataException {
        return this.calculateJobsBase(agent, itemPath, false);
    }

    public List<Job> calculateAllJobs(AgentPath agent, ItemPath itemPath, boolean recurse) throws ObjectNotFoundException, InvalidDataException {
        return this.calculateJobsBase(agent, itemPath, true);
    }

    private List<Job> calculateJobsBase(AgentPath agent, ItemPath itemPath, boolean includeInactive) throws ObjectNotFoundException, InvalidDataException {
        log.trace("calculateJobsBase() - act:" + this.getPath());
        ArrayList<Job> jobs = new ArrayList<Job>();
        if ((includeInactive || this.getActive()) && !this.getName().equals("domain")) {
            List<Transition> transitions = this.getStateMachine().getPossibleTransitions(this, agent);
            log.trace("calculateJobsBase() - Got " + transitions.size() + " transitions.");
            for (Transition transition : transitions) {
                log.trace("calculateJobsBase() - Creating Job object for transition " + transition.getName());
                jobs.add(new Job(this, itemPath, transition.getName(), agent, transition.getRoleOverride()));
            }
        }
        return jobs;
    }

    public GTimeStamp getStateDate() {
        return this.mStateDate;
    }

    public void setStateDate(GTimeStamp startDate) {
        this.mStateDate = startDate;
    }

    @Deprecated
    public void setActiveDate(GTimeStamp date) {
    }

    @Deprecated
    public void setStartDate(GTimeStamp date) {
        this.setStateDate(date);
    }

    public String getType() {
        return this.mType;
    }

    public String getTypeName() {
        if (this.mType == null) {
            return null;
        }
        if (this.mTypeName == null) {
            try {
                this.mTypeName = new ItemPath(this.mType).getItemName();
            }
            catch (Exception e) {
                this.mTypeName = this.mType;
            }
        }
        return this.mTypeName;
    }

    public void setType(String type) {
        this.mType = type;
        this.mTypeName = null;
    }

    @Override
    public void abort(AgentPath agent, ItemPath itemPath, TransactionKey transactionKey) throws AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, InvalidCollectionModification {
        this.active = false;
    }

    public String toString() {
        try {
            String active = this.getActive() ? "active" : "inactive";
            State currentState = this.getStateMachine().getState(this.getState());
            return String.format("%s(%s)[%s]", this.getPath(), active, currentState);
        }
        catch (InvalidDataException e) {
            return this.getPath();
        }
    }
}

