/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import java.util.ArrayList;
import java.util.List;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.traversal.GraphTraversal;
import org.cristalise.kernel.lifecycle.LifecycleVertexOutlineCreator;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.AndSplit;
import org.cristalise.kernel.lifecycle.instance.Join;
import org.cristalise.kernel.lifecycle.instance.Loop;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.OrSplit;
import org.cristalise.kernel.lifecycle.instance.Split;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lifecycle.instance.XOrSplit;
import org.cristalise.kernel.lifecycle.instance.stateMachine.State;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.security.BuiltInAuthc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeActivity
extends Activity {
    private static final Logger log = LoggerFactory.getLogger(CompositeActivity.class);

    public CompositeActivity() {
        this.setBuiltInProperty(BuiltInVertexProperties.ABORTABLE, false);
        this.setBuiltInProperty(BuiltInVertexProperties.REPEAT_WHEN, false);
        this.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_NAME, StateMachine.getDefaultStateMachine("Composite"));
        try {
            this.setChildrenGraphModel(new GraphModel(new LifecycleVertexOutlineCreator()));
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        this.setIsComposite(true);
    }

    @Override
    public void setChildrenGraphModel(GraphModel childrenGraph) throws InvalidDataException {
        super.setChildrenGraphModel(childrenGraph);
        childrenGraph.setVertexOutlineCreator(new LifecycleVertexOutlineCreator());
    }

    @Override
    public boolean verify() {
        boolean err = super.verify();
        GraphableVertex[] vChildren = this.getChildren();
        for (int i = 0; i < vChildren.length; ++i) {
            if (((WfVertex)vChildren[i]).verify()) continue;
            this.mErrors.add("error in children");
            return false;
        }
        return err;
    }

    public void initChild(WfVertex vertex, boolean first, GraphPoint point) {
        this.safeAddChild(vertex, point);
        if (first) {
            this.setFirstVertex(vertex.getID());
        }
    }

    public void setFirstVertex(int vertexID) {
        log.debug("setFirstVertex() vertexID:" + vertexID);
        this.getChildrenGraphModel().setStartVertexId(vertexID);
    }

    private void safeAddChild(GraphableVertex v, GraphPoint g) {
        GraphPoint p = null;
        if (g != null) {
            p = new GraphPoint(g.x, g.y);
        }
        this.addChild(v, p);
    }

    public WfVertex newExistingChild(Activity child, String Name, GraphPoint point) {
        child.setName(Name);
        this.safeAddChild(child, point);
        return child;
    }

    public WfVertex newChild(String Name, String Type2, GraphPoint point) {
        WfVertex v = this.newChild(Type2, point);
        v.setName(Name);
        return v;
    }

    public WfVertex newChild(String vertexTypeId, GraphPoint point) {
        return this.newChild(WfVertex.Types.valueOf(vertexTypeId), "False id", false, point);
    }

    public WfVertex newChild(WfVertex.Types type, String name, boolean first, GraphPoint point) {
        switch (type) {
            case Atomic: {
                return this.newAtomChild(name, first, point);
            }
            case Composite: {
                return this.newCompChild(name, first, point);
            }
            case OrSplit: {
                return this.newSplitChild(name, "Or", first, point);
            }
            case XOrSplit: {
                return this.newSplitChild(name, "XOr", first, point);
            }
            case AndSplit: {
                return this.newSplitChild(name, "And", first, point);
            }
            case LoopSplit: {
                return this.newSplitChild(name, "Loop", first, point);
            }
            case Join: {
                return this.newJoinChild(name, "Join", first, point);
            }
            case Route: {
                return this.newJoinChild(name, "Route", first, point);
            }
        }
        throw new IllegalArgumentException("Unhandled enum value of WfVertex.Type:" + type.name());
    }

    public CompositeActivity newCompChild(String id, boolean first, GraphPoint point) {
        CompositeActivity act = new CompositeActivity();
        this.initChild(act, first, point);
        act.setName(id);
        return act;
    }

    public Activity newAtomChild(String id, boolean first, GraphPoint point) {
        Activity act = new Activity();
        this.initChild(act, first, point);
        act.setName(id);
        return act;
    }

    public Split newSplitChild(String name, String Type2, boolean first, GraphPoint point) {
        Split split = null;
        split = Type2.equals("Or") ? new OrSplit() : (Type2.equals("XOr") ? new XOrSplit() : (Type2.equals("Loop") ? new Loop() : new AndSplit()));
        this.initChild(split, first, point);
        split.setName(name);
        return split;
    }

    public Join newJoinChild(String name, String type, boolean first, GraphPoint point) {
        Join join = new Join();
        join.getProperties().put("Type", type);
        this.initChild(join, first, point);
        join.setName(name);
        return join;
    }

    WfVertex search(int id) {
        return (WfVertex)this.getChildrenGraphModel().resolveVertex(id);
    }

    private Transition getStartTransition(AgentPath agent) throws InvalidDataException {
        Transition startTrans = null;
        try {
            for (Transition possTrans : this.getStateMachine().getPossibleTransitions(this, agent)) {
                if (possTrans.isFinishing()) continue;
                if (startTrans == null) {
                    startTrans = possTrans;
                    continue;
                }
                startTrans = null;
                break;
            }
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidDataException("Problem calculating possible transitions for agent " + agent.getAgentName(), (Throwable)e);
        }
        log.trace("getStartTransition({}) - state:{} trans:{}", new Object[]{this.getPath(), this.getStateName(), startTrans});
        return startTrans;
    }

    private Transition getFinishTransition(AgentPath agent) throws InvalidDataException {
        Transition finishTrans = null;
        try {
            for (Transition possTran : this.getStateMachine().getPossibleTransitions(this, agent)) {
                if (finishTrans == null || finishTrans.isFinishing() && !possTran.isFinishing() && !possTran.isBlocking()) {
                    finishTrans = possTran;
                    continue;
                }
                if (finishTrans.isFinishing() != possTran.isFinishing()) continue;
                log.warn("getFinishTransition() - Unclear choice of transition possible CompositeActivity:{} state:{}", (Object)this.getPath(), (Object)this.getStateName());
                return null;
            }
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidDataException("Problem calculating possible transitions for agent " + agent.getAgentName(), (Throwable)e);
        }
        log.trace("getFinishTransition({}) - state:{} trans:{}", new Object[]{this.getPath(), this.getStateName(), finishTrans});
        return finishTrans;
    }

    private AgentPath getSystemAgent(TransactionKey transactionKey) throws InvalidDataException {
        try {
            return (AgentPath)BuiltInAuthc.SYSTEM_AGENT.getPath(transactionKey);
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidDataException("CompAct:" + this.getName(), (Throwable)e);
        }
    }

    private void autoStart(TransactionKey transactionKey) throws InvalidDataException {
        ItemPath itemPath = this.getWf().getItemPath();
        AgentPath agent = this.getSystemAgent(transactionKey);
        Transition autoStart = this.getStartTransition(agent);
        if (autoStart != null) {
            try {
                this.request(agent, itemPath, autoStart.getId(), null, "", null, transactionKey);
            }
            catch (AccessRightsException e) {
                log.warn("autoStart() - Agent:{} didn't have permission to start composite activity:{}", (Object)agent, (Object)this.getPath());
                return;
            }
            catch (InvalidDataException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidDataException("Problem auto starting composite activity:" + this.getPath(), (Throwable)e);
            }
        }
    }

    private void autoFinish(TransactionKey transactionKey) throws InvalidDataException {
        block6: {
            ItemPath itemPath = this.getWf().getItemPath();
            AgentPath agent = this.getSystemAgent(transactionKey);
            Transition trans = this.getFinishTransition(agent);
            if (trans != null) {
                if (trans.hasOutcome(this.getProperties()) || trans.hasScript(this.getProperties())) {
                    log.warn("autoFinish({}) - Cannot finish automatically, it has script or schema defined. ", (Object)this.getName());
                    this.setActive(true);
                    return;
                }
                try {
                    this.request(agent, itemPath, trans.getId(), null, "", null, transactionKey);
                    if (!trans.isFinishing()) {
                        return;
                    }
                    break block6;
                }
                catch (InvalidDataException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error("autoFinish() - Problem completing CompAct:{}", (Object)this.getName(), (Object)e);
                    this.setActive(true);
                    throw new InvalidDataException("Problem completing CompAct:" + this.getName(), (Throwable)e);
                }
            }
            log.trace("Not possible for the current agent to proceed with the Composite Activity '" + this.getName() + "'.");
            this.setActive(true);
        }
    }

    @Override
    public void run(TransactionKey transactionKey) throws InvalidDataException {
        log.trace("run() - {}", (Object)this);
        super.run(transactionKey);
        if (this.isStartable()) {
            this.autoStart(transactionKey);
        }
        if (this.isFinishable()) {
            this.autoFinish(transactionKey);
        }
    }

    protected boolean isStartable() throws InvalidDataException {
        int initialState = this.getStateMachine().getInitialStateCode();
        State currentState = this.getStateMachine().getState(this.state);
        return this.getChildrenGraphModel().getStartVertex() != null && !currentState.isFinished() && initialState == this.state;
    }

    protected boolean isFinishable() throws InvalidDataException {
        Activity act;
        if (this.getName().equals("workflow") || this.getName().equals("domain")) {
            return false;
        }
        WfVertex startVertex = (WfVertex)this.getChildrenGraphModel().getStartVertex();
        if (startVertex instanceof Activity && !(act = (Activity)startVertex).isFinished() && act.active) {
            return false;
        }
        return this.isFinishable(startVertex == null ? null : startVertex.findLastVertex());
    }

    protected boolean isFinishable(WfVertex lastVertex) throws InvalidDataException {
        if (this.getName().equals("workflow") || this.getName().equals("domain")) {
            return false;
        }
        if (lastVertex == null) {
            return true;
        }
        if (lastVertex instanceof Join) {
            return this.getPossibleActs(lastVertex, 1).size() == 0;
        }
        if (lastVertex instanceof Loop) {
            return this.getPossibleActs(lastVertex, 2).size() == 0;
        }
        if (lastVertex instanceof Activity) {
            Activity act = (Activity)lastVertex;
            return act.isFinished() && !act.active;
        }
        return false;
    }

    @Override
    public void runNext(TransactionKey transactionKey) throws InvalidDataException {
        log.trace("runNext() - {}", (Object)this);
        if (!this.isFinished()) {
            this.autoFinish(transactionKey);
        }
        super.runNext(transactionKey);
    }

    public ArrayList<Job> calculateJobs(AgentPath agent, ItemPath itemPath, boolean recurse) throws ObjectNotFoundException, InvalidDataException {
        ArrayList<Job> jobs = new ArrayList<Job>();
        boolean childActive = false;
        if (recurse) {
            for (int i = 0; i < this.getChildren().length; ++i) {
                if (!(this.getChildren()[i] instanceof Activity)) continue;
                Activity child = (Activity)this.getChildren()[i];
                jobs.addAll(child.calculateJobs(agent, itemPath, recurse));
                childActive |= child.active;
            }
        }
        if (!childActive) {
            jobs.addAll(super.calculateJobs(agent, itemPath, recurse));
        }
        return jobs;
    }

    public ArrayList<Job> calculateAllJobs(AgentPath agent, ItemPath itemPath, boolean recurse) throws ObjectNotFoundException, InvalidDataException {
        ArrayList<Job> jobs = new ArrayList<Job>();
        if (recurse) {
            for (int i = 0; i < this.getChildren().length; ++i) {
                if (!(this.getChildren()[i] instanceof Activity)) continue;
                Activity child = (Activity)this.getChildren()[i];
                jobs.addAll(child.calculateAllJobs(agent, itemPath, recurse));
            }
        }
        jobs.addAll(super.calculateAllJobs(agent, itemPath, recurse));
        return jobs;
    }

    public Next addNext(WfVertex origin, WfVertex terminus) {
        return new Next(origin, terminus);
    }

    public Next addNext(int originID, int terminusID) {
        return this.addNext(this.search(originID), this.search(terminusID));
    }

    public boolean hasGoodNumberOfActivity() {
        int endingAct = 0;
        for (int i = 0; i < this.getChildren().length; ++i) {
            WfVertex vertex = (WfVertex)this.getChildren()[i];
            if (this.getChildrenGraphModel().getOutEdges(vertex).length != 0) continue;
            ++endingAct;
        }
        return endingAct <= true;
    }

    @Override
    public String getType() {
        return super.getType();
    }

    @Override
    public void reinit(int idLoop) throws InvalidDataException {
        super.reinit(idLoop);
        if (this.getChildrenGraphModel().getStartVertex() != null && !this.getStateMachine().getState(this.state).isFinished()) {
            ((WfVertex)this.getChildrenGraphModel().getStartVertex()).reinit(idLoop);
        }
    }

    @Override
    public void abort(AgentPath agentPath, ItemPath itemPath, TransactionKey transactionKey) throws AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, InvalidCollectionModification {
        StateMachine sm = this.getStateMachine();
        int abortId = sm.getTransition("Abort").getId();
        for (GraphableVertex childV : this.getChildren()) {
            if (childV instanceof CompositeActivity) {
                CompositeActivity ca = (CompositeActivity)childV;
                if (!ca.active) continue;
                ca.request(agentPath, itemPath, abortId, "", "", new byte[0], transactionKey);
                ca.setActive(false);
                continue;
            }
            ((WfVertex)childV).abort(agentPath, itemPath, transactionKey);
        }
    }

    public boolean hasActive() {
        GraphableVertex[] vChildren = this.getChildren();
        for (int i = 0; i < vChildren.length; ++i) {
            if (!(vChildren[i] instanceof Activity)) continue;
            Activity childAct = (Activity)vChildren[i];
            if (childAct.getActive()) {
                return true;
            }
            if (!(childAct instanceof CompositeActivity) || !((CompositeActivity)vChildren[i]).hasActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String request(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, String attachmentType, byte[] attachment, TransactionKey transactionKey) throws AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, InvalidCollectionModification {
        StateMachine sm = this.getStateMachine();
        Transition trans = sm.getTransition(transitionID);
        log.trace("request() - {}/{} trans:{}", new Object[]{itemPath.getItemName(), this, trans});
        if ((trans.isFinishing() || trans.isBlocking()) && this.hasActive()) {
            if (((Boolean)this.getBuiltInProperty(BuiltInVertexProperties.ABORTABLE)).booleanValue()) {
                this.abort(agent, itemPath, transactionKey);
            } else {
                throw new InvalidTransitionException("Attempted to finish '" + this.getPath() + "' it had active children but was not Abortable");
            }
        }
        if (trans.reinitializes()) {
            int preserveState = this.state;
            this.reinit(this.getID());
            this.setState(preserveState);
        }
        boolean initChldren = sm.getState(this.state).equals(sm.getInitialState()) || trans.reinitializes();
        String result = super.request(agent, itemPath, transitionID, requestData, attachmentType, attachment, transactionKey);
        if (initChldren) {
            Vertex startVertex = this.getChildrenGraphModel().getStartVertex();
            if (startVertex != null) {
                ((WfVertex)startVertex).runFirst(transactionKey);
            } else {
                log.debug("request({}) has NO start vertex", (Object)this.getPath());
            }
        }
        return result;
    }

    public List<Activity> getPossibleActs(WfVertex fromVertex, int direction) throws InvalidDataException {
        ArrayList<Activity> nextActs = new ArrayList<Activity>();
        for (Vertex v : GraphTraversal.getTraversal(this.getChildrenGraphModel(), fromVertex, direction, false)) {
            Activity act;
            if (!(v instanceof Activity) || (act = (Activity)v).isFinished() || !act.active) continue;
            nextActs.add(act);
        }
        return nextActs;
    }
}

