/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import java.util.ArrayList;
import java.util.Arrays;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.graph.model.BuiltInEdgeProperties;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.Split;
import org.cristalise.kernel.persistency.TransactionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrSplit
extends Split {
    private static final Logger log = LoggerFactory.getLogger(OrSplit.class);

    @Override
    public void runNext(TransactionKey transactionKey) throws InvalidDataException {
        int id = this.getID();
        Object[] nextsTab = this.calculateNexts(transactionKey);
        ArrayList<DirectedEdge> nextsToFollow = new ArrayList<DirectedEdge>();
        log.trace("runNext(id:{}) - Finding edge with {} '{}'", new Object[]{id, BuiltInEdgeProperties.ALIAS, Arrays.toString(nextsTab)});
        for (DirectedEdge outEdge : this.getOutEdges()) {
            String alias = (String)((Next)outEdge).getBuiltInProperty(BuiltInEdgeProperties.ALIAS, "");
            if (!this.isInTable(alias, (String[])nextsTab)) continue;
            nextsToFollow.add(outEdge);
        }
        if (nextsToFollow.size() == 0) {
            throw new InvalidDataException("No edges found, no next vertex activated! (id: " + id + ")");
        }
        for (DirectedEdge edge : nextsToFollow) {
            Next next = (Next)edge;
            log.trace("runNext(id:{}) - Running Alias:{}", (Object)id, next.getBuiltInProperty(BuiltInEdgeProperties.ALIAS));
            next.getTerminusVertex().run(transactionKey);
        }
    }
}

