/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Join;
import org.cristalise.kernel.lifecycle.instance.Loop;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.Split;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.routingHelpers.DataHelperUtility;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WfVertex
extends GraphableVertex {
    private static final Logger log = LoggerFactory.getLogger(WfVertex.class);

    public WfVertex() {
        this.setIsLayoutable(true);
        this.setIsComposite(false);
    }

    public abstract void runFirst(TransactionKey var1) throws InvalidDataException;

    public abstract void runNext(TransactionKey var1) throws InvalidDataException;

    public abstract void reinit(int var1) throws InvalidDataException;

    public abstract void run(TransactionKey var1) throws InvalidDataException;

    public void abort(AgentPath agent, ItemPath itemPath, TransactionKey transactionKey) throws AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, InvalidCollectionModification {
    }

    public abstract boolean verify();

    public abstract String getErrors();

    public abstract boolean loop();

    public String getActContext() {
        return this.getPath().substring(0, this.getPath().lastIndexOf(47));
    }

    public abstract Next addNext(WfVertex var1);

    public Object evaluateProperty(ItemPath itemPath, String propName, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        return this.evaluatePropertyValue(itemPath, this.getProperties().get(propName), transactionKey);
    }

    public Object evaluatePropertyValue(ItemPath itemPath, Object propValue, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        if (itemPath == null) {
            itemPath = this.getWf().getItemPath();
        }
        return DataHelperUtility.evaluateValue(itemPath, propValue, this.getActContext(), transactionKey);
    }

    protected Object evaluateScript(String scriptName, Integer scriptVersion, ItemPath itemPath, TransactionKey transactionKey) throws ScriptingEngineException {
        try {
            if (itemPath == null) {
                itemPath = this.getWf().getItemPath();
            }
            Script script = Script.getScript(scriptName, scriptVersion);
            return script.evaluate(itemPath, this.getProperties(), this.getActContext(), transactionKey);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new ScriptingEngineException(e.getMessage());
        }
    }

    public Workflow getWf() {
        return ((CompositeActivity)this.getParent()).getWf();
    }

    protected GraphableVertex findPair() {
        String pairingID = this.getPairingId();
        if (StringUtils.isBlank((CharSequence)pairingID)) {
            log.warn("findPair() - vertex:{} has no valid PairingID", (Object)this.getName());
            return null;
        }
        for (GraphableVertex vertex : this.getParent().getLayoutableChildren()) {
            if (!pairingID.equals(vertex.getPairingId()) || vertex.equals(this)) continue;
            return vertex;
        }
        return null;
    }

    protected WfVertex findLastVertex() {
        Vertex[] outVertices = this.getOutGraphables();
        boolean cont = outVertices.length > 0;
        WfVertex lastVertex = null;
        while (cont) {
            lastVertex = (WfVertex)outVertices[0];
            if (lastVertex instanceof Join || lastVertex instanceof Activity) {
                outVertices = lastVertex.getOutGraphables();
                cont = outVertices.length > 0;
                lastVertex = cont ? (WfVertex)outVertices[0] : lastVertex;
                continue;
            }
            if (lastVertex instanceof Loop) {
                String pairingId = lastVertex.getPairingId();
                if (StringUtils.isNotBlank((CharSequence)pairingId)) {
                    Join outJoin = (Join)Arrays.stream(lastVertex.getOutGraphables()).filter(v -> !pairingId.equals(((WfVertex)v).getPairingId())).findFirst().get();
                    outVertices = outJoin.getOutGraphables();
                    cont = outVertices.length > 0;
                    lastVertex = outJoin;
                    continue;
                }
                log.warn("findLastVertex() - Loop(id:{}) does not have ParingId", (Object)lastVertex.getID());
                cont = false;
                continue;
            }
            if (lastVertex instanceof Split) {
                GraphableVertex pairVertex = lastVertex.findPair();
                if (pairVertex != null) {
                    Join splitJoin = (Join)pairVertex;
                    outVertices = splitJoin.getOutGraphables();
                    cont = outVertices.length > 0;
                    lastVertex = splitJoin;
                    continue;
                }
                log.warn("findLastVertex() - Split(id:{}) does not have ParingId", (Object)lastVertex.getID());
                cont = false;
                continue;
            }
            cont = false;
        }
        return lastVertex;
    }

    public static enum Types {
        Atomic,
        LocalAtomic,
        Composite,
        LocalComposite,
        OrSplit,
        XOrSplit,
        AndSplit,
        LoopSplit,
        Join,
        Route;

    }
}

