/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.ManageMembersOfCollectionBase;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddMembersToCollection
extends ManageMembersOfCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(AddMembersToCollection.class);
    public static final String description = "Adds many members to the named Collection of the Item";

    public AddMembersToCollection() {
        super("Dependency", description);
    }

    @Override
    protected void checkCardinatilyConstraint(Dependency currentDependency, Dependency inputDependency, ItemPath itemPath, TransactionKey transactionKey) throws InvalidDataException, InvalidCollectionModification {
        Collection.Cardinality currentDepCardinality = currentDependency.getCardinality();
        if (currentDepCardinality != null) {
            switch (currentDepCardinality) {
                case OneToOne: 
                case ManyToOne: {
                    Object errorMsg = null;
                    if (currentDependency.getMembers().list.size() != 0) {
                        errorMsg = "Cannot add new members";
                    } else if (inputDependency.getMembers().list.size() != 1) {
                        errorMsg = "Cannot add more than one member";
                    }
                    if (errorMsg == null) break;
                    errorMsg = (String)errorMsg + " - " + String.valueOf(currentDependency) + " of item " + itemPath.getItemName(transactionKey);
                    log.error("runActivityLogic() - {}", errorMsg);
                    throw new InvalidCollectionModification((String)errorMsg);
                }
                case OneToMany: 
                case ManyToMany: {
                    break;
                }
                default: {
                    String msg = "Unknown cardinality - " + String.valueOf(currentDependency) + " of item " + itemPath.getItemName(transactionKey);
                    log.error("runActivityLogic() - {}", (Object)msg);
                    throw new InvalidDataException(msg);
                }
            }
        }
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectAlreadyExistsException, PersistencyException, ObjectNotFoundException, InvalidCollectionModification {
        ItemProxy item = Gateway.getProxy(itemPath, transactionKey);
        log.debug("runActivityLogic() - item:{} requestdata:{}", (Object)item, (Object)requestData);
        Dependency inputDependency = (Dependency)Gateway.getMarshaller().unmarshall(requestData);
        String collectionName = inputDependency.getName();
        Dependency currentDependency = (Dependency)item.getCollection(collectionName, null, transactionKey);
        log.debug("runActivityLogic() - Changing {} of item:{}", (Object)currentDependency, (Object)item);
        this.checkCardinatilyConstraint(currentDependency, inputDependency, itemPath, transactionKey);
        for (DependencyMember inputMember : inputDependency.getMembers().list) {
            CastorHashMap inputMemberProps = inputMember.getProperties();
            DependencyMember newMember = null;
            newMember = inputMemberProps.size() != 0 ? currentDependency.createMember(inputMember.getItemPath(), inputMemberProps, transactionKey) : currentDependency.createMember(inputMember.getItemPath(), transactionKey);
            this.evaluateScript(itemPath, currentDependency, newMember, transactionKey);
            currentDependency.addMember(newMember);
        }
        Gateway.getStorage().put(itemPath, currentDependency, transactionKey);
        return Gateway.getMarshaller().marshall(currentDependency);
    }

    protected void evaluateScript(ItemPath item, Dependency dependency, DependencyMember newMember, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException, InvalidCollectionModification {
        if (dependency.containsBuiltInProperty(BuiltInVertexProperties.MEMBER_ADD_SCRIPT)) {
            CastorHashMap scriptProps = new CastorHashMap();
            scriptProps.put("collection", dependency);
            scriptProps.put("member", newMember);
            this.evaluateScript(item, (String)dependency.getBuiltInProperty(BuiltInVertexProperties.MEMBER_ADD_SCRIPT), scriptProps, transactionKey);
        }
    }
}

